/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.classifier.smartsmodule;

import com.ibm.smarts.common.pipeline.DeltaAnalysisScope;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.internal.ontology.api.Ontology;
import com.ibm.smarts.ontology.classifier.smartsmodule.AbstractSmartsModuleClassificationStep;
import com.ibm.smarts.ontology.classifier.smartsmodule.SmartsModuleClassificationPkg;
import com.ibm.smarts.ontology.reasoner.DataHintEvaluator;
import com.ibm.smarts.schema.ColumnInfo;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;

public class CandidateElectionViaData
extends AbstractSmartsModuleClassificationStep {
    private List<Ontology<OWLOntology>> mOntologies = null;

    CandidateElectionViaData(List<Ontology<OWLOntology>> ontologies, RequestContext requestContext) {
        super(requestContext);
        this.mOntologies = ontologies;
    }

    @Override
    public void execute(SmartsModuleClassificationPkg smPkg) {
        smPkg.getDatasetClassificationPkgs().forEach(this::classify);
        this.clearMDC();
    }

    private void classify(SmartsModuleClassificationPkg.DatasetClassificationPkg dsPkg) {
        this.mdcDSInfo(dsPkg);
        List<SmartsModuleClassificationPkg.ColumnClassificationPkg> inScopeColPkgs = dsPkg.getInScopeColumnClassificationPkgs();
        if (inScopeColPkgs.isEmpty()) {
            return;
        }
        if (this.isExecParallel()) {
            IntStream.range(0, inScopeColPkgs.size()).parallel().forEach(i -> this.classify(i, (SmartsModuleClassificationPkg.ColumnClassificationPkg)inScopeColPkgs.get(i), dsPkg.getDelatAnalysisScope()));
        } else {
            IntStream.range(0, inScopeColPkgs.size()).forEach(i -> this.classify(i, (SmartsModuleClassificationPkg.ColumnClassificationPkg)inScopeColPkgs.get(i), dsPkg.getDelatAnalysisScope()));
        }
    }

    private void classify(int index, SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, DeltaAnalysisScope deltaAnalysisScope) {
        if (this.shouldExecute(columnPkg, deltaAnalysisScope, DeltaAnalysisScope.ModifiableProperty.ALL)) {
            List<String> cleanedSampleData;
            this.mdcColInfo(index, columnPkg);
            ColumnInfo column = columnPkg.getColumnInfo();
            LOGGER.info("Classify column [{}]:{}", (Object)index, (Object)column.getName());
            if (columnPkg.getColumnInfo().getDataType().isString() && !(cleanedSampleData = this.getCleanedSampleData(columnPkg.getColumnInfo())).isEmpty()) {
                Map<String, Float> potentialCandidates = DataHintEvaluator.matchIndividuals(this.currentReqCtx, cleanedSampleData);
                List candidates = potentialCandidates.entrySet().stream().filter(e -> Float.compare(((Float)e.getValue()).floatValue(), 0.5f) > 0).filter(e -> !((String)e.getKey()).startsWith("http://www.ibm.com/ontologies/waca/application")).filter(e -> CandidateElectionViaData.inDetectedDomains(this.mOntologies, (String)e.getKey())).map(e -> new SmartsModuleClassificationPkg.Candidate(IRI.create((String)((String)e.getKey()))).setRelevance(0.01f).setDataHintRelevance(((Float)e.getValue()).floatValue()).setDataValueRelevance(((Float)e.getValue()).floatValue())).collect(Collectors.toList());
                columnPkg.addCandidates(Optional.of(candidates));
            }
        }
    }
}

