/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.classifier.smartsmodule;

import com.ibm.smarts.common.pipeline.DeltaAnalysisScope;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.internal.ontology.api.Ontology;
import com.ibm.smarts.model.value.IntegerValue;
import com.ibm.smarts.model.value.Value;
import com.ibm.smarts.ontology.classifier.smartsmodule.AbstractSmartsModuleClassificationStep;
import com.ibm.smarts.ontology.classifier.smartsmodule.SmartsModuleClassificationPkg;
import com.ibm.smarts.ontology.reasoner.DataHintReasoner;
import com.ibm.smarts.ontology.util.KnowledgeDiscoveryHelper;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.Statistic;
import com.ibm.smarts.schema.StatisticType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class CandidateFiltering
extends AbstractSmartsModuleClassificationStep {
    private List<Ontology<OWLOntology>> mOntologies = null;
    private static final float SIGNIFICANT_DATA_VALUE_REL_THRESHOLD = 0.9f;
    private static final float CONFLICTING_LEX_CANDIDATE_PENALTY = 0.5f;
    private static final float LOW_CONFIDENCE_THRESHOLD = 0.2f;

    CandidateFiltering(List<Ontology<OWLOntology>> ontologies, RequestContext requestContext) {
        super(requestContext);
        this.mOntologies = ontologies;
    }

    @Override
    public void execute(SmartsModuleClassificationPkg smPkg) {
        smPkg.setModified(smPkg.getDatasetClassificationPkgs().stream().map(this::classify).reduce(Boolean::logicalOr).orElse(false));
        this.clearMDC();
    }

    private boolean classify(SmartsModuleClassificationPkg.DatasetClassificationPkg dsPkg) {
        this.mdcDSInfo(dsPkg);
        boolean bModified = false;
        List<SmartsModuleClassificationPkg.ColumnClassificationPkg> inScopeColPkgs = dsPkg.getInScopeColumnClassificationPkgs();
        if (inScopeColPkgs.isEmpty()) {
            return bModified;
        }
        for (int i = 0; i < inScopeColPkgs.size(); ++i) {
            if (!this.shouldExecute(inScopeColPkgs.get(i), dsPkg.getDelatAnalysisScope(), DeltaAnalysisScope.ModifiableProperty.ALL, DeltaAnalysisScope.ModifiableProperty.NAME, DeltaAnalysisScope.ModifiableProperty.CONCEPTS, DeltaAnalysisScope.ModifiableProperty.USAGE) || this.shouldSkip(inScopeColPkgs.get(i), dsPkg.getDelatAnalysisScope(), DeltaAnalysisScope.ModifiableProperty.CONCEPTS, DeltaAnalysisScope.ModifiableProperty.USAGE)) continue;
            bModified = this.classify(i, inScopeColPkgs.get(i));
        }
        return bModified;
    }

    private boolean classify(int index, SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg) {
        this.mdcColInfo(index, columnPkg);
        try {
            return this.mOntologies.stream().map(o -> this.filterCandidates(columnPkg, (Ontology<OWLOntology>)o)).reduce(Boolean::logicalOr).orElse(false);
        }
        catch (Exception ex) {
            LOGGER.error("Caught exception while processing [{}]", (Object)columnPkg, (Object)ex);
            return true;
        }
    }

    private boolean filterCandidates(SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, Ontology<OWLOntology> ontology) {
        boolean changed;
        LOGGER.info("Filtering {}", (Object)columnPkg.getColumnInfo().getId());
        LOGGER.info("Starting Candidates: {}", columnPkg.getCandidates());
        int distinctCount = columnPkg.getColumnInfo().getStatistics().stream().filter(s -> s.getType().equals((Object)StatisticType.DISTINCT_COUNT)).map(Statistic::getValue).findFirst().orElse((Value)new IntegerValue(0)).intValue();
        int count = columnPkg.getColumnInfo().getStatistics().stream().filter(s -> s.getType().equals((Object)StatisticType.COUNT)).map(Statistic::getValue).findFirst().orElse((Value)new IntegerValue(0)).intValue();
        if (count == 0 && distinctCount == count || columnPkg.getColumnInfo().getSamples().isEmpty()) {
            LOGGER.info("Column {} has no sample data. Value based validation will be skipped.", (Object)columnPkg.getColumnInfo().getId());
        }
        OWLDataFactory factory = ((OWLOntology)ontology.getValue()).getOWLOntologyManager().getOWLDataFactory();
        Map<IRI, List<OWLLiteral>> dataPropertyValues = columnPkg.getDataPropertyValues();
        HashMap<IRI, List<ConceptInfo>> propertyValues = new HashMap<IRI, List<ConceptInfo>>();
        List<ConceptInfo> patternsOfColumn = columnPkg.getConcepts();
        OWLReasoner reasoner = KnowledgeDiscoveryHelper.getOntologyResourceManager(this.currentReqCtx).getDomainOntologyManager().getReasoner(ontology);
        ArrayList<SmartsModuleClassificationPkg.Candidate> rejectedCandidate = new ArrayList<SmartsModuleClassificationPkg.Candidate>();
        ArrayList<SmartsModuleClassificationPkg.Candidate> acceptedCandidate = new ArrayList<SmartsModuleClassificationPkg.Candidate>();
        List validCandidate = columnPkg.getCandidates().stream().filter(c -> c.getRelevance() > 0.0f).collect(Collectors.toList());
        validCandidate.sort(Comparator.comparing(SmartsModuleClassificationPkg.Candidate::getRelevance).reversed());
        for (SmartsModuleClassificationPkg.Candidate c2 : validCandidate) {
            if ((float)Float.compare(c2.getRelevance(), 0.0f) < 0.0f) continue;
            ArrayList<ConceptInfo> patterns = new ArrayList<ConceptInfo>(patternsOfColumn);
            patterns.addAll(acceptedCandidate.stream().map(c1 -> {
                ConceptInfo cncpt = new ConceptInfo();
                cncpt.setConceptID(c1.getConceptID().toString());
                cncpt.setConfidence(c1.getRelevance());
                return cncpt;
            }).collect(Collectors.toSet()));
            propertyValues.put(HAS_PATTERN_PROPERTY_IRI, patterns);
            float dataHintRelevance = DataHintReasoner.evaluateDataHintRestriction(factory.getOWLClass(c2.getConceptID()), propertyValues, dataPropertyValues, this.getCleanedSampleData(columnPkg.getColumnInfo()), (OWLOntology)ontology.getValue(), reasoner, this.currentReqCtx);
            if (dataHintRelevance <= 0.0f || Float.compare(c2.getRelevance(), 0.001f) < 0) {
                c2.setRelevance(-1.0f);
                rejectedCandidate.add(c2);
                if (!this.isIdentifier(c2, reasoner, factory)) continue;
                this.rejectEntity(acceptedCandidate, rejectedCandidate, factory, reasoner);
                continue;
            }
            c2.setDataHintRelevance(dataHintRelevance);
            acceptedCandidate.add(c2);
        }
        this.detectConflictingCandidates(columnPkg, factory, reasoner);
        boolean bl = changed = !rejectedCandidate.isEmpty();
        if (changed) {
            columnPkg.getCandidates().clear();
            columnPkg.getCandidates().addAll(acceptedCandidate);
            columnPkg.getCandidates().addAll(rejectedCandidate);
        }
        LOGGER.info("Rejected Candidates: {}", rejectedCandidate);
        LOGGER.info("Validate Candidates: {}", columnPkg.getCandidates());
        return changed;
    }

    private void acceptEntity(List<SmartsModuleClassificationPkg.Candidate> validCandidate, List<SmartsModuleClassificationPkg.Candidate> acceptedCandidate, OWLDataFactory factory, OWLReasoner reasoner) {
        validCandidate.stream().filter(c -> Float.compare(c.getRelevance(), 0.0f) > 0).filter(c -> this.isEntity((SmartsModuleClassificationPkg.Candidate)c, reasoner, factory)).forEach(c -> acceptedCandidate.add((SmartsModuleClassificationPkg.Candidate)c));
    }

    private void rejectEntity(List<SmartsModuleClassificationPkg.Candidate> acceptedCandidate, List<SmartsModuleClassificationPkg.Candidate> rejectedCandidates, OWLDataFactory factory, OWLReasoner reasoner) {
        Iterator<SmartsModuleClassificationPkg.Candidate> iter = acceptedCandidate.iterator();
        while (iter.hasNext()) {
            SmartsModuleClassificationPkg.Candidate c = iter.next();
            if (!this.isEntity(c, reasoner, factory)) continue;
            c.setRelevance(-1.0f);
            rejectedCandidates.add(c);
            iter.remove();
        }
    }

    private void detectConflictingCandidates(SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, OWLDataFactory factory, OWLReasoner reasoner) {
        List lexBasedCandidates = columnPkg.getCandidates().stream().filter(c -> c.getRelevance() > 0.0f).filter(c -> c.getLexicalRelevance() > 0.0f).collect(Collectors.toList());
        lexBasedCandidates.stream().forEach(lexBasedCandidate -> {
            List nonGenericDataBasedCandidates = columnPkg.getCandidates().stream().filter(c -> c.getLexicalRelevance() == 0.0f && c.getDataValueRelevance() > 0.9f).filter(c -> !CandidateFiltering.getCommonConceptIDs().contains(c.getConceptID().toString())).collect(Collectors.toList());
            if (!nonGenericDataBasedCandidates.isEmpty()) {
                boolean lexCandidateIsChild;
                OWLClass lexBasedCandidateClass = factory.getOWLClass(lexBasedCandidate.getConceptID());
                boolean lexCandidateIsParent = nonGenericDataBasedCandidates.stream().map(c -> factory.getOWLClass(c.getConceptID())).anyMatch(dbC -> reasoner.getSuperClasses((OWLClassExpression)dbC, false).getFlattened().contains(lexBasedCandidateClass));
                if (!lexCandidateIsParent && !(lexCandidateIsChild = nonGenericDataBasedCandidates.stream().map(c -> factory.getOWLClass(c.getConceptID())).anyMatch(dbC -> reasoner.getSubClasses((OWLClassExpression)dbC, false).getFlattened().contains(lexBasedCandidateClass)))) {
                    lexBasedCandidate.setLexicalRelevance(0.5f * lexBasedCandidate.getLexicalRelevance()).setDataHintRelevance(0.5f * Math.min(lexBasedCandidate.getDataHintRelevance(), 1.0f)).setRelevance(0.5f * lexBasedCandidate.getRelevance());
                    LOGGER.info("Reduced the relevance of [Candidate:{}] due to conflict with data-based candidates", lexBasedCandidate);
                }
            }
        });
    }
}

