/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.classifier.smartsmodule;

import com.ibm.smarts.common.pipeline.DeltaAnalysisScope;
import com.ibm.smarts.ontology.util.Pair;
import com.ibm.smarts.ontology.util.TNode;
import com.ibm.smarts.schema.AggregationType;
import com.ibm.smarts.schema.AnalysisModeType;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.Relation;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.TextInfo;
import com.ibm.smarts.schema.UsageType;
import com.ibm.smarts.schema.util.SmartsModuleFactory;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;

class SmartsModuleClassificationPkg {
    private final Optional<SmartsModule> smartsModule;
    private final List<DatasetClassificationPkg> datasetPkg;
    private boolean hasModified;
    private boolean hasExecuted;

    SmartsModuleClassificationPkg(@Nonnull SmartsModule sModule) {
        this.smartsModule = Optional.of(sModule);
        this.datasetPkg = sModule.getDatasets().stream().map(ds -> new DatasetClassificationPkg((DatasetInfo)ds, sModule.getAnalysisMode())).collect(Collectors.toList());
        this.setModified(false);
        this.setExecuted(false);
    }

    Optional<DatasetClassificationPkg> getDatasetClassificationPkg(int index) {
        if (index >= 0 && index < this.datasetPkg.size()) {
            return Optional.of(this.datasetPkg.get(index));
        }
        return Optional.empty();
    }

    @Nonnull
    List<DatasetClassificationPkg> getDatasetClassificationPkgs() {
        return this.datasetPkg;
    }

    @Nonnull
    SmartsModule getSmartsModule() {
        return this.smartsModule.orElse(SmartsModuleFactory.createSmartsModule());
    }

    boolean hasModified() {
        return this.hasModified;
    }

    void setModified(boolean modified) {
        this.hasModified = modified;
    }

    boolean hasExecuted() {
        return this.hasExecuted;
    }

    void setExecuted(boolean hasExecuted) {
        this.hasExecuted = hasExecuted;
    }

    void setClassifyScope(DeltaAnalysisScope classifyAnalysisScope) {
        this.datasetPkg.stream().filter(dp -> dp.getDataset().getId().equals(classifyAnalysisScope.getDatasetId())).forEach(dp -> ((DatasetClassificationPkg)dp).deltaClassifyScope = classifyAnalysisScope);
    }

    static class ColumnClassificationPkg {
        private Optional<DatasetInfo> dataset;
        private Optional<ColumnInfo> column;
        private List<Candidate> candidates;
        private Map<Candidate, Set<Candidate>> entityCandidates;
        private List<ConceptInfo> concepts;
        private List<Relation> relations;
        private AggregationType defaultAggregation;
        private AnalysisModeType analysisMode = AnalysisModeType.DEEP;
        private UsageType usage;
        private Map<IRI, List<OWLLiteral>> dataPropertyValues = Collections.emptyMap();

        ColumnClassificationPkg(@Nonnull DatasetInfo datasetInfo, @Nonnull ColumnInfo col, AnalysisModeType mode) {
            this.dataset = Optional.of(datasetInfo);
            this.column = Optional.of(col);
            this.concepts = new ArrayList<ConceptInfo>();
            this.candidates = new ArrayList<Candidate>();
            this.relations = new ArrayList<Relation>();
            this.entityCandidates = new HashMap<Candidate, Set<Candidate>>();
            this.defaultAggregation = AggregationType.NONE;
            this.usage = UsageType.AUTOMATIC;
            if (mode != null) {
                this.analysisMode = mode;
            }
        }

        public AnalysisModeType getAnalysisMode() {
            return this.analysisMode;
        }

        @Nonnull
        DatasetInfo getDatasetInfo() {
            return this.dataset.orElse(new DatasetInfo());
        }

        @Nonnull
        ColumnInfo getColumnInfo() {
            return this.column.orElse(new ColumnInfo());
        }

        @Nonnull
        TextInfo getColumnLabel() {
            return this.column.orElseGet(() -> {
                ColumnInfo c = new ColumnInfo();
                c.setLabel(new TextInfo());
                return c;
            }).getLabel();
        }

        @Nonnull
        ColumnClassificationPkg addConcept(ConceptInfo c) {
            this.concepts.add(c);
            return this;
        }

        @Nonnull
        List<ConceptInfo> getConcepts() {
            return this.concepts;
        }

        @Nonnull
        ColumnClassificationPkg addCandidate(Optional<Candidate> candidate) {
            candidate.ifPresent(c -> this.candidates.add((Candidate)c));
            return this;
        }

        @Nonnull
        List<Candidate> getCandidates() {
            return this.candidates;
        }

        Optional<Candidate> getCandidate(IRI id) {
            return this.candidates.stream().filter(c -> c.getConceptID().equals((Object)id)).findFirst();
        }

        boolean removeCandidate(IRI id) {
            return this.candidates.removeIf(c -> c.getConceptID().equals((Object)id));
        }

        @Nonnull
        ColumnClassificationPkg addCandidates(@Nonnull Optional<List<Candidate>> candidateLists) {
            candidateLists.ifPresent(cans -> cans.stream().forEach(can -> {
                Optional<Candidate> existingCandidate = this.candidates.stream().filter(existingCan -> existingCan.equals(can)).findFirst();
                if (existingCandidate.isPresent()) {
                    existingCandidate.map(ecan -> {
                        ecan.setLexicalRelevance(Math.max(((Candidate)ecan).lexicalRelevance, ((Candidate)can).lexicalRelevance)).setDataHintRelevance(Math.max(((Candidate)ecan).dataHintRelevance, ((Candidate)can).dataHintRelevance)).setDataValueRelevance(Math.max(((Candidate)ecan).dataValueRelevance, ((Candidate)can).dataValueRelevance));
                        return ecan;
                    });
                } else {
                    this.candidates.add((Candidate)can);
                }
            }));
            return this;
        }

        @Nonnull
        Set<Candidate> getEntityCandidates(@Nonnull Candidate candidate) {
            Set<Candidate> entities = this.entityCandidates.get(candidate);
            if (entities == null) {
                entities = new HashSet<Candidate>();
                this.addEntityCandidates(candidate, entities);
            }
            return entities;
        }

        @Nonnull
        Map<Candidate, Set<Candidate>> getAllEntityCandidates() {
            return this.entityCandidates;
        }

        void addEntityCandidates(@Nonnull Candidate candiate, @Nonnull Set<Candidate> entityCandidates) {
            this.entityCandidates.put(candiate, entityCandidates);
        }

        @Nonnull
        Set<Candidate> removeEntityCandidates(@Nonnull Candidate candidate) {
            return this.entityCandidates.remove(candidate);
        }

        @Nonnull
        AggregationType getDefaultAggregation() {
            return this.defaultAggregation;
        }

        void setDefaultAggregation(AggregationType defaultAggregation) {
            this.defaultAggregation = defaultAggregation;
        }

        @Nonnull
        public UsageType getUsage() {
            return this.usage;
        }

        public void setUsage(UsageType usage) {
            this.usage = usage;
        }

        @Nonnull
        public Map<IRI, List<OWLLiteral>> getDataPropertyValues() {
            return this.dataPropertyValues;
        }

        public void setDataPropertyValues(@Nonnull Map<IRI, List<OWLLiteral>> dataPropertyValues) {
            this.dataPropertyValues = dataPropertyValues;
        }

        @Nonnull
        List<Relation> getRelations() {
            return this.relations;
        }

        @Nonnull
        ColumnClassificationPkg addRelations(@Nonnull Optional<List<Relation>> relations) {
            relations.ifPresent(r -> this.relations.addAll((Collection<Relation>)r));
            return this;
        }

        @Nonnull
        ColumnClassificationPkg addRelation(@Nonnull Optional<Relation> relation) {
            relation.ifPresent(r -> this.relations.add((Relation)r));
            return this;
        }
    }

    static class LogicalGroup {
        private Optional<Candidate> groupKey;
        private List<Pair<Optional<Candidate>, ColumnClassificationPkg>> groupMembers = new ArrayList<Pair<Optional<Candidate>, ColumnClassificationPkg>>();
        private int groupId;

        LogicalGroup(Optional<Candidate> key, int id) {
            this.groupKey = key;
            this.groupId = id;
        }

        public Optional<Candidate> getGroupKey() {
            return this.groupKey;
        }

        public List<Pair<Optional<Candidate>, ColumnClassificationPkg>> getGroupMembers() {
            return this.groupMembers;
        }

        public int getGroupId() {
            return this.groupId;
        }
    }

    static class DatasetClassificationPkg {
        private final List<ColumnClassificationPkg> columnPkg;
        private final Optional<DatasetInfo> dataset;
        private List<LogicalGroup> groups = new ArrayList<LogicalGroup>();
        private List<TNode<LogicalGroup>> hierarchies = Collections.emptyList();
        private AnalysisModeType analysisMode = AnalysisModeType.DEEP;
        private DeltaAnalysisScope deltaClassifyScope = null;

        DatasetClassificationPkg(@Nonnull DatasetInfo sDataset, AnalysisModeType mode) {
            this.dataset = Optional.of(sDataset);
            if (mode != null) {
                this.analysisMode = mode;
            }
            this.columnPkg = SmartsModuleUtil.getFlattenedColumns((BaseItemObject)sDataset).stream().map(c -> new ColumnClassificationPkg(sDataset, (ColumnInfo)c, this.analysisMode)).collect(Collectors.toList());
        }

        public AnalysisModeType getAnalysisMode() {
            return this.analysisMode;
        }

        public Map<String, Set<DeltaAnalysisScope.ModifiableProperty>> getColumnPropertiesDelta() {
            if (this.isSomeColumns()) {
                return this.deltaClassifyScope.getColumnPropertiesDelta();
            }
            return new HashMap<String, Set<DeltaAnalysisScope.ModifiableProperty>>(0);
        }

        public boolean isAllColumns() {
            return this.deltaClassifyScope == null || this.deltaClassifyScope.getScopedColumns() == DeltaAnalysisScope.ScopedColumns.ALL;
        }

        public boolean isNoneColumn() {
            return this.deltaClassifyScope != null && this.deltaClassifyScope.getScopedColumns() == DeltaAnalysisScope.ScopedColumns.NONE;
        }

        public boolean isSomeColumns() {
            return this.deltaClassifyScope != null && this.deltaClassifyScope.getScopedColumns() == DeltaAnalysisScope.ScopedColumns.SOME;
        }

        public DeltaAnalysisScope getDelatAnalysisScope() {
            return this.deltaClassifyScope;
        }

        Optional<ColumnClassificationPkg> getColumnClassificationPkg(int index) {
            if (index >= 0 && index < this.columnPkg.size()) {
                return Optional.of(this.columnPkg.get(index));
            }
            return Optional.empty();
        }

        @Nonnull
        List<ColumnClassificationPkg> getColumnClassificationPkgs() {
            return this.columnPkg;
        }

        @Nonnull
        List<ColumnClassificationPkg> getInScopeColumnClassificationPkgs() {
            if (this.isAllColumns()) {
                return this.columnPkg;
            }
            if (this.isNoneColumn()) {
                return Collections.emptyList();
            }
            if (this.isSomeColumns()) {
                return this.columnPkg.stream().filter(cp -> this.deltaClassifyScope.getColumnPropertiesDelta().keySet().contains(cp.getColumnInfo().getIdForExpression())).collect(Collectors.toList());
            }
            return this.columnPkg;
        }

        @Nonnull
        DatasetInfo getDataset() {
            return this.dataset.orElse(new DatasetInfo());
        }

        @Nonnull
        public List<LogicalGroup> getGroups() {
            return this.groups;
        }

        @Nonnull
        public List<TNode<LogicalGroup>> getHierarchies() {
            return this.hierarchies;
        }

        public void setHierarchies(List<TNode<LogicalGroup>> hierarchies) {
            this.hierarchies = hierarchies;
        }
    }

    static class Candidate
    implements Comparable<Candidate> {
        private IRI conceptID;
        private float lexicalRelevance;
        private float dataHintRelevance;
        private float dataValueRelevance;
        private float relevance;
        private float confidence;
        static float LEXICAL_FACTOR = 0.4f;
        static float DATAHINT_FACTOR = 0.4f;
        static float DATAVALUE_FACTOR = 0.2f;

        Candidate(@Nonnull IRI conceptID) {
            this.conceptID = conceptID;
        }

        IRI getConceptID() {
            return this.conceptID;
        }

        float getLexicalRelevance() {
            return this.lexicalRelevance;
        }

        Candidate setLexicalRelevance(float score) {
            this.lexicalRelevance = score;
            return this;
        }

        float getRelevance() {
            return this.relevance;
        }

        Candidate setRelevance(float score) {
            this.relevance = score;
            return this;
        }

        float getDataHintRelevance() {
            return this.dataHintRelevance;
        }

        Candidate setDataHintRelevance(float dataHintRelevance) {
            this.dataHintRelevance = dataHintRelevance;
            return this;
        }

        float getDataValueRelevance() {
            return this.dataValueRelevance;
        }

        Candidate setDataValueRelevance(float dataValueRelevance) {
            this.dataValueRelevance = dataValueRelevance;
            return this;
        }

        Candidate setConfidence(float confidence) {
            this.confidence = confidence;
            return this;
        }

        float getConfidence() {
            return this.confidence;
        }

        @Override
        public int compareTo(Candidate other) {
            return this.conceptID.compareTo((OWLObject)other.getConceptID());
        }

        public boolean equals(Object obj) {
            if (obj instanceof Candidate) {
                return this.compareTo((Candidate)obj) == 0;
            }
            return false;
        }

        public int hashCode() {
            return this.conceptID.hashCode();
        }

        public String toString() {
            return "Candidate [conceptID=" + this.conceptID + ", lexicalRelevance=" + this.lexicalRelevance + ", dataHintRelevance=" + this.dataHintRelevance + ", dataValueRelevance=" + this.dataValueRelevance + ", relevance=" + this.relevance + ", confidence=" + this.confidence + "]";
        }
    }
}

