/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.classifier.smartsmodule;

import com.ibm.smarts.common.pipeline.DeltaAnalysisScope;
import com.ibm.smarts.common.util.CommonJAXBHelper;
import com.ibm.smarts.core.util.OperationMetrics;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.core.util.Timer;
import com.ibm.smarts.internal.ontology.api.ClueManager;
import com.ibm.smarts.internal.ontology.api.Ontology;
import com.ibm.smarts.ontology.classifier.BaseConceptClassifier;
import com.ibm.smarts.ontology.classifier.smartsmodule.AggregationResolution;
import com.ibm.smarts.ontology.classifier.smartsmodule.ApplicationConceptClassification;
import com.ibm.smarts.ontology.classifier.smartsmodule.CandidateConsolidation;
import com.ibm.smarts.ontology.classifier.smartsmodule.CandidateElection;
import com.ibm.smarts.ontology.classifier.smartsmodule.CandidateElectionViaData;
import com.ibm.smarts.ontology.classifier.smartsmodule.CandidateFiltering;
import com.ibm.smarts.ontology.classifier.smartsmodule.ConceptAssertion;
import com.ibm.smarts.ontology.classifier.smartsmodule.DomainConceptClassification;
import com.ibm.smarts.ontology.classifier.smartsmodule.Ensemble;
import com.ibm.smarts.ontology.classifier.smartsmodule.EntityCandidateElection;
import com.ibm.smarts.ontology.classifier.smartsmodule.EntityResolution;
import com.ibm.smarts.ontology.classifier.smartsmodule.EquivalentConceptClassification;
import com.ibm.smarts.ontology.classifier.smartsmodule.HierarchyDetection;
import com.ibm.smarts.ontology.classifier.smartsmodule.LogicalGrouping;
import com.ibm.smarts.ontology.classifier.smartsmodule.PreEnsemble;
import com.ibm.smarts.ontology.classifier.smartsmodule.RelevanceScoreAdjustment;
import com.ibm.smarts.ontology.classifier.smartsmodule.ScenarioGroupDetection;
import com.ibm.smarts.ontology.classifier.smartsmodule.SmartsModuleClassificationPipeline;
import com.ibm.smarts.ontology.classifier.smartsmodule.SmartsModuleClassificationPkg;
import com.ibm.smarts.ontology.classifier.smartsmodule.UsageResolution;
import com.ibm.smarts.ontology.ontologymanager.OntologyResourceManager;
import com.ibm.smarts.ontology.registry.util.ConceptsUtil;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.BaseObject;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.semanticweb.owlapi.model.OWLOntology;

public class SmartsModuleConceptClassifier
extends BaseConceptClassifier<SmartsModule, SmartsModule> {
    private static final float MATCH_RATIO = 0.7f;

    public SmartsModuleConceptClassifier() {
    }

    protected SmartsModuleConceptClassifier(OntologyResourceManager resourceMgr, ClueManager<?> clueMgr) {
        super(resourceMgr, clueMgr);
    }

    public SmartsModule classify(RequestContext requestContext, SmartsModule sModule) {
        return (SmartsModule)this.handle(requestContext, ctx -> this.classifySmartsModule((RequestContext)ctx, sModule));
    }

    String detectDomains(RequestContext requestContext, SmartsModule sModule) {
        Object id = requestContext.getAttribute("smarts.ontology.selected");
        if (null == id && "http://www.ibm.com/ontologies/waca/domain/common".equals(id = this.getResourceManager().getKnowledgeDiscoveryConfig().getProperty("smarts.ontology.selected"))) {
            id = this.autoDetectDomain(sModule);
        }
        String idStr = (String)id;
        LOGGER.warn("Selected ontology id: " + idStr);
        return idStr;
    }

    String autoDetectDomain(SmartsModule sModule) {
        String bestOntoID = null;
        if (sModule != null && !sModule.getDatasets().isEmpty()) {
            Map mappings = this.getResourceManager().getDomainOntologyManager().getDomainDefaultConceptMappings();
            List columnNames = SmartsModuleUtil.getFlattenedColumns((BaseItemObject)((BaseItemObject)sModule.getDatasets().get(0))).stream().map(BaseObject::getName).map(String::toLowerCase).collect(Collectors.toList());
            if (!columnNames.isEmpty()) {
                float max = 0.0f;
                Set ontoIDs = mappings.keySet();
                for (String ontoID : ontoIDs) {
                    Map mapping = (Map)mappings.get(ontoID);
                    List mappedColumnsByThisOnto = mapping.entrySet().stream().filter(entry -> ConceptsUtil.getOntologyId((ConceptInfo)((ConceptInfo)entry.getValue())).equals(ontoID)).map(Map.Entry::getKey).map(String::toLowerCase).collect(Collectors.toList());
                    List mappedColumnsByParentOnto = mapping.entrySet().stream().filter(entry -> !ConceptsUtil.getOntologyId((ConceptInfo)((ConceptInfo)entry.getValue())).equals(ontoID)).map(Map.Entry::getKey).map(String::toLowerCase).collect(Collectors.toList());
                    long effectiveTotal = (long)columnNames.size() - columnNames.stream().filter(col -> mappedColumnsByParentOnto.contains(col)).count();
                    float matched = effectiveTotal != 0L ? (float)columnNames.stream().filter(col -> mappedColumnsByThisOnto.contains(col)).count() / (float)effectiveTotal : 0.0f;
                    if (Float.compare(matched, 0.7f) <= 0 || Float.compare(matched, max) <= 0) continue;
                    LOGGER.info("domain matched: [{}] with score [{}]", (Object)ontoID, (Object)Float.valueOf(matched));
                    max = matched;
                    bestOntoID = ontoID;
                }
            }
        }
        if (bestOntoID == null) {
            bestOntoID = "http://www.ibm.com/ontologies/waca/domain/common";
        }
        return bestOntoID;
    }

    private SmartsModule classifySmartsModule(RequestContext requestContext, SmartsModule sModule) {
        Instant before = Instant.now();
        requestContext.setAttribute("clueManager", (Object)this.clueManager);
        requestContext.setAttribute("resourceManager", (Object)this.resourceManager);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(CommonJAXBHelper.marshalToJSON((Object)sModule, (boolean)true));
        }
        SmartsModuleClassificationPkg pkg = this.buildClassificationPackage(requestContext, sModule);
        SmartsModuleClassificationPipeline pipeline = this.buildPipeline(true, requestContext, this.resolveDomains(this.detectDomains(requestContext, sModule)));
        OperationMetrics.OpGroupMetrics ogm = requestContext.requestMetrics.opMetrics.group("onto");
        pipeline.getIterator().forEachRemaining(s -> {
            OperationMetrics.OpMetrics om = ogm.metrics(s.getClass().getSimpleName());
            try (Timer.Stopwatch timer = om.working();){
                Instant b = Instant.now();
                s.execute(pkg);
                LOGGER.info(String.format("%s step took [%s]ms", s.getName(), Duration.between(b, Instant.now()).toMillis()));
            }
        });
        this.checkCondition(pkg);
        LOGGER.info(String.format("** Total classification took [%s]ms", Duration.between(before, Instant.now()).toMillis()));
        return sModule;
    }

    SmartsModuleClassificationPkg buildClassificationPackage(RequestContext requestContext, SmartsModule sModule) {
        SmartsModuleClassificationPkg pkg = new SmartsModuleClassificationPkg(sModule);
        DeltaAnalysisScope classifyScope = null;
        Object scope = requestContext.getAttribute("classifyScope");
        if (scope != null) {
            classifyScope = (DeltaAnalysisScope)scope;
            pkg.setClassifyScope(classifyScope);
        }
        return pkg;
    }

    private boolean checkCondition(SmartsModuleClassificationPkg pkg) {
        return !pkg.hasModified();
    }

    private SmartsModuleClassificationPipeline buildPipeline(boolean initial, RequestContext requestContext, List<Ontology<OWLOntology>> detectedDomains) {
        SmartsModuleClassificationPipeline pl = new SmartsModuleClassificationPipeline();
        if (initial) {
            pl.register(new CandidateElection(detectedDomains, requestContext));
            pl.register(new CandidateElectionViaData(detectedDomains, requestContext));
        }
        pl.register(new ConceptAssertion(detectedDomains, requestContext));
        pl.register(new ApplicationConceptClassification(this.getResourceManager().getApplicationOntologyManager().getOntologies(), requestContext));
        pl.register(new EquivalentConceptClassification(detectedDomains, requestContext));
        pl.register(new RelevanceScoreAdjustment(detectedDomains, requestContext));
        pl.register(new CandidateFiltering(detectedDomains, requestContext));
        pl.register(new CandidateConsolidation(detectedDomains, requestContext));
        pl.register(new EntityCandidateElection(detectedDomains, requestContext));
        pl.register(new EntityResolution(detectedDomains, requestContext));
        pl.register(new LogicalGrouping(detectedDomains, requestContext));
        pl.register(new HierarchyDetection(detectedDomains, requestContext));
        pl.register(new DomainConceptClassification(requestContext));
        pl.register(new PreEnsemble(requestContext));
        pl.register(new UsageResolution(detectedDomains, requestContext));
        pl.register(new AggregationResolution(detectedDomains, requestContext));
        pl.register(new Ensemble(requestContext));
        pl.register(new ScenarioGroupDetection(detectedDomains, requestContext));
        return pl;
    }
}

