/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.pipeline.apis;

import com.ibm.smarts.pipeline.apis.IContext;
import com.ibm.smarts.pipeline.apis.IProgressUpdater;
import com.ibm.smarts.pipeline.apis.ITask;
import com.ibm.smarts.pipeline.constants.ExecutionStatus;
import com.ibm.smarts.pipeline.dag.TaskDependencyGraphBuilder;
import com.ibm.smarts.pipeline.internal.ExecutionPlan;
import com.ibm.smarts.pipeline.internal.FlowData;
import com.ibm.smarts.pipeline.internal.TaskExecutionPlanner;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class FlowExecutor<T extends IContext> {
    private String id;
    private ExecutorService executorService;
    private TaskExecutionPlanner planner;
    Map<ExecutionPlan, ExecutionStatus> statusMap;
    private List<CompletableFuture> planExecutions = new ArrayList<CompletableFuture>();
    private static final byte ERROR_MASK = 1;
    private static final byte COMPLETE_MASK = 2;
    private static final byte CANCELLED_MASK = 4;
    private static final byte IN_PROGRESS_MASK = 8;
    private static final byte NOT_STARTED_MASK = 16;
    private static final byte COMPLETE_PENDING_MASK = 32;
    private IProgressUpdater progressUpdater;

    public FlowExecutor(ExecutorService executorService, IProgressUpdater progressUpdater) {
        this.executorService = executorService;
        this.planner = new TaskExecutionPlanner();
        this.statusMap = new ConcurrentHashMap<ExecutionPlan, ExecutionStatus>();
        this.progressUpdater = progressUpdater;
    }

    public FlowExecutor(ExecutorService executorService, List<ITask> tasks, IProgressUpdater progressUpdater) {
        this(executorService, progressUpdater);
        TaskDependencyGraphBuilder.build(tasks);
    }

    public CompletableFuture<Void> execute(List<FlowData<T>> flowDatas) {
        if (!flowDatas.isEmpty()) {
            this.id = flowDatas.get(0).getContext().getBatchId();
        }
        this.planExecutions.clear();
        for (FlowData<T> flowData : flowDatas) {
            String atomId = flowData.getContext().getAtomId();
            ExecutionPlan plan = this.planner.plan(atomId, this, flowData.getTasks(), flowData.getInitialTask(), flowData.getFinalTask());
            this.statusMap.put(plan, ExecutionStatus.NOT_STARTED);
            Runnable runnable = () -> plan.execute(this.executorService, flowData.getContext());
            CompletableFuture.runAsync(runnable, this.executorService);
            this.planExecutions.add(plan.getPlanComplete());
        }
        CompletableFuture[] planExecutionsArray = this.planExecutions.toArray(new CompletableFuture[0]);
        return CompletableFuture.allOf(planExecutionsArray);
    }

    public void cancel() {
        for (Map.Entry<ExecutionPlan, ExecutionStatus> entry : this.statusMap.entrySet()) {
            entry.getKey().cancel();
            if (entry.getValue() != ExecutionStatus.NOT_STARTED && entry.getValue() != ExecutionStatus.IN_PROGRESS) continue;
            entry.setValue(ExecutionStatus.CANCELLED);
        }
        for (Future future : this.planExecutions) {
            future.cancel(true);
        }
    }

    public void onUpdate(ExecutionPlan plan, ExecutionStatus planStatus) {
        if (planStatus == ExecutionStatus.ERROR) {
            plan.handleError();
        }
        this.statusMap.put(plan, planStatus);
        ExecutionStatus currentStatus = this.calculateStatus();
        if (currentStatus == ExecutionStatus.COMPLETE || currentStatus == ExecutionStatus.CANCELLED || currentStatus == ExecutionStatus.ERROR) {
            this.onFinish(currentStatus);
        }
    }

    private void onFinish(ExecutionStatus status) {
        this.progressUpdater.setBatchProgress(this.id, status);
    }

    ExecutionStatus calculateStatus() {
        byte interimResult = 0;
        for (ExecutionStatus currentStatus : this.statusMap.values()) {
            interimResult = FlowExecutor.addStatusToResult(currentStatus, interimResult);
        }
        if (FlowExecutor.haveOne((byte)8, interimResult)) {
            return ExecutionStatus.IN_PROGRESS;
        }
        if (FlowExecutor.onlyHave((byte)2, interimResult)) {
            return ExecutionStatus.COMPLETE;
        }
        if (FlowExecutor.onlyHave((byte)16, interimResult)) {
            return ExecutionStatus.NOT_STARTED;
        }
        if (FlowExecutor.haveOne((byte)16, interimResult)) {
            return ExecutionStatus.IN_PROGRESS;
        }
        if (FlowExecutor.haveOne((byte)4, interimResult)) {
            return ExecutionStatus.CANCELLED;
        }
        if (FlowExecutor.haveOne((byte)32, interimResult)) {
            return ExecutionStatus.IN_PROGRESS;
        }
        return ExecutionStatus.ERROR;
    }

    private static byte addStatusToResult(ExecutionStatus currentStatus, byte interimResult) {
        if (currentStatus.equals((Object)ExecutionStatus.COMPLETE)) {
            interimResult = (byte)(interimResult | 2);
        } else if (currentStatus.equals((Object)ExecutionStatus.COMPLETE_PENDING)) {
            interimResult = (byte)(interimResult | 0x20);
        } else if (currentStatus.equals((Object)ExecutionStatus.ERROR)) {
            interimResult = (byte)(interimResult | 1);
        } else if (currentStatus.equals((Object)ExecutionStatus.CANCELLED)) {
            interimResult = (byte)(interimResult | 4);
        } else if (currentStatus.equals((Object)ExecutionStatus.IN_PROGRESS)) {
            interimResult = (byte)(interimResult | 8);
        } else if (currentStatus.equals((Object)ExecutionStatus.NOT_STARTED)) {
            interimResult = (byte)(interimResult | 0x10);
        }
        return interimResult;
    }

    private static boolean onlyHave(byte mask, byte result) {
        return result == mask;
    }

    private static boolean haveOne(byte mask, byte result) {
        return (result & mask) == mask;
    }

    public String getId() {
        return this.id;
    }

    public IProgressUpdater getProgressUpdater() {
        return this.progressUpdater;
    }
}

