/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.pipeline.dag;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class Node<T> {
    private T data;
    private AtomicInteger inDegree = new AtomicInteger(0);
    private List<Node<T>> successors;

    public Node() {
    }

    public Node(T data) {
        this.data = data;
        this.successors = new ArrayList<Node<T>>();
    }

    public Node(T data, Node ... successors) {
        this.data = data;
        this.successors = Arrays.asList(successors);
        this.updateSuccessorInDegrees();
    }

    private void updateSuccessorInDegrees() {
        for (Node<T> successor : this.successors) {
            successor.inDegree.incrementAndGet();
        }
    }

    public Node(T data, List<Node<T>> successors) {
        this.data = data;
        this.successors = successors;
        for (Node<T> successor : this.successors) {
            successor.inDegree.incrementAndGet();
        }
    }

    public Node<T> getSuccessor(T data) {
        for (Node<T> successor : this.successors) {
            if (!successor.getData().equals(data)) continue;
            return successor;
        }
        return null;
    }

    public T getData() {
        return this.data;
    }

    public List<Node<T>> getSuccessors() {
        return this.successors;
    }

    public AtomicInteger getInDegree() {
        return this.inDegree;
    }

    public boolean isDescendentOf(Node<T> node) {
        if (node == this) {
            return true;
        }
        for (Node<T> successor : node.successors) {
            if (!this.isDescendentOf(successor)) continue;
            return true;
        }
        return false;
    }

    public void reset() {
        this.inDegree.set(0);
    }

    public boolean add(Node<T> ... nodes) {
        boolean retVal = true;
        for (int i = 0; i < nodes.length && retVal; ++i) {
            nodes[i].inDegree.incrementAndGet();
            retVal = this.successors.add(nodes[i]);
        }
        return retVal;
    }

    public String toString() {
        if (this.data == null) {
            return "Virtual root 0";
        }
        return this.data.toString() + "(" + this.inDegree + ")";
    }
}

