/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.pipeline.dag;

import com.ibm.smarts.pipeline.apis.ITask;
import com.ibm.smarts.pipeline.dag.Flow;
import com.ibm.smarts.pipeline.dag.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TaskDependencyGraphBuilder {
    private static Flow<String> masterDag;
    private static Map<String, Node<String>> nodeMap;

    public static Flow<String> build(List<ITask> tasks) {
        nodeMap = new HashMap<String, Node<String>>(tasks.size());
        ArrayList<Node<ITask>> nodes = new ArrayList<Node<ITask>>(tasks.size());
        ArrayList lightNodes = new ArrayList(tasks.size());
        for (ITask task : tasks) {
            Node<ITask> currentNode = new Node<ITask>(task);
            Node<String> currentLightNode = new Node<String>(task.getID());
            nodeMap.put(task.getID(), currentLightNode);
            for (int i = 0; i < nodes.size(); ++i) {
                Node taskNode = (Node)nodes.get(i);
                Node lightTaskNode = (Node)lightNodes.get(i);
                if (task.isPredecessorOf((ITask)taskNode.getData())) {
                    currentNode.add(taskNode);
                    currentLightNode.add(lightTaskNode);
                    continue;
                }
                if (!task.isSuccessorOf((ITask)taskNode.getData())) continue;
                taskNode.add(currentNode);
                lightTaskNode.add(currentLightNode);
            }
            nodes.add(currentNode);
            lightNodes.add(currentLightNode);
        }
        masterDag = new Flow(true, lightNodes);
        return masterDag;
    }

    public static Node<String> findNodeById(List<Node<String>> nodes, String id) {
        for (Node<String> node : nodes) {
            if (!id.equals(node.getData())) continue;
            return node;
        }
        return null;
    }

    public static boolean isDescendent(String descendentId, String ancestorId) {
        Node<String> node = nodeMap.get(ancestorId);
        if (node.getData().equals(descendentId)) {
            return true;
        }
        for (Node<String> successor : node.getSuccessors()) {
            if (!TaskDependencyGraphBuilder.isDescendent(descendentId, successor.getData())) continue;
            return true;
        }
        return false;
    }

    public static Flow<String> getMasterDagCopy() {
        ArrayList<Node<String>> nodes = new ArrayList<Node<String>>();
        for (Node<String> node : masterDag.getNodes()) {
            Node<String> currentNode = new Node<String>(node.getData());
            currentNode.getInDegree().set(node.getInDegree().get());
            nodes.add(currentNode);
        }
        for (Node<String> node : masterDag.getNodes()) {
            Node<String> nodeCopy = TaskDependencyGraphBuilder.findNodeById(nodes, node.getData());
            for (Node<String> successor : node.getSuccessors()) {
                nodeCopy.getSuccessors().add(TaskDependencyGraphBuilder.findNodeById(nodes, successor.getData()));
            }
        }
        return new Flow<String>(nodes);
    }
}

