/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.SPSCipher;
import com.cognos.accman.jcam.crypto.SPSCipherAES;
import com.cognos.accman.jcam.crypto.SPSCipherAESjava;
import com.cognos.accman.jcam.crypto.SPSCipherDESwParity;
import com.cognos.accman.jcam.crypto.Token;
import com.cognos.accman.jcam.crypto.misc.CryptoWrapper;
import com.cognos.accman.jcam.crypto.misc.IJVMEnvironment;
import com.cognos.accman.jcam.crypto.misc.IPFTraceFunction;
import com.cognos.accman.res.MessageSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;

public class SystemProtectionSessionTokenV1
extends Token {
    private static final int VERSION_1 = 1;
    private static final byte[] PREAMBLE = new byte[]{0, 0, 0, 0, 0, 0, 0};
    private int type;
    private byte[] data;

    private SystemProtectionSessionTokenV1() {
        this.type = -1;
        this.data = null;
    }

    private SystemProtectionSessionTokenV1(int theType, byte[] theData) {
        this.data = theData;
        this.type = theType;
    }

    public static byte[] decryptData(byte[] data, IJVMEnvironment jvmEnv) throws CAMCryptoException {
        SPSCipher spsCipher;
        SystemProtectionSessionTokenV1.outputCipherText(data);
        SystemProtectionSessionTokenV1 token = new SystemProtectionSessionTokenV1();
        token.readToken(data);
        SystemProtectionSessionTokenV1.outputKey(token.data);
        switch (token.type) {
            case 4: {
                spsCipher = new SPSCipherAESjava(jvmEnv);
                break;
            }
            case 3: {
                spsCipher = new SPSCipherAES(jvmEnv);
                break;
            }
            case 2: {
                spsCipher = new SPSCipherDESwParity(jvmEnv);
                break;
            }
            default: {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_sys_prot_key_decrypt_failure"));
            }
        }
        return spsCipher.decryptData(token.data);
    }

    private static void outputKey(byte[] key) {
        byte[] encodedString = CryptoWrapper.encodeBase64(key);
        String identifier = new String("Java SystemProtectionSessionTokenV1.decryptData Base64 encoded Raw Key:" + encodedString.toString());
        IPFTraceFunction.trace(identifier);
    }

    private static void outputCipherText(byte[] cipherText) {
        byte[] encodedString = CryptoWrapper.encodeBase64(cipherText);
        String identifier = new String("Java SystemProtectionSessionTokenV1.GetRawKey Base64 encoded Cipher Text:" + encodedString.toString());
        IPFTraceFunction.trace(identifier);
    }

    public static byte[] encryptData(byte[] data, SPSCipher spsCipher) throws CAMCryptoException {
        byte[] ciphertext = spsCipher.encryptData(data);
        SystemProtectionSessionTokenV1 token = new SystemProtectionSessionTokenV1(spsCipher.getType(), ciphertext);
        return token.writeToken();
    }

    @Override
    public void readToken(ByteArrayInputStream in) throws CAMCryptoException {
        byte[] preamble = new byte[PREAMBLE.length];
        int len = in.read(preamble, 0, preamble.length);
        if (len != preamble.length || !Arrays.equals(PREAMBLE, preamble)) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_sys_prot_key_decrypt_failure"));
        }
        int version = this.readVersion(in);
        if (version != 1) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_sys_prot_key_decrypt_failure"));
        }
        this.type = this.readInt(in);
        this.data = this.readByteArray(in);
    }

    @Override
    public void writeToken(ByteArrayOutputStream out) throws CAMCryptoException {
        out.write(PREAMBLE, 0, PREAMBLE.length);
        this.writeVersion(out, 1);
        this.writeInt(out, this.type);
        this.writeByteArray(out, this.data);
    }
}

