/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.smartsmodule.builder.internal;

import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.ItemType;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IndexedSmartsModule {
    private Map<String, DatasetInfo> datasetMap;
    private Map<String, Map<String, ColumnInfo>> datasetsToColumnInfosByIdForExpression;
    private Map<String, Map<String, ItemType.Folder>> datasetsToFoldersByIdForExpression;
    private SmartsModule smartsModule;

    public IndexedSmartsModule(SmartsModule sm) {
        this.smartsModule = sm;
        this.datasetMap = new HashMap<String, DatasetInfo>();
        this.datasetsToColumnInfosByIdForExpression = new HashMap<String, Map<String, ColumnInfo>>();
        this.datasetsToFoldersByIdForExpression = new HashMap<String, Map<String, ItemType.Folder>>();
        for (DatasetInfo ds : sm.getDatasets()) {
            this.indexDataset(ds);
        }
        if (sm.getCalculations() != null && !sm.getCalculations().getItem().isEmpty()) {
            this.indexDataset(sm.getCalculations());
        }
    }

    private void indexDataset(DatasetInfo ds) {
        this.datasetMap.put(ds.getId(), ds);
        HashMap<String, ColumnInfo> columnInfoMap = new HashMap<String, ColumnInfo>();
        this.datasetsToColumnInfosByIdForExpression.put(ds.getId(), columnInfoMap);
        List columnInfos = SmartsModuleUtil.getFlattenedColumns((BaseItemObject)ds);
        for (ColumnInfo ci : columnInfos) {
            columnInfoMap.put(ci.getIdForExpression(), ci);
        }
        HashMap<String, ItemType.Folder> folderMap = new HashMap<String, ItemType.Folder>();
        this.datasetsToFoldersByIdForExpression.put(ds.getId(), folderMap);
        List folders = SmartsModuleUtil.getFlattenedFolders((BaseItemObject)ds);
        for (ItemType.Folder f : folders) {
            folderMap.put(f.getIdForExpression(), f);
        }
    }

    public boolean containsDatasetId(String dsId) {
        return this.datasetMap.containsKey(dsId);
    }

    public Map<String, ColumnInfo> getColumnInfos(String dsId) {
        return this.datasetsToColumnInfosByIdForExpression.getOrDefault(dsId, null);
    }

    public Map<String, ItemType.Folder> getFolders(String dsId) {
        return this.datasetsToFoldersByIdForExpression.getOrDefault(dsId, null);
    }

    public DatasetInfo getDatasetInfo(String dsId) {
        return this.datasetMap.getOrDefault(dsId, null);
    }

    public SmartsModule getSmartsModule() {
        return this.smartsModule;
    }
}

