/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.smartsmodule.builder.tasks;

import com.ibm.smarts.common.pipeline.SmartsTaskContext;
import com.ibm.smarts.core.rest.client.util.JaxRs20Exceptions;
import com.ibm.smarts.pipeline.constants.ExecutionStatus;
import com.ibm.smarts.pipeline.internal.Task;
import com.ibm.smarts.pipeline.progress.TaskStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class SmartsModuleTask
extends Task<SmartsTaskContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartsModuleTask.class);
    private static TaskStatus success = new TaskStatus(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());

    protected SmartsModuleTask(String id, List<String> inputs, List<String> outputs) {
        super(id, inputs, outputs);
    }

    protected abstract Consumer<SmartsTaskContext> task();

    public final TaskStatus execute(SmartsTaskContext context) {
        try {
            this.task().accept(context);
            return success;
        }
        catch (Throwable e) {
            LOGGER.error("task failed: " + this.id, e);
            boolean isSuccess = false;
            boolean includeCause = false;
            ArrayList<String> warnings = new ArrayList<String>();
            ArrayList<String> errors = new ArrayList<String>();
            ArrayList<String> dataSourceExceptions = new ArrayList<String>();
            Throwable c = e.getCause();
            if (c instanceof JaxRs20Exceptions.ResponseProcessingException) {
                if ((c = c.getCause()) instanceof JaxRs20Exceptions.DataSourceException) {
                    Response response = ((JaxRs20Exceptions.DataSourceException)c).getResponse();
                    dataSourceExceptions.add(response.getEntity().toString());
                    isSuccess = ((JaxRs20Exceptions.DataSourceException)c).isWarning();
                } else {
                    includeCause = true;
                }
            }
            if (isSuccess) {
                warnings.add(e.getMessage());
            } else {
                errors.add(e.getMessage());
                if (includeCause) {
                    errors.add(c.getMessage());
                }
            }
            TaskStatus status = new TaskStatus(errors, warnings, dataSourceExceptions);
            status.setStatus(isSuccess ? ExecutionStatus.COMPLETE : ExecutionStatus.ERROR);
            return status;
        }
    }

    static {
        success.setStatus(ExecutionStatus.COMPLETE);
    }
}

