/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlp.core.opennlp;

import com.ibm.smarts.core.util.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import opennlp.tools.chunker.ChunkerModel;
import opennlp.tools.doccat.DoccatModel;
import opennlp.tools.postag.POSModel;
import opennlp.tools.util.model.BaseModel;

public class NLPModelFactory {
    private static final String NLP_MODEL_DIR = "\\opennlp\\";
    private static ChunkerModel chunkerModel = null;
    private static POSModel posModel = null;
    private static DoccatModel doccatModel = null;

    public BaseModel getNLPModel(NLPModelType type) {
        File modelDir = new File(NLP_MODEL_DIR);
        if (!FileUtils.isDirectory((String)NLP_MODEL_DIR)) {
            throw new RuntimeException("Can't find directory \\opennlp\\");
        }
        BaseModel model = null;
        if (type == null) {
            return model;
        }
        try {
            if (type.equals((Object)NLPModelType.chunker)) {
                if (chunkerModel == null) {
                    chunkerModel = new ChunkerModel(this.getInputStream(modelDir, "en-chunker.bin"));
                }
                return chunkerModel;
            }
            if (type == NLPModelType.postagger) {
                if (posModel == null) {
                    posModel = new POSModel(this.getInputStream(modelDir, "en-pos-maxent.bin"));
                }
                return posModel;
            }
            if (type == NLPModelType.doccat) {
                if (doccatModel == null) {
                    doccatModel = new DoccatModel(this.getInputStream(modelDir, "en-answer.bin"));
                }
                return doccatModel;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return model;
    }

    private InputStream getInputStream(File modelDir, String fileName) throws FileNotFoundException {
        return new FileInputStream(new File(modelDir, fileName));
    }

    public static class OpenNLPFiles {
        protected static final String CHUNKER_BIN = "en-chunker.bin";
        protected static final String POS_BIN = "en-pos-maxent.bin";
        protected static final String DOC_CAT_BIN = "en-answer.bin";
    }

    public static enum NLPModelType {
        chunker,
        postagger,
        doccat;

    }
}

