/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlp.core.uima;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.SpellCheckerSession;
import com.ibm.dltj.nondeterm.AdvancedLookupDriver;
import com.ibm.smarts.nlp.core.uima.LWSpellAid;
import com.ibm.smarts.nlp.core.uima.UIMAResourceHelper;
import com.ibm.smarts.nlp.core.uima.UIMAServiceProvider;
import com.ibm.smarts.nlp.core.uima.UIMAServiceProviderException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Locale;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LWSpellAidImpl
extends LWSpellAid {
    private static final Logger LOGGER = LoggerFactory.getLogger(LWSpellAidImpl.class);
    private static CharsetEncoder asciiEncoder = Charset.forName("US-ASCII").newEncoder();
    private boolean checkOnlyAscii = false;

    LWSpellAidImpl() {
        this.init(null);
    }

    LWSpellAidImpl(Properties props) {
        this.init(props);
    }

    private void init(Properties props) {
        String localeCode = "en";
        if (props != null) {
            localeCode = props.getProperty("language", "en");
        }
        Locale locale = Locale.forLanguageTag(localeCode);
        if (props != null) {
            String bool = props.getProperty("checkOnlyAscii", "FALSE");
            this.checkOnlyAscii = Boolean.parseBoolean(bool);
        }
        try (InputStream dictionaryStream = this.getDictionaryStream(props);){
            Dictionary lexDictionary = new Dictionary(dictionaryStream, 1);
            this.mSpellCheckDictionaries = new Dictionary[]{lexDictionary};
            this.mAdvancedLookupDriver = new AdvancedLookupDriver(this.mSpellCheckDictionaries);
            this.mSpellCheckSession = new SpellCheckerSession(this.mSpellCheckDictionaries, locale.getLanguage());
            this.mSpellCheckSession.open();
            this.mIsAvailable = true;
        }
        catch (IOException e) {
            LOGGER.error("failed to close dictionary input stream", (Throwable)e);
        }
        catch (DLTException e) {
            throw new UIMAServiceProviderException("failed to create new dictionary", (Throwable)e);
        }
    }

    private InputStream getDictionaryStream(Properties props) {
        String dictionary = "dictionary/0/en-XX-LLex-7030.dic";
        if (props != null) {
            dictionary = props.getProperty("dictionary", "dictionary/0/en-XX-LLex-7030.dic");
        }
        return UIMAResourceHelper.getInputStream((String)UIMAServiceProvider.getDatapath(), (String)dictionary);
    }

    @Override
    public boolean shouldCheckSpell(String word) {
        if (super.shouldCheckSpell(word)) {
            if (this.checkOnlyAscii) {
                return LWSpellAidImpl.isPureAscii(word);
            }
            return true;
        }
        return false;
    }

    private static boolean isPureAscii(String v) {
        return asciiEncoder.canEncode(v);
    }
}

