/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlp.core.utility;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Count<T> {
    private final Map<T, CountEntry<T>> contents;
    private double totalCount = 0.0;

    public static int compare(Comparable o1, Comparable o2) {
        Class<?> o2Class;
        if (o1 == null) {
            return o2 == null ? 0 : 1;
        }
        if (o2 == null) {
            return -1;
        }
        Class<?> o1Class = o1.getClass();
        if (o1Class != (o2Class = o2.getClass())) {
            return o1Class.getCanonicalName().compareTo(o2Class.getCanonicalName());
        }
        return o1.compareTo(o2);
    }

    public double fractionOfTotal(T item) {
        return this.get(item) / this.getTotalCount();
    }

    public Count() {
        this(32);
    }

    public Count(Collection<? extends T> collection) {
        this.contents = new HashMap<T, CountEntry<T>>();
        for (T t : collection) {
            this.increment(t);
        }
    }

    public Count(int initialSize) {
        this.contents = new HashMap<T, CountEntry<T>>(initialSize);
    }

    public synchronized void addAll(Count<? extends T> other) {
        for (CountEntry<T> countEntry : other.values(SortMethod.none)) {
            this.increment(((CountEntry)countEntry).item, ((CountEntry)countEntry).count);
        }
    }

    public void addAll(List<? extends T> items) {
        for (T item : items) {
            this.increment(item);
        }
    }

    public synchronized void clear() {
        this.contents.clear();
        this.totalCount = 0.0;
    }

    public synchronized boolean containsKey(T item) {
        return this.contents.containsKey(item);
    }

    public double deviationFromUniform() {
        double N = this.getTotalCount();
        double expected = N / (double)this.size();
        int nSingle = this.contents.size() - 1;
        double max = (double)nSingle * (expected - 1.0) + (N - (double)nSingle - expected);
        if (max == 0.0) {
            return 0.0;
        }
        double sum = 0.0;
        for (CountEntry<T> f : this.contents.values()) {
            sum += Math.abs(((CountEntry)f).count - expected);
        }
        return sum / max;
    }

    public synchronized boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Count)) {
            return false;
        }
        Count count = (Count)o;
        return this.contents.equals(count.contents);
    }

    public synchronized double get(T item) {
        CountEntry<T> entry = this.contents.get(item);
        return entry == null ? 0.0 : ((CountEntry)entry).count;
    }

    public synchronized double get(T item, double defaultCount) {
        CountEntry<T> entry = this.contents.get(item);
        return entry == null ? defaultCount : ((CountEntry)entry).count;
    }

    public synchronized List<T> getAllValues() {
        return new ArrayList<T>(this.contents.keySet());
    }

    public synchronized CountEntry<T> getEntry(T item) {
        return this.contents.get(item);
    }

    public synchronized double getTotalCount() {
        return this.totalCount;
    }

    public synchronized int hashCode() {
        return this.contents.hashCode();
    }

    public double highestFrequency() {
        double best = 0.0;
        for (CountEntry<T> entry : this.contents.values()) {
            if (!(((CountEntry)entry).count > best)) continue;
            best = ((CountEntry)entry).count;
        }
        return best;
    }

    public synchronized double increment(T item) {
        return this.increment(item, 1.0);
    }

    public synchronized double increment(T item, double count) {
        if (count <= 0.0) {
            return this.get(item);
        }
        CountEntry<T> entry = this.contents.get(item);
        if (entry == null) {
            this.contents.put(item, new CountEntry(item, count));
            this.totalCount += count;
            return count;
        }
        ((CountEntry)entry).count = ((CountEntry)entry).count + count;
        this.totalCount += count;
        return ((CountEntry)entry).count;
    }

    public synchronized boolean isEmpty() {
        return this.contents.isEmpty();
    }

    public synchronized Set<T> keySet() {
        return this.contents.keySet();
    }

    public synchronized List<T> mostFrequent(int N) {
        LinkedList<T> list = new LinkedList<T>();
        Collection<CountEntry<T>> entries = this.values(SortMethod.descendingByCount);
        for (CountEntry<T> entry : entries) {
            list.add(entry.getItem());
            if (--N != 0) continue;
            break;
        }
        return list;
    }

    public T mostFrequentEntry() {
        Object result = null;
        double best = 0.0;
        for (CountEntry<T> entry : this.contents.values()) {
            if (!(((CountEntry)entry).count > best)) continue;
            best = ((CountEntry)entry).count;
            result = ((CountEntry)entry).item;
        }
        return (T)result;
    }

    public synchronized CountEntry<T> put(T item, double value) {
        CountEntry<T> entry = this.contents.get(item);
        if (entry == null) {
            this.totalCount += value;
            entry = new CountEntry(item, value);
            this.contents.put(item, entry);
        } else {
            this.totalCount += value - ((CountEntry)entry).count;
            ((CountEntry)entry).count = value;
        }
        return entry;
    }

    public synchronized CountEntry<T> remove(T item) {
        CountEntry<T> entry = this.contents.remove(item);
        if (entry != null) {
            this.totalCount -= ((CountEntry)entry).count;
        }
        return entry;
    }

    public synchronized void retainFrequentEntries(double count) {
        Collection<CountEntry<T>> entries = this.values(SortMethod.descendingByCount);
        for (CountEntry<T> entry : entries) {
            if (!(((CountEntry)entry).count < count)) continue;
            this.remove(((CountEntry)entry).item);
        }
    }

    public synchronized int size() {
        return this.contents.size();
    }

    public String toString() {
        return this.values(SortMethod.descendingByCount).toString();
    }

    public synchronized Collection<CountEntry<T>> values(Comparator<CountEntry<T>> comparator) {
        ArrayList<CountEntry<T>> list = new ArrayList<CountEntry<T>>(this.contents.values());
        list.sort(comparator);
        return list;
    }

    public synchronized Collection<CountEntry<T>> values(SortMethod sortMethod) {
        Collection<CountEntry<T>> entries = this.contents.values();
        if (sortMethod == SortMethod.ascendingByCount) {
            ArrayList<CountEntry<T>> list = new ArrayList<CountEntry<T>>(entries);
            Collections.sort(list);
            return list;
        }
        if (sortMethod == SortMethod.descendingByCount) {
            ArrayList<CountEntry<T>> list = new ArrayList<CountEntry<T>>(entries);
            list.sort(Collections.reverseOrder());
            return list;
        }
        return entries;
    }

    public static enum SortMethod {
        ascendingByCount,
        descendingByCount,
        none;

    }

    public static final class CountEntry<T>
    implements Comparable<CountEntry<T>> {
        private final T item;
        private double count;

        public CountEntry(T item) {
            this.item = item;
        }

        private CountEntry(T item, double count) {
            this.item = item;
            this.count = count;
        }

        @Override
        public int compareTo(CountEntry<T> o) {
            if (this == o) {
                return 0;
            }
            int d = Double.compare(this.count, o.count);
            if (d != 0) {
                return d;
            }
            if (this.item instanceof Comparable) {
                return Count.compare((Comparable)this.item, (Comparable)o.item);
            }
            if (this.item.equals(o.item)) {
                return 0;
            }
            int hashCodeDifference = this.item.hashCode() - o.item.hashCode();
            if (hashCodeDifference != 0) {
                return hashCodeDifference;
            }
            int stringDifference = this.item.toString().compareTo(o.item.toString());
            if (stringDifference != 0) {
                return stringDifference;
            }
            try {
                Method rawHashCodeMethod = Object.class.getMethod("hashCode", new Class[0]);
                Integer a = (Integer)rawHashCodeMethod.invoke(this.item, new Object[0]);
                Integer b = (Integer)rawHashCodeMethod.invoke(o.item, new Object[0]);
                return a - b;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CountEntry)) {
                return false;
            }
            CountEntry entry = (CountEntry)o;
            return this.count == entry.count && this.item.equals(entry.item);
        }

        public double getCount() {
            return this.count;
        }

        public T getItem() {
            return this.item;
        }

        public int hashCode() {
            long temp = Double.doubleToLongBits(this.count);
            int result = 31 + (int)(temp ^ temp >>> 32);
            return 31 * result + this.item.hashCode();
        }

        public String toString() {
            return this.item.toString() + (this.count > 10.0 ? ":" + (int)this.count : ":" + this.count);
        }
    }
}

