/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.classifier.smartsmodule;

import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.ontology.classifier.smartsmodule.AbstractSmartsModuleClassificationStep;
import com.ibm.smarts.ontology.classifier.smartsmodule.SmartsModuleClassificationPkg;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.ObjectFactory;
import java.util.Optional;
import java.util.stream.Stream;

public class DomainConceptClassification
extends AbstractSmartsModuleClassificationStep {
    protected DomainConceptClassification(RequestContext requestContext) {
        super(requestContext);
    }

    @Override
    public void execute(SmartsModuleClassificationPkg smPkg) {
        this.classify(smPkg);
    }

    private void classify(SmartsModuleClassificationPkg smPkg) {
        ObjectFactory objFactory = new ObjectFactory();
        smPkg.getDatasetClassificationPkgs().stream().forEach(d -> {
            Stream classificationStream = this.isExecParallel() ? d.getInScopeColumnClassificationPkgs().parallelStream() : d.getInScopeColumnClassificationPkgs().stream();
            classificationStream.forEach(columnPkg -> columnPkg.getCandidates().stream().filter(c -> Float.compare(c.getRelevance(), 0.0f) > 0 && this.isVisibleClass(c.getConceptID(), true)).forEach(c -> {
                float confidenceScore = this.computeConfidenceScore((SmartsModuleClassificationPkg.Candidate)c);
                Optional<ConceptInfo> existing = columnPkg.getConcepts().stream().filter(concept -> concept.getConceptID().equals(c.getConceptID().toString())).findFirst();
                if (existing.isPresent()) {
                    if (Float.compare(existing.get().getConfidence(), confidenceScore) < 0) {
                        existing.get().setConfidence(confidenceScore);
                    }
                } else {
                    ConceptInfo concept2 = objFactory.createConceptInfo();
                    concept2.setConceptID(c.getConceptID().toString());
                    concept2.setConfidence(confidenceScore);
                    columnPkg.addConcept(concept2);
                }
            }));
        });
    }
}

