/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.classifier.smartsmodule;

import com.ibm.smarts.common.pipeline.DeltaAnalysisScope;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.internal.ontology.api.Ontology;
import com.ibm.smarts.ontology.classifier.smartsmodule.AbstractSmartsModuleClassificationStep;
import com.ibm.smarts.ontology.classifier.smartsmodule.SmartsModuleClassificationPkg;
import com.ibm.smarts.ontology.util.KnowledgeDiscoveryHelper;
import com.ibm.smarts.schema.ConceptInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLNamedObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.slf4j.MDC;

public class EntityCandidateElection
extends AbstractSmartsModuleClassificationStep {
    private List<Ontology<OWLOntology>> ontologies = null;

    EntityCandidateElection(List<Ontology<OWLOntology>> ontologies, RequestContext requestContext) {
        super(requestContext);
        this.ontologies = ontologies;
    }

    @Override
    public void execute(SmartsModuleClassificationPkg smPkg) {
        smPkg.setModified(smPkg.getDatasetClassificationPkgs().parallelStream().map(this::classify).reduce(Boolean::logicalOr).orElse(false));
        this.clearMDC();
    }

    private boolean classify(SmartsModuleClassificationPkg.DatasetClassificationPkg dsPkg) {
        MDC.put((String)"DatasetID", (String)("[" + dsPkg.getDataset().getId() + "]"));
        List<SmartsModuleClassificationPkg.ColumnClassificationPkg> inScopeColPkgs = dsPkg.getInScopeColumnClassificationPkgs();
        if (inScopeColPkgs.isEmpty()) {
            return false;
        }
        if (this.isExecParallel()) {
            return IntStream.range(0, inScopeColPkgs.size()).parallel().mapToObj(i -> this.classify(i, (SmartsModuleClassificationPkg.ColumnClassificationPkg)inScopeColPkgs.get(i), dsPkg.getDelatAnalysisScope())).reduce(Boolean::logicalOr).orElse(false);
        }
        return IntStream.range(0, inScopeColPkgs.size()).mapToObj(i -> this.classify(i, (SmartsModuleClassificationPkg.ColumnClassificationPkg)inScopeColPkgs.get(i), dsPkg.getDelatAnalysisScope())).reduce(Boolean::logicalOr).orElse(false);
    }

    private boolean classify(int index, SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, DeltaAnalysisScope deltaAnalysisScope) {
        if (this.shouldExecute(columnPkg, deltaAnalysisScope, DeltaAnalysisScope.ModifiableProperty.ALL, DeltaAnalysisScope.ModifiableProperty.CONCEPTS, DeltaAnalysisScope.ModifiableProperty.USAGE, DeltaAnalysisScope.ModifiableProperty.NAME)) {
            MDC.put((String)"ColumnIndex", (String)("[" + index + "]"));
            MDC.put((String)"ColumnID", (String)("[" + columnPkg.getColumnInfo().getName() + "]"));
            return this.ontologies.stream().map(o -> this.electEntityCandidates(columnPkg, (Ontology<OWLOntology>)o)).reduce(Boolean::logicalOr).orElse(false);
        }
        return false;
    }

    private boolean electEntityCandidates(SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, Ontology<OWLOntology> ontology) {
        if (columnPkg.getCandidates().isEmpty() && !columnPkg.getConcepts().stream().anyMatch(this::isDomainConcept)) {
            return false;
        }
        OWLDataFactory factory = ((OWLOntology)ontology.getValue()).getOWLOntologyManager().getOWLDataFactory();
        OWLReasoner reasoner = KnowledgeDiscoveryHelper.getOntologyResourceManager(this.currentReqCtx).getDomainOntologyManager().getReasoner(ontology);
        if (this.isActualMeasureColumn(columnPkg, reasoner, factory)) {
            return false;
        }
        ArrayList<Boolean> modifiedFlag = new ArrayList<Boolean>();
        Optional<SmartsModuleClassificationPkg.Candidate> headCandidate = this.getHeadCandidate(columnPkg, factory, reasoner);
        if (!headCandidate.isPresent() || this.isMeasure(headCandidate.get(), reasoner, factory)) {
            return false;
        }
        SmartsModuleClassificationPkg.Candidate head = headCandidate.get();
        LOGGER.info("Find entity candidate [{}] for non-measure column {}", (Object)head.toString(), (Object)columnPkg.getColumnInfo().getId());
        if (this.isEntity(head, reasoner, factory)) {
            this.setHeadEntityDefaultAttribute(columnPkg, ontology, factory, reasoner, modifiedFlag, head);
        } else {
            this.findEntityCandidates(columnPkg, ontology, factory, reasoner, modifiedFlag, head);
        }
        this.resolveEntityWithinColumn(columnPkg, factory, reasoner, modifiedFlag, head);
        this.addEntityDefaultAttribute(columnPkg, ontology, factory, reasoner, modifiedFlag);
        return !modifiedFlag.isEmpty();
    }

    private void findEntityCandidates(SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, Ontology<OWLOntology> ontology, OWLDataFactory factory, OWLReasoner reasoner, List<Boolean> modifiedFlag, SmartsModuleClassificationPkg.Candidate head) {
        OWLClass aClass = factory.getOWLClass(head.getConceptID());
        Set aClassEntities = this.getEntities(aClass, (OWLOntology)ontology.getValue(), reasoner, factory).stream().map(e -> new SmartsModuleClassificationPkg.Candidate(e.getIRI()).setRelevance(head.getRelevance()).setDataHintRelevance(head.getDataHintRelevance()).setDataValueRelevance(head.getDataValueRelevance())).filter(e -> this.isEntity((SmartsModuleClassificationPkg.Candidate)e, reasoner, factory)).collect(Collectors.toSet());
        if (!aClassEntities.isEmpty()) {
            columnPkg.getEntityCandidates(head).addAll(aClassEntities);
            modifiedFlag.add(true);
            LOGGER.info("Entity candidate of {} = {}", (Object)aClass.getIRI().getShortForm(), (Object)aClassEntities.stream().map(e -> e.getConceptID().getShortForm()).collect(Collectors.joining(",")));
        }
    }

    private void setHeadEntityDefaultAttribute(SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, Ontology<OWLOntology> ontology, OWLDataFactory factory, OWLReasoner reasoner, List<Boolean> modifiedFlag, SmartsModuleClassificationPkg.Candidate head) {
        SmartsModuleClassificationPkg.Candidate defaultAttribute = this.getDefaultAttribute(columnPkg, ontology, factory, reasoner);
        LOGGER.info("Convert Candidate {} to entity of {}", (Object)head.getConceptID().getShortForm(), (Object)defaultAttribute.getConceptID().getShortForm());
        columnPkg.getEntityCandidates(defaultAttribute).add(head);
        columnPkg.getCandidates().remove(head);
        if (!columnPkg.getCandidates().contains(defaultAttribute)) {
            columnPkg.addCandidate(Optional.of(defaultAttribute));
        }
        modifiedFlag.add(true);
    }

    private void addEntityDefaultAttribute(SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, Ontology<OWLOntology> ontology, OWLDataFactory factory, OWLReasoner reasoner, List<Boolean> modifiedFlag) {
        Optional<SmartsModuleClassificationPkg.Candidate> entityRoot = columnPkg.getCandidates().stream().filter(c -> c.getConceptID().equals((Object)ENTITY_ROOT_IRI) && Float.compare(c.getRelevance(), 0.0f) > 0).findFirst();
        if (columnPkg.getAllEntityCandidates().values().stream().flatMap(Collection::stream).filter(c -> this.isEntity((SmartsModuleClassificationPkg.Candidate)c, reasoner, factory)).count() == 0L && entityRoot.isPresent() && !this.isMeasureColumn(columnPkg, reasoner, factory)) {
            SmartsModuleClassificationPkg.Candidate defaultAttribute = this.getDefaultAttribute(columnPkg, ontology, factory, reasoner);
            LOGGER.info("Convert Candidate {} to entity of {}", (Object)entityRoot.get().getConceptID().getShortForm(), (Object)defaultAttribute.getConceptID().getShortForm());
            columnPkg.getEntityCandidates(defaultAttribute).add(entityRoot.get());
            columnPkg.getCandidates().remove(entityRoot.get());
            if (!columnPkg.getCandidates().contains(defaultAttribute)) {
                columnPkg.addCandidate(Optional.of(defaultAttribute));
            }
            modifiedFlag.add(true);
        }
    }

    private void resolveEntityWithinColumn(SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, OWLDataFactory factory, OWLReasoner reasoner, List<Boolean> modifiedFlag, SmartsModuleClassificationPkg.Candidate head) {
        if (columnPkg.getCandidates().size() > 1) {
            ArrayList toBeRemoved = new ArrayList();
            IntStream.range(1, columnPkg.getCandidates().size()).forEach(i -> {
                SmartsModuleClassificationPkg.Candidate aCandidate = columnPkg.getCandidates().get(i);
                Optional<SmartsModuleClassificationPkg.Candidate> entity = this.getIntersectionCandidate(columnPkg.getEntityCandidates(head), aCandidate, reasoner, factory);
                if (entity.isPresent()) {
                    if (Float.compare(entity.get().getRelevance(), 0.0f) < 0 && this.isMeasure(entity.get(), reasoner, factory)) {
                        columnPkg.getAllEntityCandidates().remove(head);
                        toBeRemoved.add(entity.get());
                    } else {
                        SmartsModuleClassificationPkg.Candidate can = columnPkg.getEntityCandidates(head).iterator().next();
                        if (this.isAbstractEntity(can) || Float.compare(can.getRelevance(), aCandidate.getRelevance()) <= 0) {
                            columnPkg.getEntityCandidates(head).clear();
                            columnPkg.getEntityCandidates(head).add(entity.get());
                            toBeRemoved.add(entity.get());
                        }
                    }
                    modifiedFlag.add(true);
                }
            });
            if (!toBeRemoved.isEmpty()) {
                LOGGER.info("Removed candidates [{}] from column [{}]", (Object)((Object)toBeRemoved).toString(), (Object)columnPkg.getColumnInfo().getName());
            }
            columnPkg.getCandidates().removeAll(toBeRemoved);
        }
    }

    private Optional<SmartsModuleClassificationPkg.Candidate> getHeadCandidate(SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, OWLDataFactory factory, OWLReasoner reasoner) {
        Optional<ConceptInfo> headConcept = columnPkg.getConcepts().stream().filter(this::isDomainConcept).sorted(Comparator.comparingDouble(ConceptInfo::getConfidence).reversed()).findFirst();
        if (headConcept.isPresent()) {
            SmartsModuleClassificationPkg.Candidate headCandidate = new SmartsModuleClassificationPkg.Candidate(IRI.create((String)headConcept.get().getConceptID()));
            headCandidate.setConfidence(headConcept.get().getConfidence());
            headCandidate.setRelevance(1.0f);
            return Optional.of(headCandidate);
        }
        columnPkg.getCandidates().sort((c1, c2) -> Float.compare(c2.getRelevance(), c1.getRelevance()));
        float maxRelevance = columnPkg.getCandidates().get(0).getRelevance();
        if (Float.compare(maxRelevance, 0.0f) < 0) {
            return Optional.empty();
        }
        List potentialHead = columnPkg.getCandidates().stream().filter(c -> Float.compare(c.getRelevance(), maxRelevance) == 0).collect(Collectors.toList());
        Set potentialHeadSet = potentialHead.stream().map(h -> factory.getOWLClass(h.getConceptID())).collect(Collectors.toSet());
        Iterator it = potentialHead.iterator();
        while (potentialHead.size() > 1 && it.hasNext()) {
            SmartsModuleClassificationPkg.Candidate c3 = (SmartsModuleClassificationPkg.Candidate)it.next();
            Set descendants = reasoner.getSubClasses((OWLClassExpression)factory.getOWLClass(c3.getConceptID()), false).getFlattened();
            if (!descendants.removeAll(potentialHeadSet)) continue;
            it.remove();
        }
        Optional<SmartsModuleClassificationPkg.Candidate> head = Optional.empty();
        if (!potentialHead.isEmpty()) {
            if (potentialHead.size() > 1) {
                potentialHead.sort((c1, c2) -> c1.getConceptID().getShortForm().compareTo(c2.getConceptID().getShortForm()));
            }
            head = Optional.of(potentialHead.get(0));
        }
        return head;
    }

    private SmartsModuleClassificationPkg.Candidate getDefaultAttribute(SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, Ontology<OWLOntology> ontology, OWLDataFactory factory, OWLReasoner reasoner) {
        HashSet<IRI> defaultAtts = new HashSet<IRI>();
        defaultAtts.add(IDENTIFIER_IRI);
        defaultAtts.add(CAPTION_IRI);
        defaultAtts.add(DESCRIPTION_IRI);
        defaultAtts.addAll(this.getSubClasses(factory, reasoner, IDENTIFIER_IRI));
        defaultAtts.addAll(this.getSubClasses(factory, reasoner, CAPTION_IRI));
        defaultAtts.addAll(this.getSubClasses(factory, reasoner, DESCRIPTION_IRI));
        Optional<SmartsModuleClassificationPkg.Candidate> attr = columnPkg.getCandidates().stream().filter(c -> defaultAtts.contains(c.getConceptID())).filter(c -> Float.compare(c.getRelevance(), 0.0f) > 0).sorted(Comparator.comparing(SmartsModuleClassificationPkg.Candidate::getRelevance).reversed()).findFirst();
        if (attr.isPresent()) {
            return attr.get();
        }
        SmartsModuleClassificationPkg.Candidate defaultAttribute = null;
        HashMap<IRI, List<ConceptInfo>> propertyValues = new HashMap<IRI, List<ConceptInfo>>();
        List<ConceptInfo> patterns = columnPkg.getConcepts();
        propertyValues.put(HAS_PATTERN_PROPERTY_IRI, patterns);
        defaultAttribute = this.isApplicableConcept(IDENTIFIER_IRI, columnPkg, ontology, factory, reasoner) ? new SmartsModuleClassificationPkg.Candidate(IDENTIFIER_IRI).setRelevance(0.01f).setDataHintRelevance(1.0f).setDataValueRelevance(1.0f) : (!columnPkg.getCandidates().stream().anyMatch(c -> c.getConceptID().equals((Object)CAPTION_IRI)) ? new SmartsModuleClassificationPkg.Candidate(CAPTION_IRI).setRelevance(0.01f).setDataHintRelevance(1.0f).setDataValueRelevance(1.0f) : new SmartsModuleClassificationPkg.Candidate(DESCRIPTION_IRI).setRelevance(0.01f).setDataHintRelevance(1.0f).setDataValueRelevance(1.0f));
        return defaultAttribute;
    }

    private Set<IRI> getSubClasses(OWLDataFactory factory, OWLReasoner reasoner, IRI aConcept) {
        return reasoner.getSubClasses((OWLClassExpression)factory.getOWLClass(aConcept), false).getFlattened().stream().map(OWLNamedObject::getIRI).collect(Collectors.toSet());
    }

    private Set<IRI> getSuperClasses(OWLDataFactory factory, OWLReasoner reasoner, IRI aConcept) {
        return reasoner.getSuperClasses((OWLClassExpression)factory.getOWLClass(aConcept), false).getFlattened().stream().map(OWLNamedObject::getIRI).collect(Collectors.toSet());
    }

    private Optional<SmartsModuleClassificationPkg.Candidate> getIntersectionCandidate(Set<SmartsModuleClassificationPkg.Candidate> entities, SmartsModuleClassificationPkg.Candidate candidate, OWLReasoner reasoner, OWLDataFactory factory) {
        if (entities.contains(candidate) || entities.stream().map(e -> factory.getOWLClass(e.getConceptID())).anyMatch(e -> reasoner.getSubClasses((OWLClassExpression)e, false).getFlattened().contains(factory.getOWLClass(candidate.getConceptID())))) {
            return Optional.of(candidate);
        }
        OWLClass candidateClass = factory.getOWLClass(candidate.getConceptID());
        return entities.stream().filter(e -> {
            OWLClass eClass = factory.getOWLClass(e.getConceptID());
            return reasoner.getSuperClasses((OWLClassExpression)eClass, false).getFlattened().contains(candidateClass);
        }).findFirst();
    }
}

