/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.classifier.smartsmodule;

import com.ibm.smarts.common.pipeline.DeltaAnalysisScope;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.internal.ontology.api.Ontology;
import com.ibm.smarts.ontology.classifier.smartsmodule.AbstractSmartsModuleClassificationStep;
import com.ibm.smarts.ontology.classifier.smartsmodule.SmartsModuleClassificationPkg;
import com.ibm.smarts.ontology.util.KnowledgeDiscoveryHelper;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.LogicalGroup;
import com.ibm.smarts.schema.LogicalGroupType;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class ScenarioGroupDetection
extends AbstractSmartsModuleClassificationStep {
    private List<Ontology<OWLOntology>> mOntologies = null;

    ScenarioGroupDetection(List<Ontology<OWLOntology>> ontologies, RequestContext requestContext) {
        super(requestContext);
        this.mOntologies = ontologies;
    }

    @Override
    public void execute(SmartsModuleClassificationPkg smPkg) {
        smPkg.setModified(smPkg.getDatasetClassificationPkgs().parallelStream().map(this::classify).reduce(Boolean::logicalOr).orElse(false));
        this.clearMDC();
    }

    private boolean classify(SmartsModuleClassificationPkg.DatasetClassificationPkg dsPkg) {
        this.mdcDSInfo(dsPkg);
        List<SmartsModuleClassificationPkg.ColumnClassificationPkg> inScopeColPkgs = dsPkg.getInScopeColumnClassificationPkgs();
        if (inScopeColPkgs.isEmpty()) {
            return false;
        }
        IntStream.range(0, inScopeColPkgs.size()).forEach(i -> this.classify(i, (SmartsModuleClassificationPkg.ColumnClassificationPkg)inScopeColPkgs.get(i), dsPkg));
        return false;
    }

    private boolean classify(int index, SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, SmartsModuleClassificationPkg.DatasetClassificationPkg dsPkg) {
        if (this.onlyPropModified(columnPkg, dsPkg.getDelatAnalysisScope(), DeltaAnalysisScope.ModifiableProperty.AGGREGATION)) {
            return false;
        }
        this.mdcColInfo(index, columnPkg);
        ConceptInfo plannedConcept = columnPkg.getColumnInfo().getSemanticInfo().getConcepts().stream().filter(c -> c.getConceptID().equals("http://www.ibm.com/ontologies/waca/domain/common#Planned")).findFirst().orElse(null);
        if (plannedConcept != null) {
            Ontology<OWLOntology> ontology = this.mOntologies.get(0);
            OWLDataFactory factory = ((OWLOntology)ontology.getValue()).getOWLOntologyManager().getOWLDataFactory();
            OWLReasoner reasoner = KnowledgeDiscoveryHelper.getOntologyResourceManager(this.currentReqCtx).getDomainOntologyManager().getReasoner(ontology);
            ConceptInfo plannedMeasure = null;
            List domainConcepts = columnPkg.getColumnInfo().getSemanticInfo().getConcepts().stream().filter(this::isDomainConcept).sorted(Comparator.comparingDouble(ConceptInfo::getConfidence).reversed()).collect(Collectors.toList());
            for (ConceptInfo concept : domainConcepts) {
                if (!reasoner.getSuperClasses((OWLClassExpression)factory.getOWLClass(IRI.create((String)concept.getConceptID())), false).containsEntity((OWLObject)factory.getOWLClass(MEASURE_ROOT_IRI))) continue;
                plannedMeasure = concept;
                break;
            }
            if (plannedMeasure == null) {
                plannedMeasure = columnPkg.getColumnInfo().getSemanticInfo().getConcepts().stream().filter(c -> c.getConceptID().equals("http://www.ibm.com/ontologies/waca/domain/common#Measure")).findFirst().orElse(null);
            }
            if (plannedMeasure != null) {
                ConceptInfo targetMeasure = plannedMeasure;
                dsPkg.getColumnClassificationPkgs().stream().filter(col -> !col.getColumnInfo().getId().equals(columnPkg.getColumnInfo().getId())).forEach(col -> {
                    if (targetMeasure.getConceptID().equals("http://www.ibm.com/ontologies/waca/domain/common#Measure")) {
                        ConceptInfo actualConcept = col.getColumnInfo().getSemanticInfo().getConcepts().stream().filter(c -> c.getConceptID().equals("http://www.ibm.com/ontologies/waca/domain/common#Actual")).findFirst().orElse(null);
                        if (actualConcept != null && col.getDefaultAggregation() == columnPkg.getDefaultAggregation() && col.getColumnInfo().getSemanticInfo().getConcepts().stream().anyMatch(c -> c.getConceptID().equals("http://www.ibm.com/ontologies/waca/domain/common#Measure"))) {
                            this.addScenarioGroup(plannedConcept, actualConcept, targetMeasure, columnPkg, (SmartsModuleClassificationPkg.ColumnClassificationPkg)col, dsPkg);
                        }
                    } else {
                        ConceptInfo actualMeasure = col.getColumnInfo().getSemanticInfo().getConcepts().stream().filter(c -> c.getConceptID().equals(targetMeasure.getConceptID())).findFirst().orElse(null);
                        if (actualMeasure != null && col.getColumnInfo().getSemanticInfo().getConcepts().stream().noneMatch(c -> c.getConceptID().equals("http://www.ibm.com/ontologies/waca/domain/common#Planned"))) {
                            ConceptInfo actualConcept = col.getColumnInfo().getSemanticInfo().getConcepts().stream().filter(c -> c.getConceptID().equals("http://www.ibm.com/ontologies/waca/domain/common#Actual")).findFirst().orElse(null);
                            if (actualConcept == null) {
                                actualConcept = this.makeImplicitActualConcept(actualMeasure);
                            }
                            this.addScenarioGroup(plannedConcept, actualConcept, targetMeasure, columnPkg, (SmartsModuleClassificationPkg.ColumnClassificationPkg)col, dsPkg);
                        }
                    }
                });
            }
        }
        return false;
    }

    private void addScenarioGroup(ConceptInfo plannedConcept, ConceptInfo actualConcept, ConceptInfo plannedMeasure, SmartsModuleClassificationPkg.ColumnClassificationPkg plannedCol, SmartsModuleClassificationPkg.ColumnClassificationPkg actualCol, SmartsModuleClassificationPkg.DatasetClassificationPkg dsPkg) {
        LogicalGroup lg = new LogicalGroup();
        lg.setLogicGroupType(LogicalGroupType.SCENARIO);
        lg.setConcept(plannedMeasure);
        lg.setId(String.valueOf(this.nextGroupID(dsPkg)));
        lg.getMember().add(this.buildGroupMember(plannedConcept, plannedCol, dsPkg));
        lg.getMember().add(this.buildGroupMember(actualConcept, actualCol, dsPkg));
        dsPkg.getDataset().getLogicalGroups().add(lg);
    }

    private int nextGroupID(SmartsModuleClassificationPkg.DatasetClassificationPkg dsPkg) {
        return dsPkg.getDataset().getLogicalGroups().isEmpty() ? 0 : Integer.parseInt(((LogicalGroup)dsPkg.getDataset().getLogicalGroups().get(dsPkg.getDataset().getLogicalGroups().size() - 1)).getId()) + 1;
    }

    private LogicalGroup.Member buildGroupMember(ConceptInfo concept, SmartsModuleClassificationPkg.ColumnClassificationPkg colPkg, SmartsModuleClassificationPkg.DatasetClassificationPkg dsPkg) {
        LogicalGroup.Member member = new LogicalGroup.Member();
        member.setAttribute(concept);
        member.setColumnId(colPkg.getColumnInfo().getId());
        member.setIdForExpression(colPkg.getColumnInfo().getIdForExpression());
        member.setDatasetId(dsPkg.getDataset().getId());
        return member;
    }

    private ConceptInfo makeImplicitActualConcept(ConceptInfo actualMeasure) {
        ConceptInfo actualConcept = new ConceptInfo();
        actualConcept.setConceptID("http://www.ibm.com/ontologies/waca/domain/common#Actual");
        actualConcept.setConfidence(actualMeasure.getConfidence());
        return actualConcept;
    }
}

