/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.classifier.smartsmodule;

import com.ibm.smarts.common.pipeline.DeltaAnalysisScope;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.internal.ontology.api.Ontology;
import com.ibm.smarts.ontology.classifier.smartsmodule.AbstractSmartsModuleClassificationStep;
import com.ibm.smarts.ontology.classifier.smartsmodule.SmartsModuleClassificationPkg;
import com.ibm.smarts.ontology.util.KnowledgeDiscoveryHelper;
import com.ibm.smarts.schema.UsageType;
import java.util.List;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class UsageResolution
extends AbstractSmartsModuleClassificationStep {
    private List<Ontology<OWLOntology>> mOntologies = null;

    UsageResolution(List<Ontology<OWLOntology>> ontologies, RequestContext requestContext) {
        super(requestContext);
        this.mOntologies = ontologies;
    }

    @Override
    public void execute(SmartsModuleClassificationPkg pkg) {
        Ontology<OWLOntology> ontology = this.mOntologies.get(0);
        OWLDataFactory factory = ((OWLOntology)ontology.getValue()).getOWLOntologyManager().getOWLDataFactory();
        OWLReasoner reasoner = KnowledgeDiscoveryHelper.getOntologyResourceManager(this.currentReqCtx).getDomainOntologyManager().getReasoner(ontology);
        pkg.getDatasetClassificationPkgs().forEach(dp -> dp.getInScopeColumnClassificationPkgs().stream().filter(colPkg -> this.shouldExecute((SmartsModuleClassificationPkg.ColumnClassificationPkg)colPkg, dp.getDelatAnalysisScope(), DeltaAnalysisScope.ModifiableProperty.ALL, DeltaAnalysisScope.ModifiableProperty.CONCEPTS, DeltaAnalysisScope.ModifiableProperty.USAGE, DeltaAnalysisScope.ModifiableProperty.NAME)).forEach(cp -> cp.setUsage(this.resolveUsageType((SmartsModuleClassificationPkg.ColumnClassificationPkg)cp, factory, reasoner, dp.getDelatAnalysisScope()))));
    }

    private UsageType resolveUsageType(SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, OWLDataFactory factory, OWLReasoner reasoner, DeltaAnalysisScope deltaAnalysisScope) {
        boolean hasUsageDelta = this.hasModifiedDelta(columnPkg, deltaAnalysisScope, DeltaAnalysisScope.ModifiableProperty.USAGE);
        if (hasUsageDelta && columnPkg.getColumnInfo().getSemanticInfo() != null) {
            return columnPkg.getColumnInfo().getSemanticInfo().getUsage();
        }
        if (columnPkg.getColumnInfo().getKeyType() != null) {
            return UsageType.IDENTIFIER;
        }
        if (this.isMeasureColumn(columnPkg.getColumnInfo().getSemanticInfo(), reasoner, factory) && !this.isNoneMeasureData(columnPkg)) {
            return UsageType.FACT;
        }
        if (this.isIdentifierColumn(columnPkg, reasoner, factory)) {
            return UsageType.IDENTIFIER;
        }
        return UsageType.ATTRIBUTE;
    }

    private boolean isNoneMeasureData(SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg) {
        return columnPkg.getColumnInfo().getDataType().isString() || columnPkg.getColumnInfo().getDataType().isUnknown() || columnPkg.getCandidates().stream().filter(c -> c.getRelevance() > 0.0f).anyMatch(c -> c.getConceptID().equals((Object)EMPTY_IRI));
    }
}

