/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.classifier.text;

import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.PhraseInfo;
import com.ibm.smarts.schema.TextInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLObject;

public class TextSemanticAnalysisPkg {
    private final Optional<TextInfo> text;
    private final List<PhraseSemanticAnalysisPkg> phrasePkg;

    TextSemanticAnalysisPkg(@Nonnull TextInfo txt) {
        this.text = Optional.of(txt);
        this.phrasePkg = txt.getPhrases().stream().map(PhraseSemanticAnalysisPkg::new).collect(Collectors.toList());
    }

    Optional<PhraseSemanticAnalysisPkg> getPhraseSemanticAnalysisPkg(int index) {
        if (index >= 0 && index < this.phrasePkg.size()) {
            return Optional.of(this.phrasePkg.get(index));
        }
        return Optional.empty();
    }

    @Nonnull
    TextInfo getText() {
        return this.text.orElse(new TextInfo());
    }

    @Nonnull
    List<PhraseSemanticAnalysisPkg> getPhraseSemanticAnalysisPkgs() {
        return this.phrasePkg;
    }

    List<List<ConceptInfo>> getConcepts() {
        return this.phrasePkg.stream().map(PhraseSemanticAnalysisPkg::getConcepts).collect(Collectors.toList());
    }

    List<List<Candidate>> getCandidates() {
        return this.phrasePkg.stream().map(PhraseSemanticAnalysisPkg::getCandidates).collect(Collectors.toList());
    }

    static class Candidate
    implements Comparable<Candidate> {
        private IRI conceptID;
        private float relevance;
        private float confidence;

        Candidate(@Nonnull IRI conceptID) {
            this.conceptID = conceptID;
        }

        IRI getConceptID() {
            return this.conceptID;
        }

        float getRelevance() {
            return this.relevance;
        }

        Candidate setRelevance(float score) {
            this.relevance = score;
            return this;
        }

        Candidate setConfidence(float confidence) {
            this.confidence = confidence;
            return this;
        }

        float getConfidence() {
            return this.confidence;
        }

        @Override
        public int compareTo(Candidate other) {
            return this.conceptID.compareTo((OWLObject)other.getConceptID());
        }

        public boolean equals(Object obj) {
            if (obj instanceof Candidate) {
                return this.compareTo((Candidate)obj) == 0;
            }
            return false;
        }

        public int hashCode() {
            return this.conceptID.hashCode();
        }

        public String toString() {
            return "Candidate [conceptID=" + this.conceptID + ", relevance=" + this.relevance + ", confidence=" + this.confidence + "]";
        }
    }

    static class PhraseSemanticAnalysisPkg {
        private Optional<PhraseInfo> phrase;
        private List<Candidate> candidates;
        private List<ConceptInfo> concepts;

        PhraseSemanticAnalysisPkg(@Nonnull PhraseInfo phraze) {
            this.phrase = Optional.of(phraze);
            this.concepts = new ArrayList<ConceptInfo>();
            this.candidates = new ArrayList<Candidate>();
        }

        @Nonnull
        PhraseInfo getPhrase() {
            return this.phrase.orElse(new PhraseInfo());
        }

        @Nonnull
        List<Candidate> getCandidates() {
            return this.candidates;
        }

        @Nonnull
        List<ConceptInfo> getConcepts() {
            return this.concepts;
        }

        @Nonnull
        PhraseSemanticAnalysisPkg addConcept(ConceptInfo c) {
            this.concepts.add(c);
            return this;
        }

        @Nonnull
        PhraseSemanticAnalysisPkg addCandidate(@Nonnull Optional<Candidate> candidate) {
            candidate.ifPresent(c -> this.candidates.add((Candidate)c));
            return this;
        }
    }
}

