/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.reasoner;

import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.ontology.reasoner.DataHintEvaluator;
import com.ibm.smarts.ontology.reasoner.ExistentialRestrictionCollector;
import com.ibm.smarts.schema.ConceptInfo;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataHintReasoner {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataHintReasoner.class);
    private static final String APPLICATI_ONONTOLOGY_IRI = "http://www.ibm.com/ontologies/waca/application";
    private static final IRI HAS_DATA_HINT_PROPERTY_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/application#hasDataHint");

    private DataHintReasoner() {
    }

    public static float evaluateDataHintRestriction(OWLClass aClass, Map<IRI, List<ConceptInfo>> objectPropertyValues, Map<IRI, List<OWLLiteral>> dataPropertyValues, List<String> samples, OWLOntology ontology, OWLReasoner reasoner, RequestContext reqCtx) {
        ExistentialRestrictionCollector restrictionVisitor = new ExistentialRestrictionCollector(Collections.singleton(ontology), Collections.singletonList(HAS_DATA_HINT_PROPERTY_IRI), true);
        aClass.accept((OWLClassExpressionVisitor)restrictionVisitor);
        LOGGER.info("Evaluate dataHint for " + aClass.getIRI().getShortForm());
        return restrictionVisitor.getRestrictedProperties().stream().map(e -> Float.valueOf(DataHintReasoner.evaluateDataHintRestriction(e, objectPropertyValues, dataPropertyValues, samples, ontology, reasoner, reqCtx))).reduce(Float.valueOf(1.0f), (a, b) -> Float.valueOf(a.floatValue() * b.floatValue())).floatValue();
    }

    private static float evaluateDataHintRestriction(OWLObject dataHint, Map<IRI, List<ConceptInfo>> objectPropertyValues, Map<IRI, List<OWLLiteral>> dataPropertyValues, List<String> samples, OWLOntology ontology, OWLReasoner reasoner, RequestContext reqCtx) {
        float result = ((Float)dataHint.accept((OWLObjectVisitorEx)new DataHintEvaluator(ontology, reasoner, objectPropertyValues, dataPropertyValues, samples, reqCtx))).floatValue();
        LOGGER.info(String.format("%s = %s", Float.valueOf(result), dataHint.toString()));
        return result;
    }
}

