/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.reasoner;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLQuantifiedObjectRestriction;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.model.parameters.Navigation;
import org.semanticweb.owlapi.util.OWLClassExpressionVisitorAdapter;

public class ExistentialRestrictionCollector
extends OWLClassExpressionVisitorAdapter {
    private final Set<OWLClass> m_processedClasses = new HashSet<OWLClass>();
    private final Map<IRI, Set<OWLObject>> m_restrictedProperties;
    private final Set<OWLOntology> m_ontologies;
    private final List<IRI> m_properties;
    private boolean m_findFirst = false;

    public ExistentialRestrictionCollector(@Nonnull Set<OWLOntology> ontologies, @Nonnull List<IRI> properties, boolean findFirst) {
        this.m_properties = properties;
        this.m_ontologies = ontologies;
        this.m_restrictedProperties = new HashMap<IRI, Set<OWLObject>>();
        this.m_properties.forEach(p -> this.m_restrictedProperties.computeIfAbsent((IRI)p, k -> new HashSet()));
        this.m_findFirst = findFirst;
    }

    @Nonnull
    public Set<OWLObject> getRestrictedProperties() {
        return this.m_restrictedProperties.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Nonnull
    public Set<OWLObject> getRestrictedProperties(IRI property) {
        return this.m_restrictedProperties.get(property);
    }

    public void visit(OWLClass desc) {
        if (!this.m_processedClasses.contains(desc)) {
            this.m_processedClasses.add(desc);
            this.m_ontologies.forEach(ont -> {
                Stream<OWLSubClassOfAxiom> subClasses = ont.getAxioms(OWLSubClassOfAxiom.class, OWLClass.class, (OWLObject)desc, Imports.INCLUDED, Navigation.IN_SUB_POSITION).stream().filter(a -> a.getSubClass().equals(desc));
                Map classExprs = subClasses.map(OWLSubClassOfAxiom::getSuperClass).collect(Collectors.groupingBy(OWLClassExpression::isAnonymous, Collectors.toList()));
                if (classExprs.containsKey(true)) {
                    classExprs.get(true).stream().forEach(a -> a.accept((OWLClassExpressionVisitor)this));
                }
                if ((!this.m_findFirst || this.m_restrictedProperties.values().stream().anyMatch(Set::isEmpty)) && classExprs.containsKey(false)) {
                    classExprs.get(false).stream().forEach(a -> a.accept((OWLClassExpressionVisitor)this));
                }
            });
        }
    }

    public void visit(OWLObjectSomeValuesFrom desc) {
        this.collect((OWLQuantifiedObjectRestriction)desc);
    }

    public void visit(OWLObjectAllValuesFrom desc) {
        this.collect((OWLQuantifiedObjectRestriction)desc);
    }

    public void visit(OWLObjectHasValue ce) {
        this.collect(ce);
    }

    private void collect(OWLQuantifiedObjectRestriction desc) {
        this.m_properties.stream().filter(p -> p.equals((Object)desc.getProperty().asOWLObjectProperty().getIRI())).findAny().ifPresent(p -> {
            if (this.m_findFirst) {
                if (this.m_restrictedProperties.get(p).isEmpty()) {
                    this.m_restrictedProperties.get(p).add((OWLObject)desc.getFiller());
                }
            } else {
                this.m_restrictedProperties.get(p).add((OWLObject)desc.getFiller());
            }
        });
    }

    private void collect(OWLObjectHasValue desc) {
        this.m_properties.stream().filter(p -> p.equals((Object)desc.getProperty().asOWLObjectProperty().getIRI())).findAny().ifPresent(p -> {
            if (this.m_findFirst) {
                if (this.m_restrictedProperties.get(p).isEmpty()) {
                    this.m_restrictedProperties.get(p).add(desc.getFiller());
                }
            } else {
                this.m_restrictedProperties.get(p).add(desc.getFiller());
            }
        });
    }
}

