/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.util;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.internal.ontology.api.DomainOWLOntologyManager;
import com.ibm.smarts.internal.ontology.api.Ontology;
import com.ibm.smarts.ontology.classifier.ConceptClassificationCommon;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiDomainConceptExtractor
extends ConceptClassificationCommon {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiDomainConceptExtractor.class);

    public JSONObject extractConcepts(DomainOWLOntologyManager ontoManager) throws Exception {
        JSONObject root = new JSONObject();
        List domainOntologies = ontoManager.getOntologies();
        for (Ontology domainOntology : domainOntologies) {
            root.put((Object)domainOntology.getOntologyID(), (Object)this.extractConcepts((OWLOntology)domainOntology.getValue(), ontoManager.getReasoner(domainOntology)));
        }
        return root;
    }

    private JSONObject extractConcepts(OWLOntology domainOntology, OWLReasoner reasoner) throws Exception {
        JSONObject jRoot = new JSONObject();
        if (domainOntology != null) {
            Node topClass = reasoner.getTopClassNode();
            OWLClass root = (OWLClass)topClass.getRepresentativeElement();
            jRoot.put((Object)"name", (Object)root.toString());
            jRoot.put((Object)"IRI", (Object)root.getIRI().toString());
            jRoot.put((Object)"ontologyID", (Object)root.getIRI().getNamespace().substring(0, root.getIRI().getNamespace().length() - 1));
            jRoot.put((Object)"isVisible", (Object)this.isVisibleClass(root.getIRI(), false, domainOntology));
            Map<String, IRI> propertyMap = this.resolveVisibleProperties(domainOntology);
            this.handleSubClasses(jRoot, root, reasoner, domainOntology, propertyMap);
        }
        return jRoot;
    }

    Map<String, IRI> resolveVisibleProperties(OWLOntology ontology) {
        HashMap<String, IRI> propertyMap = new HashMap<String, IRI>();
        for (OWLObjectProperty o : ontology.getObjectPropertiesInSignature(Imports.INCLUDED)) {
            boolean isVisible = this.getBooleanAnnotationValue(false, ontology, VISIBLE_PROPERTY_IRI, (OWLAnnotationSubject)o.getIRI());
            if (!isVisible) continue;
            propertyMap.put(o.getIRI().getShortForm(), o.getIRI());
        }
        return propertyMap;
    }

    private void handleProperties(JSONObject obj, OWLClass c, OWLOntology domainOntology, Map<String, IRI> propertyMap) {
        Set<String> properties = propertyMap.keySet();
        JSONObject props = new JSONObject();
        for (String property : properties) {
            IRI iri = propertyMap.get(property);
            Set<OWLNamedIndividual> ind = this.getPropertyValues(c, domainOntology, iri);
            if (ind.isEmpty()) continue;
            String value = ind.iterator().next().getIRI().getShortForm();
            props.put((Object)property, (Object)value);
        }
        if (!props.isEmpty()) {
            obj.put((Object)"properties", (Object)props);
        }
    }

    private void handleSubClasses(JSONObject jParent, OWLClass c, OWLReasoner reasoner, OWLOntology owlOntology, Map<String, IRI> propertyMap) {
        this.handleProperties(jParent, c, owlOntology, propertyMap);
        Set classes = reasoner.getSubClasses((OWLClassExpression)c, true).getFlattened();
        if (!this.isEmpty(classes)) {
            JSONArray children = new JSONArray();
            jParent.put((Object)"children", (Object)children);
            for (OWLClass clazz : classes) {
                if (!c.isOWLThing() && !c.getIRI().getNamespace().equals(clazz.getIRI().getNamespace())) continue;
                JSONObject child = new JSONObject();
                String name = clazz.getIRI().getShortForm();
                child.put((Object)"name", (Object)name);
                child.put((Object)"IRI", (Object)clazz.getIRI().toString());
                child.put((Object)"ontologyID", (Object)clazz.getIRI().getNamespace().substring(0, clazz.getIRI().getNamespace().length() - 1));
                child.put((Object)"isVisible", (Object)this.isVisibleClass(clazz.getIRI(), true, owlOntology));
                children.add((Object)child);
                this.handleSubClasses(child, clazz, reasoner, owlOntology, propertyMap);
            }
        }
    }

    private boolean isEmpty(Set<OWLClass> classes) {
        OWLClass clazz;
        if (classes.isEmpty()) {
            return true;
        }
        return classes.size() == 1 && (clazz = classes.iterator().next()).isOWLNothing();
    }
}

