/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.messages;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.platform.commons.messages.ResourceBundleControl;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MessageUtil {
    private static final Pattern MESSAGE_PATTERN = Pattern.compile("(\\w+-\\w+-\\d+)\\s+(.*)");
    private static final Pattern aposRegex = Pattern.compile("(?<!('|\\{|\\}))'(?!('|\\{|\\}))");
    private static final MessageUtil utility = new MessageUtil();

    protected MessageUtil() {
    }

    protected static MessageUtil getInstance() {
        return utility;
    }

    public static String getMessage(Locale locale, IMessageKey.Param0 key) {
        if (key == null) {
            return null;
        }
        return MessageUtil.getInstance().getMessage(key, locale, new Object[0]);
    }

    public static String getMessage(Locale locale, IMessageKey.Param1 key, String arg1) {
        if (key == null) {
            return null;
        }
        return MessageUtil.getInstance().getMessage(key, locale, new Object[]{arg1});
    }

    public static String getMessage(Locale locale, IMessageKey.Param2 key, String arg1, String arg2) {
        if (key == null) {
            return null;
        }
        return MessageUtil.getInstance().getMessage(key, locale, new Object[]{arg1, arg2});
    }

    public static String getMessage(Locale locale, IMessageKey.Param3 key, String arg1, String arg2, String arg3) {
        if (key == null) {
            return null;
        }
        return MessageUtil.getInstance().getMessage(key, locale, new Object[]{arg1, arg2, arg3});
    }

    public static String getMessage(Locale locale, IMessageKey.Param4 key, String arg1, String arg2, String arg3, String arg4) {
        if (key == null) {
            return null;
        }
        return MessageUtil.getInstance().getMessage(key, locale, new Object[]{arg1, arg2, arg3, arg4});
    }

    public static String getMessage(Locale locale, IMessageKey.Param5 key, String arg1, String arg2, String arg3, String arg4, String arg5) {
        if (key == null) {
            return null;
        }
        return MessageUtil.getInstance().getMessage(key, locale, new Object[]{arg1, arg2, arg3, arg4, arg5});
    }

    public static String getMessage(Locale locale, IMessageKey.Param6 key, String arg1, String arg2, String arg3, String arg4, String arg5, String arg6) {
        if (key == null) {
            return null;
        }
        return MessageUtil.getInstance().getMessage(key, locale, new Object[]{arg1, arg2, arg3, arg4, arg5, arg6});
    }

    public static String getMessage(Locale locale, IMessageKey.Param7 key, String arg1, String arg2, String arg3, String arg4, String arg5, String arg6, String arg7) {
        if (key == null) {
            return null;
        }
        return MessageUtil.getInstance().getMessage(key, locale, new Object[]{arg1, arg2, arg3, arg4, arg5, arg6, arg7});
    }

    public static String getMessage(Locale locale, IMessageKey.Param8 key, String arg1, String arg2, String arg3, String arg4, String arg5, String arg6, String arg7, String arg8) {
        if (key == null) {
            return null;
        }
        return MessageUtil.getInstance().getMessage(key, locale, new Object[]{arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8});
    }

    public static String getMessage(Locale locale, IMessageKey.Param9 key, String arg1, String arg2, String arg3, String arg4, String arg5, String arg6, String arg7, String arg8, String arg9) {
        if (key == null) {
            return null;
        }
        return MessageUtil.getInstance().getMessage(key, locale, new Object[]{arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9});
    }

    public static String getMessage(Locale locale, IMessageKey.Param10 key, String arg1, String arg2, String arg3, String arg4, String arg5, String arg6, String arg7, String arg8, String arg9, String arg10) {
        if (key == null) {
            return null;
        }
        return key.buildMessage(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10).getLocalizedMessage(locale);
    }

    public static String[] splitErrorCodeAndMessage(String message) {
        Matcher matcher;
        String[] splitMessage = new String[]{"", message};
        if (message != null && (matcher = MESSAGE_PATTERN.matcher(message)).matches()) {
            splitMessage[0] = matcher.group(1);
            splitMessage[1] = matcher.group(2);
        }
        return splitMessage;
    }

    protected String getMessage(IMessageKey key, Locale locale, Object[] arguments) {
        String localizedMessage;
        if (key == null) {
            return null;
        }
        String strKey = key.toString();
        Locale loc = locale;
        if (loc == null) {
            loc = Locale.getDefault();
        }
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(key.getBundleFileName(), loc, this.getClass().getClassLoader(), new ResourceBundleControl());
            localizedMessage = bundle.getString(strKey);
        }
        catch (MissingResourceException m) {
            try {
                ResourceBundle bundle = ResourceBundle.getBundle(key.getBundleFileName(), Locale.ENGLISH, this.getClass().getClassLoader(), new ResourceBundleControl());
                localizedMessage = bundle.getString(strKey);
            }
            catch (MissingResourceException mre) {
                return mre.getMessage();
            }
        }
        if (this.escapeApostrophes()) {
            localizedMessage = this.escapeApostrophes(localizedMessage);
        }
        return MessageFormat.format(localizedMessage, arguments);
    }

    protected String escapeApostrophes(String localizedMessage) {
        Matcher match = this.getApostropheEscapeSequence().matcher(localizedMessage);
        return match.replaceAll("''");
    }

    protected Pattern getApostropheEscapeSequence() {
        return aposRegex;
    }

    protected boolean escapeApostrophes() {
        return false;
    }
}

