/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.schema;

import com.ibm.smarts.visualization.recommender.schema.charts.ChartElementFeatureMismatch;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class Binding {
    private final List<String> columns;
    private final String slot;
    private final String concept;
    private final Set<ChartElementFeatureMismatch> warnings;

    public Binding(List<String> columns, String slot) {
        this(columns, slot, "NONE");
    }

    public Binding(List<String> columns, String slot, String concept) {
        this(columns, slot, concept, Collections.emptySet());
    }

    public Binding(List<String> columns, String slot, String concept, Set<ChartElementFeatureMismatch> warnings) {
        this.columns = columns.stream().collect(Collectors.toList());
        this.slot = slot;
        this.concept = concept == null ? "NONE" : concept;
        this.warnings = warnings == null ? Collections.emptySet() : warnings.stream().collect(Collectors.toSet());
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public String getSlot() {
        return this.slot;
    }

    public String getConcept() {
        return this.concept;
    }

    public Set<ChartElementFeatureMismatch> getWarnings() {
        return this.warnings;
    }

    public long getScore() {
        long maxScore = ChartElementFeatureMismatch.getMaxMatchScore();
        return (long)this.columns.size() * (maxScore + this.warnings.stream().mapToLong(ChartElementFeatureMismatch::getWeight).sum());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columns == null ? 0 : this.columns.hashCode());
        result = 31 * result + (this.concept == null ? 0 : this.concept.hashCode());
        result = 31 * result + (this.slot == null ? 0 : this.slot.hashCode());
        result = 31 * result + (this.warnings == null ? 0 : this.warnings.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Binding other = (Binding)obj;
        if (this.columns == null ? other.columns != null : !this.columns.equals(other.columns)) {
            return false;
        }
        if (this.concept == null ? other.concept != null : !this.concept.equals(other.concept)) {
            return false;
        }
        if (this.slot == null ? other.slot != null : !this.slot.equals(other.slot)) {
            return false;
        }
        return !(this.warnings == null ? other.warnings != null : !this.warnings.equals(other.warnings));
    }

    public String toString() {
        return "Binding [columns=" + this.columns + ", slot=" + this.slot + ", concept=" + this.concept + ", warnings=" + this.warnings + ", score=" + this.getScore() + "]";
    }
}

