/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.rest.client.util;

import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.util.ToString;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.NewCookie;

public class HttpHeaderContext {
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private final Map<String, List<NewCookie>> setCookies = new HashMap<String, List<NewCookie>>();

    public String toString() {
        return ToString.with((Object)this).field("headers", this.headers).field("setCookies", this.setCookies).get();
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public Map<String, List<NewCookie>> getSetCookies() {
        return this.setCookies;
    }

    public void addHeader(String name, String value) {
        this.headers.computeIfAbsent(name, k -> new ArrayList()).add(value);
    }

    public void addHeaders(String name, List<String> values) {
        this.headers.computeIfAbsent(name, k -> values);
    }

    public static String toHeaderString(NewCookie cookie) {
        String ret = cookie.getName() + "=" + cookie.getValue();
        return ret;
    }

    public Collection<NewCookie> findCookies(String name) {
        if (this.setCookies.containsKey(name)) {
            return this.setCookies.get(name);
        }
        return new ArrayList<NewCookie>();
    }

    public void addFromSetCookies(Map<String, List<String>> headers) {
        for (String headerName : headers.keySet()) {
            if (!"Set-Cookie".equals(headerName)) continue;
            List<String> values = headers.get(headerName);
            for (String value : values) {
                NewCookie cookie = NewCookie.valueOf((String)value);
                this.setCookies.computeIfAbsent(cookie.getName(), k -> new ArrayList()).add(cookie);
            }
        }
    }

    public Map<String, List<String>> headersForUrl(String urlString) {
        URL url;
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>(this.headers);
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new InternalException((Throwable)e, "Could not parse URL " + ToString.valueString((Object)urlString), new Object[0]);
        }
        long nowMillis = System.currentTimeMillis();
        for (String name : this.setCookies.keySet()) {
            List<NewCookie> cookies = this.setCookies.get(name);
            NewCookie cookie = HttpHeaderContext.select(cookies, nowMillis, url);
            if (cookie == null) continue;
            String value = HttpHeaderContext.toHeaderString(cookie);
            ret.computeIfAbsent("Cookie", k -> new ArrayList()).add(value);
        }
        return ret;
    }

    public static NewCookie select(Collection<NewCookie> cookies, long nowMillis, URL url) {
        ArrayList<NewCookie> selected = new ArrayList<NewCookie>();
        for (NewCookie cookie : cookies) {
            if (!HttpHeaderContext.select(cookie, nowMillis, url)) continue;
            selected.add(cookie);
        }
        NewCookie ret = null;
        int longestPath = 0;
        for (NewCookie cookie : selected) {
            int pathLength = HttpHeaderContext.pathLength(cookie);
            if (ret == null) {
                ret = cookie;
                longestPath = pathLength;
                continue;
            }
            if (pathLength <= longestPath) continue;
            longestPath = pathLength;
            ret = cookie;
        }
        return ret;
    }

    public static int pathLength(NewCookie cookie) {
        String path = cookie.getPath();
        int ret = path == null ? 0 : path.length();
        return ret;
    }

    public static boolean select(NewCookie cookie, long nowMillis, URL url) {
        String path;
        String host;
        boolean ret = true;
        String domain = cookie.getDomain();
        if (domain != null && !(host = url.getHost()).endsWith(domain)) {
            ret = false;
        }
        if ((path = cookie.getPath()) != null) {
            path = HttpHeaderContext.slashPrefix(path);
            String urlPath = url.getPath();
            if (urlPath != null && !(urlPath = HttpHeaderContext.slashPrefix(urlPath)).startsWith(path)) {
                ret = false;
            }
        }
        return ret;
    }

    private static String slashPrefix(String s) {
        if (s.startsWith("/")) {
            return s;
        }
        return "/" + s;
    }
}

