/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.hashing;

import java.util.Iterator;
import java.util.List;
import org.semanticweb.elk.util.hashing.Hasher;

public class HashGenerator {
    private static int counter = 0;

    public static int generateNextHashCode() {
        int h = ++counter;
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    public static int combinedHashCode(Object ... objects) {
        int result = 0;
        for (Object obj : objects) {
            int h = obj.hashCode();
            result += h;
            result += h << 10;
            result ^= h >> 6;
        }
        result += result << 3;
        result ^= result >> 11;
        result += result << 15;
        return result;
    }

    public static int combinedHashCode(Iterable<?> objects) {
        int result = 0;
        for (Object obj : objects) {
            int h = obj.hashCode();
            result += h;
            result += h << 10;
            result ^= h >> 6;
        }
        result += result << 3;
        result ^= result >> 11;
        result += result << 15;
        return result;
    }

    public static int combineMultisetHash(boolean finalize, int ... hashes) {
        int hash = 0;
        for (int h : hashes) {
            hash += h;
        }
        if (finalize) {
            hash = HashGenerator.combineListHash(hash);
        }
        return hash;
    }

    public static <T> int combineMultisetHash(boolean finalize, Iterable<? extends T> hashObjects, Hasher<T> hasher) {
        return HashGenerator.combineMultisetHash(finalize, hashObjects.iterator(), hasher);
    }

    public static <T> int combineMultisetHash(boolean finalize, Iterator<? extends T> hashObjectIterator, Hasher<T> hasher) {
        int hash = 0;
        while (hashObjectIterator.hasNext()) {
            hash += hasher.hash(hashObjectIterator.next());
        }
        if (finalize) {
            hash = HashGenerator.combineListHash(hash);
        }
        return hash;
    }

    public static int combineListHash(int ... hashes) {
        int hash = 0;
        for (int h : hashes) {
            hash += h;
            hash += hash << 10;
            hash ^= hash >> 6;
        }
        hash += hash << 3;
        hash ^= hash >> 11;
        hash += hash << 15;
        return hash;
    }

    public static <T> int combineListHash(List<? extends T> hashObjects, Hasher<T> hasher) {
        return HashGenerator.combineListHash(hashObjects.iterator(), hasher);
    }

    public static <T> int combineListHash(Iterator<? extends T> hashObjectIterator, Hasher<T> hasher) {
        int hash = 0;
        while (hashObjectIterator.hasNext()) {
            hash += hasher.hash(hashObjectIterator.next());
            hash += hash << 10;
            hash ^= hash >> 6;
        }
        hash += hash << 3;
        hash ^= hash >> 11;
        hash += hash << 15;
        return hash;
    }
}

