/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.dds.core.function;

import com.ibm.smarts.common.mq.function.SmartsModuleFunctionResult;
import com.ibm.smarts.common.mq.message.SmartsModuleMessage;
import com.ibm.smarts.common.mq.progress.SmartsModuleProgressUtil;
import com.ibm.smarts.common.pipeline.SmartsTaskContext;
import com.ibm.smarts.common.provider.IDataProvider;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.mq.MessageProducerProvider;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.dds.core.function.DdsFunction;
import com.ibm.smarts.dds.core.tasks.PredictTaskImpl;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import java.util.HashMap;

public class PredictFunction
extends DdsFunction<SmartsModuleMessage> {
    PredictFunction(String taskId, IStoreProvider storeProvider, IDataProvider dataProvider) {
        super(taskId, storeProvider, SmartsModuleMessage.class, dataProvider);
    }

    public SmartsModuleFunctionResult doApply(RequestContext rc, MessageProducerProvider producerProvider, SmartsModuleMessage message) {
        String smartsId = message.getSmartsModuleId();
        String datasetId = message.getDatasetId();
        if (SmartsModuleProgressUtil.isCancelled((RequestContext)rc, (IStoreProvider)this.storeProvider, (String)smartsId)) {
            return new SmartsModuleFunctionResult();
        }
        SmartsTaskContext context = new SmartsTaskContext(smartsId, datasetId, null, rc, this.storeProvider);
        PredictTaskImpl predictTaskImpl = new PredictTaskImpl();
        try {
            predictTaskImpl.execute(context);
        }
        catch (InternalException ex) {
            return new SmartsModuleFunctionResult();
        }
        HashMap<String, SmartsModuleMessage> outgoingMessages = new HashMap<String, SmartsModuleMessage>();
        outgoingMessages.put("smartsmodule.fanout.column.predict", new SmartsModuleMessage(message.getSmartsModuleId(), message.getDatasetId(), message.getResourceURI()));
        return new SmartsModuleFunctionResult(outgoingMessages);
    }
}

