/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.dds.core.numerics;

import com.ibm.smarts.dds.core.numerics.Column;
import com.ibm.smarts.dds.core.numerics.bivariate.Bivariate;
import com.ibm.smarts.dds.core.numerics.bivariate.TwoWayStatsCumulation;
import com.ibm.smarts.dds.core.numerics.util.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BivariateStatistics {
    private static final Logger logger = LoggerFactory.getLogger(BivariateStatistics.class);
    private final Map<Pair<Column>, Bivariate> map;

    public BivariateStatistics(List<Column> columns) {
        List<Column> usefulColumns = columns.stream().filter(Column::useful).sorted().collect(Collectors.toList());
        int numUsefulCols = usefulColumns.size();
        if (logger.isDebugEnabled()) {
            long numNumeric = usefulColumns.stream().filter(Column::isNumeric).count();
            logger.debug("# Numeric columns: {}", (Object)numNumeric);
            logger.debug("# Nominal columns: {}", (Object)((long)numUsefulCols - numNumeric));
            if (numUsefulCols != columns.size()) {
                logger.debug("Ignoring {} columns that are flagged as not useful", (Object)(columns.size() - numUsefulCols));
            }
        }
        TwoWayStatsCumulation[][] cumulation = this.makeTwoWayStats(usefulColumns, columns.get(0).rowCount());
        this.map = new HashMap<Pair<Column>, Bivariate>();
        for (int i = 0; i < numUsefulCols; ++i) {
            for (int j = 0; j < i; ++j) {
                TwoWayStatsCumulation c = cumulation[i][j];
                Column x = usefulColumns.get(i);
                Column y = usefulColumns.get(j);
                this.map.put(new Pair<Column>(x, y), c.finish(x.isNumeric(), y.isNumeric()));
            }
        }
    }

    private void addRowToCumulation(int row, List<Column> usefulColumns, TwoWayStatsCumulation[][] cumulation) {
        int[] groups = usefulColumns.stream().mapToInt(x -> x.groupOf(row)).toArray();
        double[] values = usefulColumns.stream().mapToDouble(x -> x.standardized(row)).toArray();
        for (int i = 1; i < cumulation.length; ++i) {
            if (groups[i] == -1) continue;
            int yGroup = groups[i];
            double yVal = values[i];
            TwoWayStatsCumulation[] cumulations = cumulation[i];
            for (int j = 0; j < i; ++j) {
                if (groups[j] == -1) continue;
                cumulations[j].addValue(yGroup, groups[j], yVal, values[j]);
            }
        }
    }

    private TwoWayStatsCumulation[][] makeTwoWayStats(List<Column> usefulColumns, int rowCount) {
        int numUsefulColumns = usefulColumns.size();
        TwoWayStatsCumulation[][] cumulation = new TwoWayStatsCumulation[numUsefulColumns][];
        for (int i = 1; i < numUsefulColumns; ++i) {
            cumulation[i] = new TwoWayStatsCumulation[i];
            for (int j = 0; j < i; ++j) {
                cumulation[i][j] = new TwoWayStatsCumulation(usefulColumns.get(i).isNumeric(), usefulColumns.get(j).isNumeric(), usefulColumns.get(i).groupCount(), usefulColumns.get(j).groupCount());
            }
        }
        IntStream.range(0, rowCount).parallel().forEach(row -> this.addRowToCumulation(row, usefulColumns, cumulation));
        return cumulation;
    }

    public Bivariate get(Column a, Column b) {
        Bivariate result = this.map.get(new Pair<Column>(a, b));
        return result == null ? this.map.get(new Pair<Column>(b, a)) : result;
    }
}

