/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.dds.core.tasks;

import com.ibm.smarts.common.mq.SmartsModuleException;
import com.ibm.smarts.common.pipeline.SampleQueryContext;
import com.ibm.smarts.common.pipeline.SmartsTaskContext;
import com.ibm.smarts.common.provider.IDataProvider;
import com.ibm.smarts.common.provider.IDataProviderModuleInfo;
import com.ibm.smarts.common.provider.ISampleData;
import com.ibm.smarts.common.provider.IValueIterator;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.logging.PerformanceLogger;
import com.ibm.smarts.core.rest.client.util.JaxRs20Exceptions;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.dds.core.value.decor.ValueDecorationProvider;
import com.ibm.smarts.model.common.util.UniqueNameGenerator;
import com.ibm.smarts.model.datatype.DataType;
import com.ibm.smarts.model.value.Value;
import com.ibm.smarts.model.value.decor.ValueDecoration;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import com.ibm.smarts.store.api.provider.IInMemoryModuleStore;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class SamplesTaskImpl {
    public void execute(SmartsTaskContext taskContext) {
        ISampleData sample;
        String smartsId = taskContext.getSmartsModuleId();
        String datasetId = taskContext.getDatasetId();
        PerformanceLogger.get().info((Object)(smartsId + "." + datasetId));
        RequestContext rc = taskContext.getRequestContext();
        IStoreProvider storeProvider = taskContext.getStoreProvider();
        String taskId = "smarts.dds.samples";
        IDataProvider dataProvider = (IDataProvider)taskContext.getProperty("dataProvider");
        IDataProviderModuleInfo moduleInfo = dataProvider.getDataProviderModuleInfo(rc, smartsId);
        if (moduleInfo != null && !moduleInfo.isRetrieveSamplesEnabled(rc, smartsId)) {
            throw new InternalException("No moduleInfo found or samples not enabled", new Object[0]);
        }
        String qualifiedId = UniqueNameGenerator.appendUniqueName((String)UniqueNameGenerator.createSingleNamePart((String)smartsId), (String)datasetId);
        try {
            if (moduleInfo != null || taskContext.getProperty("SampleQueryContext") == null) {
                sample = dataProvider.getSampleData(rc, qualifiedId);
            } else {
                SmartsModule module = this.getModuleStore(storeProvider, rc).getSmartsModulePart(smartsId, datasetId);
                if (module.getDatasets().isEmpty()) {
                    throw new InternalException("Unable to locate Dataset {0} in SmartsModule {1}", new Object[]{datasetId, smartsId});
                }
                SampleQueryContext sampleQueryContext = (SampleQueryContext)taskContext.getProperty("SampleQueryContext");
                DatasetInfo dataset2 = (DatasetInfo)module.getDatasets().get(0);
                sample = dataProvider.getSampleData(rc, sampleQueryContext, dataset2);
            }
        }
        catch (JaxRs20Exceptions.ResponseProcessingException ex) {
            throw new InternalException((Throwable)ex, String.format("Failed to get samples for %s caused by: %s - HTTP Code: %s", qualifiedId, ex.getMessage(), ex.getResponse().getStatus()), new Object[0]);
        }
        catch (Exception ex) {
            throw new InternalException((Throwable)ex, String.format("Failed to get samples for %s caused by: %s", qualifiedId, ex.getMessage()), new Object[0]);
        }
        if (sample == null) {
            throw new SmartsModuleException(taskId, "no samples for " + smartsId + ", " + datasetId, new Object[0]);
        }
        this.getModuleStore(storeProvider, rc).apply(smartsId, datasetId, dataset -> {
            this.addSamples((DatasetInfo)dataset, sample);
            return dataset;
        });
        PerformanceLogger.get().info((Object)(smartsId + "." + datasetId));
    }

    public void addSamples(DatasetInfo dataset, ISampleData sample) {
        HashMap valueDecorationsMap = new HashMap();
        SmartsModuleUtil.getFlattenedColumns((BaseItemObject)dataset).forEach(column -> {
            String columnId = column.getId();
            ArrayList<String> samples = new ArrayList<String>();
            int queryItemIndex = sample.indexOfQueryItem(columnId);
            IValueIterator sampleIterator = sample.valueIterator(queryItemIndex);
            while (sampleIterator.hasNext()) {
                Value sampleValue = sampleIterator.next();
                samples.add(sampleValue.stringValue());
            }
            DataType dataType = column.getDataType();
            ArrayList<ValueDecoration> valueDecorations = new ArrayList<ValueDecoration>();
            if (queryItemIndex >= 0) {
                valueDecorations.addAll(sample.valueDecorations(queryItemIndex));
            }
            valueDecorations.addAll(ValueDecorationProvider.getValueDecorations(dataType, samples));
            valueDecorationsMap.put(columnId, valueDecorations);
            column.getValueDecorations().addAll((Collection)valueDecorationsMap.get(columnId));
            column.getSamples().addAll(samples);
        });
    }

    private IInMemoryModuleStore getModuleStore(IStoreProvider storeProvider, RequestContext rc) {
        return storeProvider.getModuleStore(rc);
    }
}

