/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlp.core.corenlp.analyzer;

import com.ibm.smarts.nlp.api.grammar.PartOfSpeech;
import com.ibm.smarts.nlp.api.grammar.Significance;
import com.ibm.smarts.nlp.api.grammar.SimplePartOfSpeech;
import com.ibm.smarts.nlp.core.corenlp.analyzer.PreProcessor;
import com.ibm.smarts.nlp.core.corenlp.domain.CoreNLPResults;
import com.ibm.smarts.nlp.core.corenlp.domain.CoreNLPToken;
import com.ibm.smarts.schema.NLPMentionsEntity;
import com.ibm.smarts.schema.PhraseInfo;
import com.ibm.smarts.schema.TokenInfo;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.LabeledScoredTreeNode;
import edu.stanford.nlp.trees.Tree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public abstract class PostProcessor {
    private static final Pattern CURRENCY_SYMBOL_PATTERN = Pattern.compile("\\p{Sc}");
    private static final Pattern NORMALIZED_CURRENCY_SYMBOL_PATTERN = Pattern.compile("([^\\s]+)?(\\s)*(#|\\p{Sc})");
    private static final String CURRENCY_SYMBOL_YEN = "\u00a5";
    private static final String CURRENCY_SYMBOL_WON = "\u20a9";
    private static final String CURRENCY_SYMBOL_REAL = "R$";
    private static final List<String> SPEICAL_CURRENCY_SYMBOLS = Arrays.asList("\u00a5", "\u20a9", "R$");
    private static final String SYMBOL_POUND = "#";
    public static final String NP = "NP";
    public static final String PP = "PP";
    public static final List<String> POS_NON_HEAD_NOUN = Arrays.asList(PartOfSpeech.NN.name(), PartOfSpeech.NNS.name(), PartOfSpeech.NNP.name(), PartOfSpeech.NNPS.name(), PartOfSpeech.JJ.name(), PartOfSpeech.VBG.name());
    public static final List<String> POS_NON_HEAD_NOUN_SIGULAR = Arrays.asList(PartOfSpeech.NN.name(), PartOfSpeech.NNP.name(), PartOfSpeech.JJ.name(), PartOfSpeech.VBG.name());
    public static final List<String> POS_NOUN = Arrays.asList(PartOfSpeech.NN.name(), PartOfSpeech.NNS.name(), PartOfSpeech.NNP.name(), PartOfSpeech.NNPS.name());
    public static final List<String> SPECIAL_UPPER_CASES = Arrays.asList(PreProcessor.SPECIAL_CHARS_UPPER_CASE);
    public static final String ADJP = "ADJP";
    public static final String QP = "QP";
    public static final List<String> POS_TO_CONTINUE = Arrays.asList(PartOfSpeech.CD.name());
    public static final List<String> NP_MODIFIERS = Arrays.asList("ADJP", "QP");
    protected Locale locale;

    static void traverse(Tree root, List<Tree> result) {
        if (root == null) {
            return;
        }
        for (Tree tree : root.getChildrenAsList()) {
            if (PostProcessor.continueTraverse(tree = PostProcessor.alterTree(tree))) {
                PostProcessor.traverse(tree, result);
                continue;
            }
            if (PostProcessor.nounPhraseWithModifiers(tree)) {
                PostProcessor.processNounPhraseWithModifiers(result, tree);
                continue;
            }
            if (PostProcessor.nounPhraseWithCC(tree)) {
                PostProcessor.processNounPhrasePreTerminalsWithCC(result, tree);
                continue;
            }
            result.add(tree);
        }
    }

    private static void processNounPhrasePreTerminalsWithCC(List<Tree> result, Tree tree) {
        List children = tree.getChildrenAsList();
        int prePT = 0;
        for (int i = 0; i < children.size() - 1; ++i) {
            if (!PartOfSpeech.CC.name().equals(((Tree)children.get(i)).label().value())) continue;
            result.add(PostProcessor.makeNewNPTree(tree.label(), children.subList(prePT, i)));
            result.add((Tree)children.get(i));
            prePT = ++i;
        }
        result.add(PostProcessor.makeNewNPTree(tree.label(), children.subList(prePT, children.size())));
    }

    private static Tree makeNewNPTree(Label label, List<Tree> subList) {
        LabeledScoredTreeNode tree = new LabeledScoredTreeNode();
        tree.setLabel(label);
        tree.setChildren(subList);
        return tree;
    }

    private static void processNounPhraseWithModifiers(List<Tree> result, Tree tree) {
        ArrayList modifiers = new ArrayList(tree.getChildrenAsList().size());
        List children = tree.getChildrenAsList();
        children.forEach(child -> {
            if (NP_MODIFIERS.contains(child.label().value())) {
                PostProcessor.traverse(child, result);
                modifiers.add(child);
            }
        });
        children.removeAll(modifiers);
        LabeledScoredTreeNode subtree = new LabeledScoredTreeNode();
        subtree.setLabel(tree.label());
        subtree.setChildren(children);
        result.add((Tree)subtree);
    }

    private static boolean continueTraverse(Tree tree) {
        if (tree.isPrePreTerminal() && NP.equals(tree.label().value()) && PostProcessor.canStop(tree.getChildrenAsList())) {
            return false;
        }
        if (PP.equals(tree.label().value())) {
            return true;
        }
        if (PostProcessor.allChildrenNounPreTerminals(tree.getChildrenAsList())) {
            return false;
        }
        if (PostProcessor.nounPhraseWithModifiers(tree)) {
            return false;
        }
        return !tree.isPreTerminal();
    }

    private static Tree alterTree(Tree tree) {
        int index = PostProcessor.findSillyParsing(tree.getChildrenAsList());
        if (index > 0) {
            LabeledScoredTreeNode alteredTree = new LabeledScoredTreeNode();
            alteredTree.setLabel(tree.label());
            alteredTree.setScore(tree.score());
            List children = tree.getChildrenAsList();
            Tree two = (Tree)children.remove(index);
            Tree one = (Tree)children.remove(index - 1);
            LabeledScoredTreeNode newNode = new LabeledScoredTreeNode();
            newNode.setLabel(two.label());
            newNode.addChild(one);
            two.getChildrenAsList().forEach(arg_0 -> PostProcessor.lambda$alterTree$1((Tree)newNode, arg_0));
            children.add(index - 1, newNode);
            alteredTree.setChildren(children);
            return alteredTree;
        }
        return tree;
    }

    private static int findSillyParsing(List<Tree> children) {
        for (int i = 1; i < children.size(); ++i) {
            if (!PartOfSpeech.VBG.name().equals(children.get(i - 1).label().value()) || !NP.equals(children.get(i).label().value()) || !children.get(i).isPrePreTerminal()) continue;
            return i;
        }
        return -1;
    }

    private static boolean nounPhraseWithCC(Tree tree) {
        return tree.isPrePreTerminal() && NP.equals(tree.label().value()) && tree.getChildrenAsList().stream().anyMatch(c -> PartOfSpeech.CC.name().equals(c.label().value()));
    }

    private static boolean nounPhraseWithModifiers(Tree tree) {
        return NP.equals(tree.label().value()) && PostProcessor.isModifiedNP(tree.getChildrenAsList());
    }

    private static boolean isModifiedNP(List<Tree> children) {
        return null != children && children.stream().anyMatch(c -> NP_MODIFIERS.contains(c.label().value())) && children.stream().allMatch(c -> NP_MODIFIERS.contains(c.label().value()) || POS_NOUN.contains(c.label().value()) || PartOfSpeech.VBG.name().equals(c.label().value()));
    }

    private static boolean allChildrenNounPreTerminals(List<Tree> children) {
        return null != children && children.stream().allMatch(c -> PostProcessor.childNounPreTerminals(c));
    }

    public static boolean childNounPreTerminals(Tree tree) {
        return (tree.isPrePreTerminal() || tree.isPreTerminal()) && tree.getChildrenAsList().stream().allMatch(c -> POS_NOUN.contains(c.label().value()));
    }

    static boolean canStop(List<Tree> children) {
        return null != children && children.stream().allMatch(c -> !POS_TO_CONTINUE.contains(c.label().value()));
    }

    static boolean isStopWord(TokenInfo token) {
        return token.getPOS().equals(SimplePartOfSpeech.other.name()) || token.getPOSlocal().equals(PartOfSpeech.CD.name());
    }

    public Locale getLocale() {
        return this.locale;
    }

    public abstract void adjustHead(List<TokenInfo> var1);

    public void adjustCurrencyTokens(List<TokenInfo> tokens, String phrase) {
        Matcher currencyMatcher = CURRENCY_SYMBOL_PATTERN.matcher(phrase);
        while (currencyMatcher.find()) {
            for (int i = 0; i < tokens.size(); ++i) {
                TokenInfo token = tokens.get(i);
                if (SPEICAL_CURRENCY_SYMBOLS.contains(token.getText())) {
                    this.adjustSignificanePOS(tokens, token);
                    if (!CURRENCY_SYMBOL_REAL.equals(token.getText())) continue;
                    token.setLemma(token.getText());
                    continue;
                }
                if (token.getCharOffsetBegin() != currencyMatcher.start() || token.getCharOffsetEnd() != currencyMatcher.end()) continue;
                this.adjustSignificanePOS(tokens, token);
                token.setText(currencyMatcher.group());
                token.setLemma(currencyMatcher.group());
            }
        }
    }

    private void adjustSignificanePOS(List<TokenInfo> tokens, TokenInfo token) {
        token.setPOS(SimplePartOfSpeech.other.name());
        token.setPOSlocal(PartOfSpeech.SYM.name());
        if (tokens.size() > 1) {
            token.setSignificance(Significance.MEDIUM);
        }
    }

    public void adjustTokensOffsets(String text, List<CoreNLPToken> tokens) {
        for (int i = 1; i < tokens.size(); ++i) {
            CoreNLPToken token = tokens.get(i);
            String tokenText = token.getText();
            CoreNLPToken lastToken = tokens.get(i - 1);
            int lastTokenEndIndex = lastToken.getCharOffsetEnd();
            if (this.isCurrency(tokenText) || this.isPoundSign(tokenText)) {
                String subText = text.toLowerCase().substring(lastTokenEndIndex);
                Matcher matcher = NORMALIZED_CURRENCY_SYMBOL_PATTERN.matcher(subText);
                if (!matcher.find()) continue;
                token.setCharOffsetBegin(lastTokenEndIndex + matcher.end() - 1);
                token.setCharOffsetEnd(token.getCharOffsetBegin() + tokenText.length());
                continue;
            }
            token.setCharOffsetBegin(text.toLowerCase().indexOf(tokenText.toLowerCase(), lastTokenEndIndex));
            token.setCharOffsetEnd(token.getCharOffsetBegin() + tokenText.length());
        }
    }

    public TokenInfo convertPartOfSpeech(TokenInfo resultToken) {
        PartOfSpeech partOfSpeech = PartOfSpeech.getPOS((String)resultToken.getPOSlocal());
        resultToken.setPOSlocal(partOfSpeech.toString());
        SimplePartOfSpeech simplePOS = partOfSpeech.getSimplePartOfSpeech();
        int significance = simplePOS == SimplePartOfSpeech.noun || simplePOS == SimplePartOfSpeech.verb || simplePOS == SimplePartOfSpeech.adjective ? Significance.MEDIUM : (simplePOS == SimplePartOfSpeech.punctuation ? Significance.TRIVAL : Significance.LOW);
        resultToken.setPOS(simplePOS.name());
        resultToken.setSignificance(significance);
        return resultToken;
    }

    private boolean isCurrency(String token) {
        return token.length() == 1 && Character.getType(token.charAt(0)) == 26;
    }

    private boolean isPoundSign(String token) {
        return token.length() == 1 && token.equals(SYMBOL_POUND);
    }

    public boolean shouldBeHead(TokenInfo headToken) {
        return headToken.getSignificance() >= Significance.MEDIUM && !headToken.getPOS().equals(SimplePartOfSpeech.other.name()) || headToken.getPOSlocal().equals(SimplePartOfSpeech.punctuation.name());
    }

    public List<PhraseInfo> convertTreeToPhrases(HeadFinder hf, Tree root, Map<Tree, TokenInfo> leafToTokenMap, List<TokenInfo> tokenList) {
        LinkedList<PhraseInfo> phrases = new LinkedList<PhraseInfo>();
        ArrayList<Tree> result = new ArrayList<Tree>();
        PostProcessor.traverse(root, result);
        int cursor = 0;
        for (Tree tree : result) {
            Tree head = tree.headTerminal(hf);
            TokenInfo headToken = leafToTokenMap.get(head);
            ArrayList<TokenInfo> tokens = new ArrayList<TokenInfo>();
            StringBuilder sb = new StringBuilder();
            List leaves = tree.getLeaves();
            block1: for (int i = 0; i < leaves.size(); ++i) {
                TokenInfo tmpToken = leafToTokenMap.get(leaves.get(i));
                if (tmpToken == null) continue;
                boolean isHeadToken = headToken == null ? false : tmpToken.getText().equals(headToken.getText());
                for (int j = cursor; j < tokenList.size(); ++j) {
                    if (!tmpToken.getText().equals(tokenList.get(j).getText())) continue;
                    TokenInfo token = tokenList.get(j);
                    if (isHeadToken && this.shouldBeHead(token)) {
                        token.setSignificance(Significance.IMPORTANT);
                    }
                    if (PostProcessor.isStopWord(token)) {
                        token.setSignificance(Significance.LOW);
                    }
                    tokens.add(token);
                    sb.append(token.getText() + " ");
                    cursor = j + 1;
                    continue block1;
                }
            }
            this.adjustHead(tokens);
            PhraseInfo phrase = new PhraseInfo();
            phrase.setText(sb.toString().trim());
            phrase.getTokens().addAll(tokens);
            phrases.add(phrase);
        }
        return phrases;
    }

    public List<PhraseInfo> assembleEntities(CoreNLPResults results, List<PhraseInfo> phrases, int size) {
        HashMap<Integer, PhraseInfo> indexPhraseMap = new HashMap<Integer, PhraseInfo>(size);
        int index = 0;
        for (PhraseInfo phrase : phrases) {
            int i = 0;
            while (i < phrase.getTokens().size()) {
                indexPhraseMap.put(index, phrase);
                ++i;
                ++index;
            }
        }
        List<NLPMentionsEntity> entites = results.getEntities();
        boolean reorder = false;
        for (NLPMentionsEntity ne : entites) {
            if (!ne.getType().equals("DATE")) continue;
            ArrayList<PhraseInfo> pis = new ArrayList<PhraseInfo>(ne.getTokenEnd() - ne.getTokenBegin());
            for (int i = ne.getTokenBegin(); i < ne.getTokenEnd(); ++i) {
                pis.add((PhraseInfo)indexPhraseMap.get(i));
            }
            if (pis.isEmpty()) continue;
            PhraseInfo pi = pis.size() > 1 ? this.mergePhrases(pis, ne.getText()) : (PhraseInfo)pis.get(0);
            pi.getEntities().add(ne);
            phrases.removeAll(pis);
            phrases.add(pi);
            reorder = true;
        }
        if (reorder) {
            return phrases.stream().filter(p -> !p.getTokens().isEmpty()).sorted((p1, p2) -> Integer.compare(((TokenInfo)p1.getTokens().get(p1.getTokens().size() - 1)).getCharOffsetEnd(), ((TokenInfo)p2.getTokens().get(0)).getCharOffsetBegin())).collect(Collectors.toList());
        }
        return phrases;
    }

    private PhraseInfo mergePhrases(List<PhraseInfo> pis, String text) {
        PhraseInfo pi = pis.get(0);
        pi.setText(text);
        for (int i = 1; i < pis.size(); ++i) {
            pi.getTokens().addAll(pis.get(i).getTokens());
        }
        return pi;
    }

    private static /* synthetic */ void lambda$alterTree$1(Tree newNode, Tree t) {
        newNode.addChild(t);
    }
}

