/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlp.core.corenlp.analyzer;

import com.ibm.smarts.nlp.api.grammar.PartOfSpeech;
import com.ibm.smarts.nlp.api.grammar.Significance;
import com.ibm.smarts.nlp.api.grammar.SimplePartOfSpeech;
import com.ibm.smarts.nlp.core.corenlp.analyzer.PostProcessor;
import com.ibm.smarts.schema.TokenInfo;
import java.util.List;
import java.util.Locale;

public class PostProcessorEN
extends PostProcessor {
    public static final String SPACE = " ";
    public static final String ING = "ing";
    public static final String BY = "by";

    public PostProcessorEN() {
        this.locale = Locale.ENGLISH;
    }

    @Override
    public void adjustHead(List<TokenInfo> tokens) {
        TokenInfo currentHead = null;
        TokenInfo newHead = null;
        for (int i = 0; i < tokens.size(); ++i) {
            if (tokens.get(i).getSignificance() == Significance.IMPORTANT) {
                currentHead = tokens.get(i);
            }
            if (tokens.get(i).getText().toLowerCase().endsWith(ING)) {
                PostProcessorEN.adjustHeadSignificanceForVerb(tokens, tokens.get(i).getPOS());
                continue;
            }
            if (tokens.get(i).getLemma().equals(BY)) {
                for (int j = i; j < tokens.size(); ++j) {
                    if (tokens.get(j).getSignificance() != Significance.MEDIUM || !tokens.get(j).getPOSlocal().equals(PartOfSpeech.NN.toString())) continue;
                    newHead = tokens.get(j);
                }
                if (newHead == null || currentHead == null) continue;
                newHead.setSignificance(Significance.IMPORTANT);
                currentHead.setSignificance(Significance.MEDIUM);
                continue;
            }
            if (tokens.get(i).getPOSlocal().equals(PartOfSpeech.NNS.toString()) && tokens.get(i).getSignificance() == Significance.MEDIUM) {
                if (i + 2 >= tokens.size() || !tokens.get(i + 1).getPOSlocal().equals(PartOfSpeech.TO.toString()) || !tokens.get(i + 2).getPOSlocal().equals(PartOfSpeech.VB.toString()) || tokens.get(i + 2).getSignificance() != Significance.IMPORTANT) continue;
                tokens.get(i).setSignificance(Significance.IMPORTANT);
                tokens.get(i + 2).setSignificance(Significance.MEDIUM);
                continue;
            }
            if (tokens.get(i).getPOSlocal().equals(PartOfSpeech.JJ.toString())) {
                if (i + 1 >= tokens.size() || !POS_NON_HEAD_NOUN_SIGULAR.contains(tokens.get(i + 1).getPOSlocal())) continue;
                tokens.get(i).setSignificance(Significance.MEDIUM);
                tokens.get(i + 1).setSignificance(Significance.IMPORTANT);
                if (i + 2 >= tokens.size() || !POS_NOUN.contains(tokens.get(i + 2).getPOSlocal())) continue;
                tokens.get(i + 2).setSignificance(Significance.IMPORTANT);
                tokens.get(i + 1).setSignificance(Significance.MEDIUM);
                continue;
            }
            if (!POS_NOUN.contains(tokens.get(i).getPOSlocal()) || i + 2 >= tokens.size() || !tokens.get(i + 1).getPOSlocal().equals(PartOfSpeech.VB.toString()) || !POS_NOUN.contains(tokens.get(i + 2).getPOSlocal())) continue;
            tokens.get(i).setSignificance(Significance.MEDIUM);
            tokens.get(i + 1).setSignificance(Significance.MEDIUM);
            tokens.get(i + 2).setSignificance(Significance.MEDIUM);
        }
        this.adjustHeadsForAllNouns(tokens);
    }

    private void adjustHeadsForAllNouns(List<TokenInfo> tokens) {
        if (tokens.size() > 1 && POS_NOUN.contains(tokens.get(0).getPOSlocal())) {
            int j;
            boolean allNouns = true;
            for (j = 1; j < tokens.size(); ++j) {
                if (POS_NOUN.contains(tokens.get(j).getPOSlocal())) continue;
                allNouns = false;
                break;
            }
            if (allNouns) {
                tokens.get(j - 1).setSignificance(Significance.IMPORTANT);
                for (int i = 0; i < j - 1; ++i) {
                    tokens.get(i).setSignificance(Significance.MEDIUM);
                }
            }
        }
    }

    public static void adjustHeadSignificanceForVerb(List<TokenInfo> tokens, String pos) {
        block5: {
            TokenInfo currentHead;
            block4: {
                boolean foundRightHead = false;
                currentHead = null;
                TokenInfo newHead = null;
                if (!pos.equals(SimplePartOfSpeech.noun.name())) break block4;
                for (int i = 0; i < tokens.size(); ++i) {
                    if ((tokens.get(i).getSignificance() == Significance.MEDIUM || tokens.get(i).getSignificance() == Significance.IMPORTANT) && currentHead == null) {
                        currentHead = tokens.get(i);
                        if (!PostProcessorEN.posForNounCheck(tokens, i)) continue;
                        foundRightHead = true;
                        continue;
                    }
                    if (tokens.get(i).getSignificance() != Significance.MEDIUM || !tokens.get(i).getPOS().equals(SimplePartOfSpeech.noun.name())) continue;
                    newHead = tokens.get(i);
                }
                if (!foundRightHead || newHead == null) break block5;
                newHead.setSignificance(Significance.IMPORTANT);
                if (currentHead == null) break block5;
                currentHead.setSignificance(Significance.MEDIUM);
                break block5;
            }
            if (pos.equals(SimplePartOfSpeech.verb.name())) {
                for (int i = 0; i < tokens.size(); ++i) {
                    if (tokens.get(i).getSignificance() != Significance.IMPORTANT) continue;
                    currentHead = tokens.get(i);
                    if (!PostProcessorEN.POSforVerbCheck(tokens, i)) continue;
                    currentHead.setSignificance(Significance.MEDIUM);
                }
            }
        }
    }

    private static boolean POSforVerbCheck(List<TokenInfo> tokens, int i) {
        if (tokens.size() == i + 1) {
            return false;
        }
        return tokens.get(i).getPOS().equals(SimplePartOfSpeech.verb.name()) && tokens.get(i).getText().toLowerCase().endsWith(ING);
    }

    private static boolean posForNounCheck(List<TokenInfo> tokens, int i) {
        if (tokens.size() == i + 1) {
            return false;
        }
        return tokens.get(i).getPOS().equals(SimplePartOfSpeech.noun.name()) && tokens.get(i).getText().toLowerCase().endsWith(ING) && tokens.get(i + 1).getPOS().equals(SimplePartOfSpeech.noun.name());
    }
}

