/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlp.core.corenlp.domain;

import com.ibm.smarts.nlp.api.grammar.Significance;
import com.ibm.smarts.nlp.api.utility.DomainObjectAssembler;
import com.ibm.smarts.nlp.core.corenlp.analyzer.CoreNLPResourceManager;
import com.ibm.smarts.nlp.core.corenlp.analyzer.PostProcessor;
import com.ibm.smarts.nlp.core.corenlp.domain.CoreNLPResults;
import com.ibm.smarts.nlp.core.corenlp.domain.CoreNLPToken;
import com.ibm.smarts.schema.NLPDependency;
import com.ibm.smarts.schema.NLPMentionsEntity;
import com.ibm.smarts.schema.PhraseInfo;
import com.ibm.smarts.schema.SenseInfo;
import com.ibm.smarts.schema.TokenInfo;
import edu.stanford.nlp.trees.Tree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CoreNLPAssembler
implements DomainObjectAssembler<CoreNLPResults> {
    PostProcessor postProcessor;

    public CoreNLPAssembler(Locale locale) {
        this.postProcessor = CoreNLPResourceManager.getPostProcessor(locale);
    }

    public List<TokenInfo> assembleTokenInfo(CoreNLPResults results, Map<String, List<SenseInfo>> senseInfoMap) {
        ArrayList<TokenInfo> tokens = new ArrayList<TokenInfo>();
        Tree parseTree = results.getParseTree();
        List leaves = parseTree.getLeaves();
        Tree head = results.getHead();
        int i = 0;
        Map<Integer, List<NLPDependency>> dependencyMap = results.getDependencies();
        HashMap<Integer, TokenInfo> tokenInfoMap = new HashMap<Integer, TokenInfo>();
        for (CoreNLPToken coreNLPToken : results.getTokens()) {
            TokenInfo resultToken = new TokenInfo();
            resultToken.setPositionInPhrase(coreNLPToken.getIndex());
            resultToken.setCharOffsetBegin(coreNLPToken.getCharOffsetBegin());
            resultToken.setCharOffsetEnd(coreNLPToken.getCharOffsetEnd());
            resultToken.setText(this.toLowCase(coreNLPToken.getText()));
            resultToken.setPOSlocal(coreNLPToken.getPos());
            resultToken = this.postProcessor.convertPartOfSpeech(resultToken);
            resultToken.setLemma(StringUtils.isBlank((CharSequence)coreNLPToken.getLemma()) ? coreNLPToken.getText() : this.toLowCase(coreNLPToken.getLemma()));
            if (((Tree)leaves.get(i)).equals((Object)head)) {
                resultToken.setSignificance(Significance.IMPORTANT);
            }
            tokenInfoMap.put(new Integer(resultToken.getPositionInPhrase()), resultToken);
            ++i;
            tokens.add(resultToken);
        }
        this.postProcessor.adjustCurrencyTokens(tokens, results.getText());
        this.postProcessor.adjustHead(tokens);
        this.setTokenDependecies(tokens, dependencyMap, tokenInfoMap);
        return tokens;
    }

    private String toLowCase(String txt) {
        if (PostProcessor.SPECIAL_UPPER_CASES.contains(txt)) {
            return txt;
        }
        return txt.toLowerCase(this.postProcessor.getLocale());
    }

    private void setTokenDependecies(List<TokenInfo> tokens, Map<Integer, List<NLPDependency>> dependencyMap, Map<Integer, TokenInfo> tokenInfoMap) {
        for (TokenInfo tokenInfo : tokens) {
            Integer key = new Integer(tokenInfo.getPositionInPhrase());
            if (dependencyMap == null) continue;
            List<NLPDependency> dependencies = dependencyMap.get(key);
            if (dependencies != null) {
                for (NLPDependency nlpDependency : dependencies) {
                    nlpDependency.getGovernor().setTokenInfo(tokenInfo);
                    Integer dependentKey = new Integer(nlpDependency.getDependent().getIndex());
                    TokenInfo dependentToken = tokenInfoMap.get(dependentKey);
                    nlpDependency.getDependent().setTokenInfo(dependentToken);
                }
            }
            if (dependencyMap.get(key) == null) continue;
            tokenInfo.getDependencies().addAll((Collection)dependencyMap.get(key));
        }
    }

    public PhraseInfo assemblePhraseInfo(CoreNLPResults results, Map<String, List<SenseInfo>> senseInfoMap) {
        List<TokenInfo> tokenInfoCollection = this.assembleTokenInfo(results, senseInfoMap);
        PhraseInfo phraseInfo = new PhraseInfo();
        phraseInfo.setText(results.getText());
        ArrayList<TokenInfo> collectionToken = new ArrayList<TokenInfo>(tokenInfoCollection);
        phraseInfo.getTokens().addAll(collectionToken);
        ArrayList<NLPMentionsEntity> collectionEntity = new ArrayList<NLPMentionsEntity>(results.getEntities());
        phraseInfo.getEntities().addAll(collectionEntity);
        return phraseInfo;
    }

    public PhraseInfo assemblePhraseInfo(CoreNLPResults t) {
        return this.assemblePhraseInfo(t, new HashMap<String, List<SenseInfo>>());
    }
}

