/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlp.core.function;

import com.ibm.smarts.common.mq.SmartsModuleMessageGroup;
import com.ibm.smarts.common.mq.SmartsModuleTask;
import com.ibm.smarts.common.mq.function.SmartsModuleFunction;
import com.ibm.smarts.common.mq.function.SmartsModuleTasks;
import com.ibm.smarts.core.mq.MessageQueueingSystem;
import com.ibm.smarts.nlp.api.SmartNLP;
import com.ibm.smarts.nlp.core.function.TokenizeColumnsFunction;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import java.util.Arrays;
import java.util.List;

public class NlpSmartsModuleTasks
extends SmartsModuleTasks {
    private static final String NLP_TASK_ID = "smarts.nlp";
    public static final String COLUMN_TOKEN_TASK_ID = "smarts.nlp.tokenizeColumns";
    public static final String COLUMN_TOKEN_TASK_NAME = "Tokenize Columns";
    public static final String COLUMN_TOKEN_DESCRIPTION = "Adds tokenized columns to the SmartsModule.";
    public static final String[] ALL_TASKS_FOR_REGISTRATION = new String[]{"smarts.nlp.tokenizeColumns"};
    private final SmartNLP nlp;

    public NlpSmartsModuleTasks(IStoreProvider storeProvider, MessageQueueingSystem messageSystem, SmartNLP nlp) {
        super(storeProvider, messageSystem);
        this.nlp = nlp;
    }

    public void configure() {
        super.configure(new Runnable(){

            @Override
            public void run() {
                List unregisteredTasks = SmartsModuleMessageGroup.findUnregisteredTasks((IStoreProvider)NlpSmartsModuleTasks.this.storeProvider, (String[])ALL_TASKS_FOR_REGISTRATION);
                if (!unregisteredTasks.isEmpty()) {
                    SmartsModuleTask tokenizeTask = new SmartsModuleTask(false, NlpSmartsModuleTasks.COLUMN_TOKEN_TASK_ID, NlpSmartsModuleTasks.COLUMN_TOKEN_TASK_NAME, NlpSmartsModuleTasks.COLUMN_TOKEN_DESCRIPTION, SmartsModuleTask.Scope.DATASET, Arrays.asList("smartsmodule.fanout.initpublish"), new String[]{"smartsmodule.fanout.column.token"});
                    NlpSmartsModuleTasks.this.messageGroup.register(tokenizeTask, (SmartsModuleFunction)new TokenizeColumnsFunction(NlpSmartsModuleTasks.COLUMN_TOKEN_TASK_ID, NlpSmartsModuleTasks.this.storeProvider, NlpSmartsModuleTasks.this.nlp));
                }
            }
        });
    }
}

