/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlp.core.utility;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class CharsUtils {
    private static final int DEL = 127;
    private static final int THREE_FORTH = 190;
    private static final int CANADIAN_ABORIGINAL_LOW = 5120;
    private static final int CANADIAN_ABORIGINAL_HIGH = 5788;
    private static final int KHMER_LOW = 6016;
    private static final int KHMER_HIGH = 6479;
    private static final int HALFWIDE_LOW = 65280;
    private static final int HALFWIDE_HIGH = 100351;
    private static final int SIMBOLS1_LOW = 8160;
    private static final int SIMBOLS1_HIGH = 10495;
    private static final int EXCEPTIONS_LOW = 8352;
    private static final int EXCEPTION_HIGH = 8383;
    private static final int SIMBOLS2_LOW = 11776;
    private static final int SIMBOLS2_HIGH = 11849;
    private static final int HEXAGRAM_LOW = 19904;
    private static final int HEXAGRAM_HIGH = 19967;
    private static final int HIEROG_LOW = 55296;
    private static final int HIEROG_HIGH = 63743;
    private static final int ANCIENT_SYMBOLS_LOW = 65536;
    private static final int ANCIENT_SYMBOLS_HIGH = 65999;
    private static final int MAX_LENGTH = 170;
    private static final Set<Integer> SET_OF_EXCEPTIONS = new HashSet<Integer>(Arrays.asList(165, 176, 160, 163, 9400, 186));
    private static final Set<Integer> IDENTIFIED_INVALID_SET = new HashSet<Integer>(Arrays.asList(304));

    private CharsUtils() {
    }

    private static String deleteSpecialChars(String text) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return " ";
        }
        StringBuilder newListControlChars = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            int character = text.codePointAt(i);
            if (!CharsUtils.isValid(character)) continue;
            char[] s = Character.toChars(character);
            String newCharachterToAdd = new String(s);
            newListControlChars.append(newCharachterToAdd);
        }
        return newListControlChars.toString();
    }

    public static boolean containsInvalidCharacters(String text) {
        if (text != null && !text.isEmpty()) {
            for (int i = 0; i < text.length(); ++i) {
                int character = text.codePointAt(i);
                if (CharsUtils.isValid(character)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isValid(int intVal) {
        return !(intVal >= 127 && intVal <= 190 && !SET_OF_EXCEPTIONS.contains(intVal) || intVal >= 8160 && intVal <= 8352 || intVal >= 8383 && intVal <= 10495 || intVal >= 19904 && intVal <= 19967 || intVal >= 11776 && intVal <= 11849 || intVal >= 55296 && intVal <= 63743 || intVal >= 65536 && intVal <= 65999 || intVal >= 5120 && intVal <= 5788 || intVal >= 6016 && intVal <= 6479 || intVal >= 65280 && intVal <= 100351 || IDENTIFIED_INVALID_SET.contains(intVal));
    }

    public static String preProcessString(String text) {
        if (text == null) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)text)) {
            return "";
        }
        if (text.length() > 170) {
            return CharsUtils.deleteSpecialChars(text.substring(0, 170));
        }
        return CharsUtils.deleteSpecialChars(text);
    }
}

