/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.nndep;

import com.ibm.smarts.core.util.ArrayWriter;
import com.ibm.smarts.core.util.Sha1HashBuilder;
import com.ibm.smarts.nlp.core.corenlp.fastload.FastLoadHelper;
import edu.stanford.nlp.parser.nndep.ClassifierWithProtectedVars;
import edu.stanford.nlp.parser.nndep.Config;
import edu.stanford.nlp.parser.nndep.Dataset;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class ClassifierFastLoad
extends ClassifierWithProtectedVars {
    private static Redwood.RedwoodChannels log = Redwood.channels((Object[])new Object[]{ClassifierFastLoad.class});

    public ClassifierFastLoad(Config config, double[][] E, double[][] W1, double[] b1, double[][] W2, List<Integer> preComputed) {
        this(config, null, E, W1, b1, W2, preComputed);
    }

    public ClassifierFastLoad(Config config, Dataset dataset, double[][] E, double[][] W1, double[] b1, double[][] W2, List<Integer> preComputed) {
        super(config, dataset, E, W1, b1, W2, preComputed);
    }

    private void cacheLog(long start, String msg) {
        System.out.println("[ClassifierFastLoad][time " + (System.currentTimeMillis() - start) + " ms] " + msg);
    }

    @Override
    public void preCompute(Set<Integer> toPreCompute) {
        ArrayWriter aw;
        long startMillis = System.currentTimeMillis();
        String CACHE_FOLDER = FastLoadHelper.getCacheFolder();
        if (CACHE_FOLDER == null) {
            aw = null;
        } else {
            this.cacheLog(startMillis, "Cache folder: " + CACHE_FOLDER);
            this.cacheLog(startMillis, "Building hash...");
            String hash = this.getHash(toPreCompute);
            this.cacheLog(startMillis, "Hash=" + hash);
            String cacheFilepathRel = CACHE_FOLDER + "/" + hash + ".dat";
            File cacheFile = new File(cacheFilepathRel);
            String cacheFilepath = cacheFile.getAbsolutePath();
            this.cacheLog(startMillis, "Cache file: " + cacheFilepath);
            aw = new ArrayWriter(cacheFilepath);
        }
        this.saved = new double[this.preMap.size()][this.config.hiddenSize];
        long cellCount = this.preMap.size() * this.config.hiddenSize;
        if (aw != null && aw.fileExists()) {
            this.cacheLog(startMillis, "Loading " + cellCount + " values");
            aw.readDoubleArray(this.saved);
            this.cacheLog(startMillis, "Finished loading values.");
        } else {
            long iterationCount = toPreCompute.size() * this.config.hiddenSize * this.config.embeddingSize;
            this.cacheLog(startMillis, "No cached values. " + iterationCount + " iterations. Creating values...");
            super.preCompute(toPreCompute);
            this.cacheLog(startMillis, "Finished creating " + cellCount + " values...");
            if (aw != null) {
                this.cacheLog(startMillis, "Writing values to cache file...");
                aw.writeDoubleArray(this.saved);
                this.cacheLog(startMillis, "Finished writing values to file.");
                double[][] savedCheck = new double[this.preMap.size()][this.config.hiddenSize];
                this.cacheLog(startMillis, "Reading values from file to verify...");
                aw.readDoubleArray(savedCheck);
                this.cacheLog(startMillis, "Finished reading values from file.");
                ArrayWriter.verifyEqual((double[][])this.saved, (double[][])savedCheck);
            }
        }
    }

    private String getHash(Set<Integer> toPreCompute) {
        Sha1HashBuilder ch = new Sha1HashBuilder();
        Object[] pc = new Integer[toPreCompute.size()];
        toPreCompute.toArray(pc);
        Arrays.sort(pc);
        ch.update("precompute");
        for (Object i : pc) {
            ch.update(((Integer)i).intValue());
        }
        ch.updateNewline();
        ch.update("numPreComputed", (double)this.config.numPreComputed);
        ch.update("embeddingSize", (double)this.config.embeddingSize);
        ch.update("hiddenSize", (double)this.config.hiddenSize);
        ch.update("numTokens", 48.0);
        ch.update("savedSize");
        ch.update(this.preMap.size());
        ch.update(this.config.hiddenSize);
        ch.update("preMapSize", (double)this.preMap.size());
        Object[] pm = new Integer[this.preMap.size()];
        toPreCompute.toArray(pm);
        Arrays.sort(pm);
        for (Object key : pm) {
            Integer value = (Integer)this.preMap.get(key);
            ch.update(((Integer)key).intValue());
            ch.update(value.intValue());
        }
        ClassifierFastLoad.hash(ch, "W1", this.W1);
        ClassifierFastLoad.hash(ch, "E", this.E);
        return ch.getDigest();
    }

    private static void hash(Sha1HashBuilder ch, String name, double[][] array) {
        int size = array.length;
        int size2 = array[0].length;
        ch.update(name, size, size2);
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size2; ++j) {
                ch.update(array[i][j]);
            }
            ch.updateNewline();
        }
        ch.updateNewline();
    }
}

