/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.prescriptive.recommender.internal;

import com.ibm.smarts.db.query.util.RectangleOfData;
import com.ibm.smarts.prescriptive.recommender.api.GoalSpecifications;
import com.ibm.smarts.prescriptive.recommender.api.IPrescription;
import com.ibm.smarts.prescriptive.recommender.api.IPrescriptiveRecommender;
import com.ibm.smarts.prescriptive.recommender.api.Metric;
import com.ibm.smarts.prescriptive.recommender.api.MetricType;
import com.ibm.smarts.prescriptive.recommender.api.TargetValueType;
import com.ibm.smarts.prescriptive.recommender.internal.PrescriptiveException;
import com.ibm.smarts.prescriptive.recommender.internal.PrescriptiveIssuer;
import com.ibm.smarts.prescriptive.recommender.internal.PrescriptiveStatus;
import com.ibm.smarts.prescriptive.recommender.ml.IRegressor;
import com.ibm.smarts.prescriptive.recommender.ml.NnRegressor;
import com.ibm.smarts.prescriptive.recommender.ml.NnRegressorConfig;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrescriptiveRecommender
implements IPrescriptiveRecommender {
    IRegressor nnRegressor = null;
    static final Logger LOGGER = LoggerFactory.getLogger(PrescriptiveRecommender.class);
    private static final int DEFAULT_PRESCRIPTIONS_NUMBER = 3;

    @Override
    public void fit(RectangleOfData rectangleOfData, int tragetColumnId, List<Integer> featureColumnsIndexes) {
        NnRegressorConfig config = new NnRegressorConfig();
        this.nnRegressor = new NnRegressor(config);
        this.nnRegressor.fit(rectangleOfData, tragetColumnId, featureColumnsIndexes);
    }

    @Override
    public List<IPrescription> getPrescription(GoalSpecifications goalSpec) throws PrescriptiveException {
        return this.getPrescription(goalSpec, 3);
    }

    @Override
    public List<IPrescription> getPrescription(GoalSpecifications goalSpec, int numberOfPrescriptions) throws PrescriptiveException {
        if (this.nnRegressor == null) {
            throw new PrescriptiveException(PrescriptiveStatus.REGRESSION_MODEL_DOES_NOT_EXIST);
        }
        int targetColIndex = this.nnRegressor.getTragetColumnIndex();
        double originalValue = goalSpec.getTargetRow().get(targetColIndex).doubleValue();
        double targetValue = this.extractTargetValue(goalSpec, originalValue);
        PrescriptiveIssuer prescriptiveIssuer = new PrescriptiveIssuer(this.nnRegressor, goalSpec, targetValue, originalValue);
        return prescriptiveIssuer.getPrescriptions(numberOfPrescriptions);
    }

    private double extractTargetValue(GoalSpecifications goalSpec, double originalValue) throws PrescriptiveException {
        double tValue = Double.NaN;
        Metric metric = goalSpec.getMetric();
        MetricType metricType = metric.getMetricType();
        TargetValueType targetValueType = metric.getTargetValueType();
        if (metricType == MetricType.INCREASE) {
            if (targetValueType == TargetValueType.COUNT) {
                tValue = originalValue + metric.getTargetValue();
            } else if (targetValueType == TargetValueType.PERCENT) {
                tValue = originalValue * (1.0 + metric.getTargetValue() / 100.0);
            }
        } else if (metricType == MetricType.DECREASE) {
            if (targetValueType == TargetValueType.COUNT) {
                tValue = originalValue - metric.getTargetValue();
            } else if (targetValueType == TargetValueType.PERCENT) {
                tValue = originalValue * (1.0 - metric.getTargetValue() / 100.0);
            }
        }
        if (Double.isNaN(tValue)) {
            LOGGER.error("Cannot understand goal");
            throw new PrescriptiveException(PrescriptiveStatus.CANNOT_UNDERSTAND_GOAL);
        }
        return tValue;
    }
}

