/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.similarity.classifier.common.core;

import com.ibm.smarts.nlp.embedding.WordEmbedding;
import com.ibm.smarts.similarity.classifier.common.api.WordEmbeddingProvider;
import com.ibm.smarts.similarity.classifier.common.core.IOovEncoder;
import com.ibm.smarts.similarity.classifier.common.core.NormedVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigramEncoder
implements IOovEncoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(BigramEncoder.class);
    WordEmbedding bigramEmbedding;
    private static final float OOV_WEIGHT = 0.5f;
    private static BigramEncoder ovvInstance = null;

    private BigramEncoder(WordEmbedding bigramEmbedding) {
        this.bigramEmbedding = bigramEmbedding;
    }

    public static synchronized BigramEncoder getInstance() {
        WordEmbedding bigramEmbedding;
        if (ovvInstance == null && (bigramEmbedding = WordEmbeddingProvider.getBigramEmbedding()) != null) {
            ovvInstance = new BigramEncoder(bigramEmbedding);
        }
        return ovvInstance;
    }

    @Override
    public float[] encode(String token) {
        if (this.bigramEmbedding == null) {
            LOGGER.debug("The word embeddings for bigram tokens seem to have been corrupted. Unable to encode OOV tokens.");
            return new float[0];
        }
        token = token + "#";
        int count = 0;
        NormedVector bigramEmbeddings = new NormedVector(new float[this.bigramEmbedding.getEmbeddingDimension()], 0.0);
        for (int i = 0; i < token.length() - 1; ++i) {
            String bigram = token.substring(i, i + 2);
            float[] embedding = this.bigramEmbedding.getEmbedding(bigram);
            if (embedding == null) continue;
            ++count;
            bigramEmbeddings.add(new NormedVector(embedding, false));
        }
        if (count == 0) {
            return null;
        }
        return bigramEmbeddings.multiply(0.5f / (float)count).getVector();
    }
}

