/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.impl;

import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.smarts.ca.api.ISmartsCa;
import com.ibm.smarts.ca.api.SmartsCaSystem;
import com.ibm.smarts.ca.core.impl.SmartsCaClientManager;
import com.ibm.smarts.ca.core.impl.content.CaMoserRestClient;
import com.ibm.smarts.ca.impl.SmartsCaHandlers;
import com.ibm.smarts.ca.impl.SmartsCaHelper;
import com.ibm.smarts.ca.rest.CaRestDataProviderInfo;
import com.ibm.smarts.common.mq.progress.SmartsModuleCancel;
import com.ibm.smarts.common.util.SmartsModuleUtil;
import com.ibm.smarts.core.util.ObjectCreator;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.core.util.ToString;
import com.ibm.smarts.dds.api.ISmartsModuleDescriptor;
import com.ibm.smarts.model.builder.SmartsModuleOptions;
import com.ibm.smarts.model.module.SmartsModuleStatusInfo;
import com.ibm.smarts.model.progress.SmartsModuleProgressSummary;
import com.ibm.smarts.schema.AnalysisScope;
import com.ibm.smarts.schema.CancelOption;
import com.ibm.smarts.schema.InScopeTable;
import com.ibm.smarts.schema.LoadOptions;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.AnalysisScopes;
import com.ibm.smarts.store.api.TypeNames;
import com.ibm.smarts.store.api.config.StoreConfig;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartsCa
implements ISmartsCa,
SmartsCaHandlers {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartsCa.class);
    private final SmartsCaSystem system;
    private final RequestContext requestContext;

    public SmartsCa(SmartsCaSystem system, RequestContext requestContext) {
        this.system = system;
        this.requestContext = requestContext;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public SmartsCaSystem getSystem() {
        return this.system;
    }

    @Override
    public ISmartsModuleDescriptor getSmartsModule(String id, Module module, String moduleType) {
        return (ISmartsModuleDescriptor)this.handle(this.requestContext, rc -> {
            CaRestDataProviderInfo dataProviderInfo = SmartsCaHelper.buildDataProviderInfo(this.system.caConfig, id, module, moduleType, null);
            rc.setRequestAttribute("com.ibm.smarts.restDataProviderInfo", (Object)dataProviderInfo);
            return this.system.getSmartsModule(this.requestContext, id, module);
        }, rc -> {});
    }

    public Properties getCaConfig() {
        return this.system.getCaConfig();
    }

    public String toString() {
        return ToString.with((Object)this).field("system", (Object)this.system).field("requestContext", (Object)this.requestContext).get();
    }

    @Override
    public String analyze(RequestContext requestContext, Module module, String moduleType, Set<String> excludedTables, String connections, String moduleUri, String assetId, LoadOptions loadOptions) {
        CaRestDataProviderInfo dataProviderInfo = SmartsCaHelper.buildDataProviderInfo(this.system.caConfig, assetId, moduleUri, module, moduleType, connections, excludedTables, loadOptions);
        requestContext.setRequestAttribute("com.ibm.smarts.restDataProviderInfo", (Object)dataProviderInfo);
        this.system.createSmartsModule(requestContext, assetId, module, excludedTables);
        return SmartsCaHelper.buildSmartsModuleUri((String)assetId);
    }

    @Override
    public SmartsModuleProgressSummary getProgressSummary(String smartsModuleId, AnalysisScope analysisScope) {
        return (SmartsModuleProgressSummary)this.handle(this.requestContext, rc -> this.getSmartsModuleProgressSummary((RequestContext)rc, smartsModuleId, analysisScope));
    }

    @Override
    public SmartsModuleStatusInfo getStatus(String smartsModuleId) {
        return (SmartsModuleStatusInfo)this.handle(this.requestContext, rc -> this.getStatus((RequestContext)rc, smartsModuleId));
    }

    @Override
    public SmartsModuleCancel cancelSmartModule(String smartsModuleId, CancelOption cancelOption) {
        SmartsModuleCancel cancel = (SmartsModuleCancel)this.handle(this.requestContext, requestContext -> this.system.cancelSmartModule((RequestContext)requestContext, smartsModuleId, cancelOption), rc -> {});
        return cancel;
    }

    @Override
    public SmartsModuleCancel deleteSmartModule(String smartsModuleId) {
        SmartsModuleCancel cancel = (SmartsModuleCancel)this.handle(this.requestContext, requestContext -> this.system.deleteSmartModule((RequestContext)requestContext, smartsModuleId), rc -> {});
        return cancel;
    }

    @Override
    public SmartsModule getSmartsModule(String smartsModuleId, SmartsModuleOptions smartsModuleOptions) {
        SmartsModule smartsModule = (SmartsModule)this.handle(this.requestContext, rc -> (SmartsModule)this.system.getStoreProvider().getPersistenceProvider(new StoreConfig(rc.locale, TypeNames.DDS)).get(rc, smartsModuleId, Collections.emptyList(), smartsModuleOptions).getRecord());
        if (smartsModule != null && com.ibm.smarts.schema.util.SmartsModuleUtil.isPackageType((SmartsModule)smartsModule)) {
            this.applySecurityView(smartsModule, smartsModuleId);
        }
        return smartsModule;
    }

    private void applySecurityView(SmartsModule smartsModule, String smartsModuleId) {
        Module module = null;
        ObjectCreator clientManagerCreator = (ObjectCreator)this.requestContext.getRequestAttribute("com.ibm.smarts.rest.clientManager");
        try (SmartsCaClientManager clientManager = (SmartsCaClientManager)clientManagerCreator.create(this.requestContext);){
            CaMoserRestClient moser = clientManager.getMoserClient();
            module = moser.getBusinessModuleMetadata(smartsModuleId);
        }
        catch (IOException e1) {
            LOGGER.error("Error getting Module when building shallow SmartsModule. {}", (Object)e1.getMessage());
        }
        if (module != null) {
            SmartsModuleUtil.filter((SmartsModule)smartsModule, module);
        }
    }

    private SmartsModuleProgressSummary getSmartsModuleProgressSummary(RequestContext requestContext, String smartsModuleId, AnalysisScope analysisScope) {
        try {
            SmartsModule smartsModule = this.system.getStoreProvider().getModuleStore(new StoreConfig(requestContext.locale, TypeNames.DDS), requestContext).getById(smartsModuleId);
            if (smartsModule != null) {
                List tags = AnalysisScopes.getInScopeTableNames((AnalysisScope)analysisScope);
                if (!tags.isEmpty()) {
                    smartsModule = this.tryToShrinkSmartsModule(smartsModule, tags);
                }
                return new SmartsModuleProgressSummary(smartsModule);
            }
            SmartsModuleOptions options = new SmartsModuleOptions.SmartsModuleOptionsBuilder().addFailedDataSets(true).build();
            if (analysisScope == null) {
                analysisScope = AnalysisScopes.emptyAnalysisScope();
            }
            if ((smartsModule = this.system.getStoreProvider().getPersistenceProvider(new StoreConfig(requestContext.locale, TypeNames.DDS)).getProgress(requestContext, smartsModuleId, analysisScope, options)) != null) {
                return new SmartsModuleProgressSummary(smartsModule);
            }
            throw new IOException("Could not find smarts module for id: " + smartsModuleId);
        }
        catch (Exception e) {
            LOGGER.error("Error getting smarts module progress summary. {}", (Object)e.getMessage());
            Thread.currentThread().interrupt();
            return null;
        }
    }

    private SmartsModule tryToShrinkSmartsModule(SmartsModule smartsModule, List<String> tags) {
        try {
            smartsModule = SmartsModuleUtil.shrinkSmartsModule((SmartsModule)smartsModule, tags);
        }
        catch (CloneNotSupportedException e) {
            LOGGER.error("Can not clone and shrink SmartsModule", (Throwable)e);
        }
        return smartsModule;
    }

    private SmartsModuleStatusInfo getStatus(RequestContext requestContext, String smartsModuleId) {
        try {
            SmartsModule smartsModule = this.system.getStoreProvider().getModuleStore(new StoreConfig(requestContext.locale, TypeNames.DDS), requestContext).getById(smartsModuleId);
            if (smartsModule != null) {
                return new SmartsModuleStatusInfo(smartsModule);
            }
            AnalysisScope scope = new AnalysisScope();
            InScopeTable inScopeTable = new InScopeTable();
            inScopeTable.setTableID("SmartsModule");
            scope.getInScopeTables().add(inScopeTable);
            SmartsModuleOptions options = new SmartsModuleOptions.SmartsModuleOptionsBuilder().addFailedDataSets(true).build();
            smartsModule = this.system.getStoreProvider().getPersistenceProvider(new StoreConfig(requestContext.locale, TypeNames.DDS)).getProgress(requestContext, smartsModuleId, scope, options);
            if (smartsModule != null) {
                return new SmartsModuleStatusInfo(smartsModule);
            }
            smartsModule = (SmartsModule)this.system.getStoreProvider().getPersistenceProvider(new StoreConfig(requestContext.locale, TypeNames.DDS)).get(requestContext, smartsModuleId, Collections.emptyList(), options).getRecord();
            if (smartsModule != null) {
                LOGGER.info("Status for smarts-module is computed by iterating over each DataSet's analysis state");
                return new SmartsModuleStatusInfo(smartsModule);
            }
            throw new IOException("Could not find smarts module for id: " + smartsModuleId);
        }
        catch (Exception e) {
            LOGGER.error("Error getting smarts module status. {}", (Object)e.getMessage());
            Thread.currentThread().interrupt();
            return null;
        }
    }
}

