/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.rest;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.ca.core.impl.SmartsCaCoreHelper;
import com.ibm.smarts.common.pipeline.SampleQueryContext;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.model.common.util.QuerySubjectUtil;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleQueryBuilder {
    private SampleQueryContext sampleQueryContext;
    private final Logger LOGGER = LoggerFactory.getLogger(SampleQueryBuilder.class);

    public SampleQueryBuilder(SampleQueryContext sampleQueryContext) {
        this.sampleQueryContext = sampleQueryContext;
    }

    public int getSampleSeed() {
        return this.getSampleQueryContext().getSampleSeed();
    }

    public int getSampleSize() {
        return this.getSampleQueryContext().getSampleSize();
    }

    public JSONObject buildSampleObject() {
        return this.buildSampleObject(this.getSampleSize());
    }

    private JSONObject buildSampleObject(double rowLimit) {
        JSONObject sampleObject = new JSONObject();
        sampleObject.put((Object)"seed", (Object)this.getSampleSeed());
        sampleObject.put((Object)"rowCount", (Object)rowLimit);
        return sampleObject;
    }

    public SampleQueryContext getSampleQueryContext() {
        return this.sampleQueryContext;
    }

    public String getDatasetType() {
        return this.getSampleQueryContext().getDatasetType();
    }

    public Map<String, List<String>> getQuerySubjectMap() {
        return this.getSampleQueryContext().getQuerySubjectMap();
    }

    private String getModuleId() {
        return this.getSampleQueryContext().getModuleId();
    }

    public String getSamplesUri(String hostUri, String querySubjectId) {
        return this.buildSamplesUri(hostUri, this.getModuleId(), querySubjectId, this.getDatasetType(), this.getConnections());
    }

    public String getSamplesUri(String hostUri, String querySubjectId, List<String> queryItemIds) {
        JSONObject querySpec = this.buildSamplesQuerySpec(querySubjectId, queryItemIds, this.getConnections());
        return this.buildSamplesUri(hostUri, this.getModuleId(), querySubjectId, this.getDatasetType(), querySpec);
    }

    private String getConnections() {
        return this.getSampleQueryContext().getConnections();
    }

    private static void addSortingCriteriaJSON(JSONObject dataItem) {
        JSONArray selectionArray = new JSONArray();
        JSONObject selection = new JSONObject();
        selection.put((Object)"operation", (Object)"order");
        JSONObject sortJSON = new JSONObject();
        sortJSON.put((Object)"type", (Object)"asc");
        selection.put((Object)"sort", (Object)sortJSON);
        selectionArray.add((Object)selection);
        dataItem.put((Object)"selection", (Object)selectionArray);
    }

    private JSONObject buildSamplesQuerySpec(String qsId, String connections) {
        List<String> items = this.getQuerySubjectMap().get(qsId);
        return this.buildSamplesQuerySpec(qsId, items, connections);
    }

    private JSONObject buildSamplesQuerySpec(String qsId, List<String> items, String connections) {
        JSONArray connectionsJSON;
        JSONObject querySpec = new JSONObject();
        JSONArray dataItems = new JSONArray();
        JSONArray projections = new JSONArray();
        int columnCount = items.size();
        for (int i = 0; i < columnCount; ++i) {
            String qiId = items.get(i);
            JSONObject dataItem = new JSONObject();
            dataItem.put((Object)"id", (Object)String.valueOf(i));
            dataItem.put((Object)"itemId", (Object)(qsId + "." + qiId));
            if (QuerySubjectUtil.isRowIdentifier((String)qiId)) {
                SampleQueryBuilder.addSortingCriteriaJSON(dataItem);
            }
            dataItems.add((Object)dataItem);
            projections.add((Object)String.valueOf(i));
        }
        querySpec.put((Object)"version", (Object)"1");
        querySpec.put((Object)"dataItems", (Object)dataItems);
        querySpec.put((Object)"projections", (Object)projections);
        querySpec.put((Object)"type", (Object)"detail");
        if (connections != null && (connectionsJSON = this.parseConnections(connections)) != null) {
            querySpec.put((Object)"connections", (Object)connectionsJSON);
        }
        querySpec.put((Object)"limit", (Object)this.getSampleSize());
        querySpec.put((Object)"sampling", (Object)this.buildSampleObject());
        return querySpec;
    }

    private JSONArray parseConnections(String connections) {
        JSONArray conn = null;
        try {
            JSONObject connectionObj = JSONObject.parse((String)connections);
            conn = (JSONArray)connectionObj.get((Object)"connections");
        }
        catch (IOException e) {
            this.LOGGER.error("Error parsing connections. Ignored connections");
        }
        return conn;
    }

    private String buildSamplesUri(String hostUrl, String moduleId, String qsId, String type, String connections) {
        URI uri;
        URIBuilder builder;
        try {
            builder = new URIBuilder(hostUrl);
        }
        catch (URISyntaxException e) {
            throw new InternalException((Throwable)e, "failed to build URI for " + hostUrl, new Object[0]);
        }
        builder.setPath(SmartsCaCoreHelper.CaDatasetPaths.datasetDataPath((String)moduleId));
        JSONObject querySpec = this.buildSamplesQuerySpec(qsId, connections);
        builder.addParameter("type", type);
        builder.addParameter("querySpec", querySpec.toString());
        try {
            uri = builder.build();
        }
        catch (URISyntaxException e) {
            throw new InternalException((Throwable)e, "failed to build URI for " + builder.getPath(), new Object[0]);
        }
        return uri.toString();
    }

    private String buildSamplesUri(String hostUrl, String moduleId, String qsId, String type, JSONObject querySpec) {
        URI uri;
        URIBuilder builder;
        try {
            builder = new URIBuilder(hostUrl);
        }
        catch (URISyntaxException e) {
            throw new InternalException((Throwable)e, "failed to build URI for " + hostUrl, new Object[0]);
        }
        builder.setPath(SmartsCaCoreHelper.CaDatasetPaths.datasetDataPath((String)moduleId));
        builder.addParameter("type", type);
        builder.addParameter("querySpec", querySpec.toString());
        try {
            uri = builder.build();
        }
        catch (URISyntaxException e) {
            throw new InternalException((Throwable)e, "failed to build URI for " + builder.getPath(), new Object[0]);
        }
        return uri.toString();
    }
}

