/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.model.common.util;

import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.SourceCategoryType;
import com.ibm.bi.platform.moser.common.generated.metadata.UseSpecType;
import com.ibm.smarts.model.common.util.UniqueNameGenerator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ModuleUtil {
    public static final String STRING_FMPACKAGE = "FM_Package";
    private static final String SOURCECATEGORY_DIMENSION = "dimension";

    public static boolean isFMPackageModule(Module module) {
        return module.getUseSpec().isEmpty() && module.getContainer() != null && module.getContainer().equals(STRING_FMPACKAGE);
    }

    public static Optional<String> getSingleFMSourceModule(Module module) {
        if (ModuleUtil.isSingleFMSourceModule(module)) {
            return Optional.of(((Module.UseSpec)module.getUseSpec().get(0)).getStoreID());
        }
        return Optional.empty();
    }

    public static boolean isSingleFMSourceModule(Module module) {
        Module.UseSpec u;
        return module.getUseSpec().size() == 1 && "*".equals((u = (Module.UseSpec)module.getUseSpec().get(0)).getImports()) && (UseSpecType.PACKAGE.equals((Object)u.getType()) || UseSpecType.LW_OLAP.equals((Object)u.getType()));
    }

    public static boolean isOLAPModule(Module module) {
        if (module != null) {
            List qsList = module.getQuerySubject();
            for (QuerySubject qs : qsList) {
                SourceCategoryType sType = qs.getSourceCategory();
                if (sType == null || !sType.toString().toLowerCase().startsWith(SOURCECATEGORY_DIMENSION)) continue;
                return true;
            }
        }
        return false;
    }

    public static Set<String> getQuerySubjectNamesFromNamespace(String namespace, Module module) {
        return module.getQuerySubject().stream().map(ObjectType::getIdentifier).filter(s -> s.startsWith(namespace)).collect(Collectors.toSet());
    }

    public static Optional<String> getSourceStoreId(QuerySubject qs, Map<String, Set<String>> fmPackageAlias, Module module) {
        Optional<Object> id = Optional.empty();
        id = ModuleUtil.getSingleFMSourceModule(module);
        if (id.isPresent()) {
            return id;
        }
        return fmPackageAlias.entrySet().stream().filter(e -> ((Set)e.getValue()).stream().anyMatch(a -> qs.getIdentifier().startsWith((String)a))).map(Map.Entry::getKey).findFirst();
    }

    public static String getNamespace(QuerySubject qs, Module module) {
        int pos;
        String[] parts = qs.getIdentifier().split("\\.");
        int n = pos = ModuleUtil.isSingleFMSourceModule(module) ? 0 : 1;
        if (parts.length >= pos + 1) {
            return parts[pos];
        }
        return "";
    }

    public static String getSourceAndNamespace(QuerySubject qs, Map<String, Set<String>> fmPackageAlias, Module module) {
        String source = ModuleUtil.getSourceStoreId(qs, fmPackageAlias, module).orElse("");
        String namespace = ModuleUtil.getNamespace(qs, module);
        return UniqueNameGenerator.createUniqueName(source, namespace);
    }

    public static boolean isDimension(QuerySubject qs) {
        SourceCategoryType sct = qs.getSourceCategory();
        return SourceCategoryType.DIMENSION_MEASURE.equals((Object)sct) || SourceCategoryType.DIMENSION_REGULAR.equals((Object)sct);
    }
}

