/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.db.query.util;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.ca.core.impl.SmartsCaClientManager;
import com.ibm.smarts.common.modifiers.BaseFilter;
import com.ibm.smarts.common.modifiers.CategoricalFilterCondition;
import com.ibm.smarts.common.modifiers.FilterCondition;
import com.ibm.smarts.common.modifiers.FilterType;
import com.ibm.smarts.common.modifiers.FilterTypeConversionException;
import com.ibm.smarts.common.modifiers.InclusionExclusionFilter;
import com.ibm.smarts.common.modifiers.NumericFilter;
import com.ibm.smarts.common.modifiers.NumericOperator;
import com.ibm.smarts.common.modifiers.PreOrPostAggregation;
import com.ibm.smarts.common.modifiers.TopBottomFilter;
import com.ibm.smarts.common.modifiers.TopBottomFilterType;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.rest.client.util.JaxRs20Exceptions;
import com.ibm.smarts.db.query.util.QueryParameters;
import com.ibm.smarts.db.query.util.RectangleOfData;
import com.ibm.smarts.model.value.DoubleValue;
import com.ibm.smarts.model.value.StringValue;
import com.ibm.smarts.model.value.Value;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.UsageType;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import edu.emory.mathcs.backport.java.util.Collections;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import javax.ws.rs.WebApplicationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataQueryLib {
    private static final long BIG_NUMBER = 10000000L;
    private static final Random randomizer = new Random();
    private static final String JSON_VERSION = "version";
    private static final String JSON_DATAITEMS = "dataItems";
    private static final String JSON_DATA = "data";
    private static final String JSON_PROJECTIONS = "projections";
    private static final String JSON_LIMIT = "limit";
    private static final String JSON_QUERYHINTS = "queryHints";
    private static final String JSON_SELECTION = "selection";
    private static final String JSON_FILTERS = "filters";
    private static final String IN = "in";
    private static final String NOT_IN = "notin";
    private static final Logger LOGGER = LoggerFactory.getLogger(DataQueryLib.class);

    public static RectangleOfData execute(SmartsCaClientManager clientManager, String moduleId, String sourceType, QueryParameters params) {
        RectangleOfData result = new RectangleOfData();
        try {
            ArrayList<ColumnInfo> measures = new ArrayList<ColumnInfo>();
            ArrayList<String> attributes = new ArrayList<String>();
            for (int index = 0; index < params.getColumnIds().size(); ++index) {
                for (DatasetInfo dataset : params.getSmartsModule().getDatasets()) {
                    List columnInfos = SmartsModuleUtil.getFlattenedColumns((BaseItemObject)dataset);
                    for (ColumnInfo ci : columnInfos) {
                        if (!params.getColumnIds().get(index).equals(ci.getIdForExpression())) continue;
                        if (ci.getUsage().equals((Object)UsageType.FACT)) {
                            measures.add(ci);
                        } else {
                            attributes.add(ci.getIdForExpression());
                        }
                        result.getColumnInfoMap().put(index, ci);
                    }
                }
            }
            String spec = DataQueryLib.generateUnorderedQuerySpec(measures, attributes, params);
            String response = clientManager.getDatasetsClient().getData(moduleId, sourceType, spec);
            List<List<Value>> data = DataQueryLib.parseMultiMeasureResponse(response);
            result.setValues(data);
        }
        catch (InternalException | JaxRs20Exceptions.ResponseProcessingException | WebApplicationException e) {
            LOGGER.error("Error querying data for top/bottom content recommendations", e);
        }
        return result;
    }

    private static String generateUnorderedQuerySpec(List<ColumnInfo> measures, List<String> attributes, QueryParameters params) {
        JSONObject querySpec = new JSONObject();
        JSONArray dataItems = new JSONArray();
        JSONArray projections = new JSONArray();
        JSONArray filters = new JSONArray();
        DataQueryLib.generateSpecForFilters(filters, params);
        DataQueryLib.generateSpecForOrderedDataItemsProjections(dataItems, projections, measures, attributes, params);
        querySpec.put((Object)JSON_VERSION, (Object)"1");
        querySpec.put((Object)JSON_DATAITEMS, (Object)dataItems);
        querySpec.put((Object)JSON_PROJECTIONS, (Object)projections);
        querySpec.put((Object)JSON_LIMIT, (Object)params.getRowNumLimit());
        querySpec.put((Object)JSON_QUERYHINTS, (Object)new JSONObject());
        if (!filters.isEmpty()) {
            querySpec.put((Object)JSON_FILTERS, (Object)filters);
        }
        return querySpec.toString();
    }

    private static void generateSpecForFilters(JSONArray filters, QueryParameters params) {
        InclusionExclusionFilter filter;
        List inclusionExclusionFilters = params.getBaseFilter().stream().filter(f -> f.getType().equals((Object)FilterType.INCLUSION_EXCLUSION)).collect(Collectors.toList());
        List numericFilters = params.getBaseFilter().stream().filter(f -> f.getType().equals((Object)FilterType.NUMERIC)).collect(Collectors.toList());
        for (BaseFilter inclFilter : inclusionExclusionFilters) {
            try {
                filter = inclFilter.toInclusionExclusionFilter();
                JSONObject inclFilterSpec = DataQueryLib.makeInclusionFilterSpec(filter);
                filters.add((Object)inclFilterSpec);
            }
            catch (FilterTypeConversionException e) {
                LOGGER.error("Failed to convert base filter to Inclusion Filter", (Throwable)e);
            }
        }
        for (BaseFilter numFilter : numericFilters) {
            try {
                filter = numFilter.toNumericFilter();
                JSONObject numericFilterSpec = DataQueryLib.makeNumericFilterSpec((NumericFilter)filter);
                filters.add((Object)numericFilterSpec);
            }
            catch (FilterTypeConversionException e) {
                LOGGER.error("Failed to convert base filter to Numeric Filter", (Throwable)e);
            }
        }
    }

    private static JSONObject makeInclusionFilterSpec(InclusionExclusionFilter inclFilter) {
        String itemId = inclFilter.getColumnId();
        List<String> inclValues = inclFilter.getInclusionValues().stream().map(val -> val.getUniqueValue()).collect(Collectors.toList());
        JSONObject expressionForInclValues = null;
        JSONObject expressionForFilterCondition = null;
        if (!inclValues.isEmpty()) {
            String operator = inclFilter.getInvertFlag() ? NOT_IN : IN;
            expressionForInclValues = DataQueryLib.makeExpressionForInclusion(operator, itemId, inclValues, null, Optional.empty());
        }
        if (inclFilter.getFilterCondition() != null) {
            FilterCondition filterCondition = inclFilter.getFilterCondition();
            String operator = DataQueryLib.getOperatorFromCategoricalCondition(filterCondition.getCondition());
            Boolean ignoreCase = filterCondition.getIgnoreCase();
            List values = filterCondition.getValues();
            expressionForFilterCondition = DataQueryLib.makeExpressionForInclusion(operator, itemId, values, "display", Optional.of(ignoreCase));
        }
        JSONObject filterJson = new JSONObject();
        filterJson.put((Object)"type", (Object)PreOrPostAggregation.PRE.name().toLowerCase());
        if (expressionForFilterCondition != null && expressionForInclValues != null) {
            JSONArray orArray = new JSONArray();
            orArray.add((Object)expressionForInclValues);
            orArray.add((Object)expressionForFilterCondition);
            JSONObject orJson = new JSONObject();
            orJson.put((Object)"or", (Object)orArray);
            filterJson.put((Object)"expression", (Object)orJson);
        } else if (expressionForInclValues != null) {
            filterJson.put((Object)"expression", (Object)expressionForInclValues);
        } else if (expressionForFilterCondition != null) {
            filterJson.put((Object)"expression", expressionForFilterCondition);
        }
        return filterJson;
    }

    private static String getOperatorFromCategoricalCondition(CategoricalFilterCondition categoricalCondition) {
        switch (categoricalCondition) {
            case BEGINS_WITH: {
                return "beginswith";
            }
            case ENDS_WITH: {
                return "endswith";
            }
            case CONTAINS: {
                return "contains";
            }
            case EQUALS: {
                return IN;
            }
        }
        return null;
    }

    private static String getOperatorFromNumericOperator(NumericOperator numericOperator) {
        switch (numericOperator) {
            case GREATER_THAN_EQUALS: {
                return "gte";
            }
            case LESS_THAN_EQUALS: {
                return "lte";
            }
            case GREATER_THAN: {
                return "gt";
            }
            case LESS_THAN: {
                return "lt";
            }
        }
        return null;
    }

    private static JSONObject makeNumericFilterSpec(NumericFilter numFilter) {
        String itemId = numFilter.getColumnId();
        String operator = DataQueryLib.getOperatorFromNumericOperator(numFilter.getOperator());
        String value = numFilter.getValue();
        JSONObject expressionForNumeric = DataQueryLib.makeExpressionForNumeric(operator, itemId, value);
        JSONObject filterJson = new JSONObject();
        filterJson.put((Object)"type", (Object)PreOrPostAggregation.POST.name().toLowerCase());
        filterJson.put((Object)"expression", (Object)expressionForNumeric);
        return filterJson;
    }

    private static JSONObject makeExpressionForNumeric(String operator, String itemId, String value) {
        JSONObject expressionJson = new JSONObject();
        JSONArray valuesArray = new JSONArray();
        valuesArray.add((Object)value);
        expressionJson.put((Object)"operator", (Object)operator);
        expressionJson.put((Object)"itemId", (Object)itemId);
        expressionJson.put((Object)"values", (Object)valuesArray);
        return expressionJson;
    }

    private static JSONObject makeExpressionForInclusion(String operator, String itemId, List<String> inclValues, String valueType, Optional<Boolean> ignoreCase) {
        JSONObject expressionJson = new JSONObject();
        JSONArray inclValuesArray = new JSONArray();
        inclValuesArray.addAll(inclValues);
        expressionJson.put((Object)"operator", (Object)operator);
        expressionJson.put((Object)"itemId", (Object)itemId);
        expressionJson.put((Object)"values", (Object)inclValuesArray);
        expressionJson.put((Object)"valueType", (Object)valueType);
        if (ignoreCase.isPresent()) {
            expressionJson.put((Object)"ignoreCase", (Object)ignoreCase.get());
        }
        return expressionJson;
    }

    private static void addSelectionToDataItem(JSONObject dataItem, int priority, String sortType) {
        JSONArray selection1Array = new JSONArray();
        JSONObject selection1 = new JSONObject();
        selection1.put((Object)"operation", (Object)"order");
        JSONObject sort1 = new JSONObject();
        sort1.put((Object)"type", (Object)sortType);
        sort1.put((Object)"priority", (Object)priority);
        selection1.put((Object)"sort", (Object)sort1);
        selection1Array.add((Object)selection1);
        dataItem.put((Object)JSON_SELECTION, (Object)selection1Array);
    }

    private static void generateSpecForOrderedDataItemsProjections(JSONArray dataItems, JSONArray projections, List<ColumnInfo> aggregatedMeasures, List<String> attributes, QueryParameters params) {
        String uniqueId;
        int dataItemIdx;
        List<String> uniqueIds = DataQueryLib.generateUniqueIdsForSelection(aggregatedMeasures.size() + attributes.size());
        TopBottomFilter topBottomFilter = null;
        for (BaseFilter filter : params.getBaseFilter()) {
            if (!filter.getType().equals((Object)FilterType.TOP_BOTTOM)) continue;
            try {
                topBottomFilter = filter.toTopBottomFilter();
            }
            catch (FilterTypeConversionException e) {}
        }
        for (dataItemIdx = 0; dataItemIdx < aggregatedMeasures.size(); ++dataItemIdx) {
            uniqueId = uniqueIds.get(dataItemIdx);
            ColumnInfo measure = aggregatedMeasures.get(dataItemIdx);
            JSONObject dataItem = DataQueryLib.makeDataItemJSON(uniqueId, measure.getIdForExpression(), Optional.of(DataQueryLib.getQueryableAggregation(measure)));
            dataItems.add((Object)dataItem);
            if (topBottomFilter != null && measure.getIdForExpression().equals(topBottomFilter.getColumnId())) {
                JSONArray selection = new JSONArray();
                JSONObject topOrbottomSpec = DataQueryLib.makeTopOrBottomSpec(topBottomFilter);
                JSONObject selection1 = DataQueryLib.makeSelectionJSON("keep", Optional.of(topOrbottomSpec), Optional.empty());
                selection.add((Object)selection1);
                JSONObject sort = DataQueryLib.makeSort();
                JSONObject selection2 = DataQueryLib.makeSelectionJSON("order", Optional.empty(), Optional.of(sort));
                selection.add((Object)selection2);
                dataItem.put((Object)JSON_SELECTION, (Object)selection);
            }
            projections.add((Object)uniqueId);
        }
        for (dataItemIdx = 0; dataItemIdx < attributes.size(); ++dataItemIdx) {
            uniqueId = uniqueIds.get(dataItemIdx + aggregatedMeasures.size());
            JSONObject dataItem = DataQueryLib.makeDataItemJSON(uniqueId, attributes.get(dataItemIdx), Optional.empty());
            dataItems.add((Object)dataItem);
            if (topBottomFilter == null) {
                DataQueryLib.addSelectionToDataItem(dataItem, dataItemIdx, "asc");
            }
            projections.add((Object)uniqueId);
        }
    }

    private static JSONObject makeSort() {
        JSONObject sort = new JSONObject();
        sort.put((Object)"type", (Object)"desc");
        sort.put((Object)"by", (Object)"value");
        sort.put((Object)"priority", (Object)1);
        return sort;
    }

    private static JSONObject makeTopOrBottomSpec(TopBottomFilter filter) {
        JSONObject topOrbottomSpec = new JSONObject();
        topOrbottomSpec.put((Object)"type", (Object)(filter.getTopBottomType().equals((Object)TopBottomFilterType.TOP) ? "topcount" : "bottomcount"));
        topOrbottomSpec.put((Object)"value", (Object)Integer.toString(filter.getDomainSize()));
        return topOrbottomSpec;
    }

    private static JSONArray makeContext(String idForExpression) {
        JSONArray context = new JSONArray();
        JSONObject contextItem = new JSONObject();
        contextItem.put((Object)"itemId", (Object)idForExpression);
        context.add((Object)contextItem);
        return context;
    }

    private static JSONObject makeSelectionJSON(String operation, Optional<JSONObject> topBottomSpec, Optional<JSONObject> sort) {
        JSONObject selection = new JSONObject();
        selection.put((Object)"operation", (Object)operation);
        if (topBottomSpec.isPresent()) {
            selection.put((Object)"topBottom", (Object)topBottomSpec.get());
        }
        if (sort.isPresent()) {
            selection.put((Object)"sort", (Object)sort.get());
        }
        return selection;
    }

    private static List<String> generateUniqueIdsForSelection(int n) {
        ArrayList<String> uniqueList = new ArrayList<String>();
        for (int uniqueId = 0; uniqueId < n; ++uniqueId) {
            long id;
            String idString;
            do {
                id = Math.round(randomizer.nextDouble() * 1.0E7);
            } while (uniqueList.contains(idString = "id_" + id));
            uniqueList.add(idString);
        }
        return uniqueList;
    }

    private static List<List<Value>> parseMultiMeasureResponse(String response) {
        JSONObject json;
        try {
            json = JSONObject.parse((String)response);
        }
        catch (IOException e) {
            LOGGER.error("Error parsing top/bottom query response", (Throwable)e);
            return Collections.emptyList();
        }
        JSONArray dataItems = (JSONArray)json.get((Object)JSON_DATAITEMS);
        JSONArray data = (JSONArray)json.get((Object)JSON_DATA);
        return DataQueryLib.parseData(dataItems, data);
    }

    private static List<List<Value>> parseData(JSONArray dataItems, JSONArray data) {
        ArrayList<List<Value>> map = new ArrayList<List<Value>>();
        for (int y = 0; y < data.size(); ++y) {
            map.add(new ArrayList());
            JSONObject ptProp = (JSONObject)data.get(y);
            JSONArray pt = (JSONArray)ptProp.get((Object)"pt");
            for (int j = 0; j < pt.size(); ++j) {
                Object v1 = pt.get(j);
                if (v1 instanceof JSONObject) {
                    JSONObject v1Cast = (JSONObject)v1;
                    Long value1Double = (Long)v1Cast.get((Object)"v");
                    DoubleValue value1 = new DoubleValue((double)value1Double.longValue());
                    ((List)map.get(y)).add(value1);
                    continue;
                }
                if (!(v1 instanceof Long)) continue;
                int index = ((Long)v1).intValue();
                JSONObject itemObj = (JSONObject)dataItems.get(j);
                JSONArray items = (JSONArray)itemObj.get((Object)"items");
                JSONObject labelObj = (JSONObject)items.get(index);
                JSONArray t = (JSONArray)labelObj.get((Object)"t");
                JSONObject tArr = (JSONObject)t.get(0);
                String label = (String)tArr.get((Object)"u");
                StringValue labelValue = new StringValue(label);
                ((List)map.get(y)).add(labelValue);
            }
        }
        return map;
    }

    private static JSONObject makeDataItemJSON(String id, String itemId, Optional<String> aggregate) {
        JSONObject dataItem = new JSONObject();
        dataItem.put((Object)"id", (Object)id);
        dataItem.put((Object)"itemId", (Object)itemId);
        if (aggregate.isPresent()) {
            dataItem.put((Object)"aggregate", (Object)aggregate.get());
        }
        return dataItem;
    }

    private static String getQueryableAggregation(ColumnInfo aggregatedMeasure) {
        if (aggregatedMeasure.getSemanticInfo() != null && aggregatedMeasure.getSemanticInfo().getDefaultAggregation() != null) {
            switch (aggregatedMeasure.getSemanticInfo().getDefaultAggregation()) {
                case SUM: {
                    return "sum";
                }
                case AVERAGE: {
                    return "avg";
                }
                case COUNT: {
                    return "count";
                }
                case COUNT_DISTINCT: {
                    return "countdistinct";
                }
                case MAXIMUM: {
                    return "max";
                }
                case MINIMUM: {
                    return "min";
                }
                case NONE: {
                    return "none";
                }
            }
            return "none";
        }
        return "none";
    }
}

