/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.questionanalyzer.core;

import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.lifecycle.IComponentLifecycle;
import com.ibm.smarts.core.lifecycle.IComponentLifecycleOperations;
import com.ibm.smarts.core.lifecycle.ILifecycleManager;
import com.ibm.smarts.core.lifecycle.IManagedLifecycle;
import com.ibm.smarts.core.lifecycle.LifecycleManager;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.nlp.api.SmartNLP;
import com.ibm.smarts.ontology.service.KnowledgeDiscoveryService;
import com.ibm.smarts.qa.api.QuestionAnalyzer;
import com.ibm.smarts.questionanalyzer.core.assembler.Assembler;
import com.ibm.smarts.questionanalyzer.core.interpretation.Interpretation;
import com.ibm.smarts.questionanalyzer.core.interpretation.InterpretationBoard;
import com.ibm.smarts.questionanalyzer.core.workflow.AnalyzerContext;
import com.ibm.smarts.questionanalyzer.core.workflow.AnalyzerWorkflow;
import com.ibm.smarts.questionanalyzer.core.workflow.AnalyzerWorkflowManager;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuestionAnalyzerImpl
implements QuestionAnalyzer,
IComponentLifecycle,
IManagedLifecycle {
    private AnalyzerWorkflow mWorkflow;
    private final SmartNLP nlp;
    private final IStoreProvider storeProvider;
    private final KnowledgeDiscoveryService knowledgeDiscoveryService;
    private final Assembler assembler;
    private final LifecycleManager clh;
    private static final Logger LOGGER = LoggerFactory.getLogger(QuestionAnalyzerImpl.class);

    public QuestionAnalyzerImpl(SmartNLP nlp, IStoreProvider storeProvider, KnowledgeDiscoveryService knowledgeDiscoveryService) {
        this.loadWorkflow();
        this.nlp = nlp;
        this.storeProvider = storeProvider;
        this.knowledgeDiscoveryService = knowledgeDiscoveryService;
        this.assembler = new Assembler();
        this.clh = new LifecycleManager((IComponentLifecycle)this, new IComponentLifecycleOperations[0]);
    }

    private void loadWorkflow() {
        AnalyzerWorkflowManager manager = AnalyzerWorkflowManager.getInstance();
        this.mWorkflow = manager.getWorkflow();
    }

    public List<com.ibm.smarts.qa.api.Interpretation> analyze(RequestContext ctx, String questionText) {
        InterpretationBoard board = new InterpretationBoard(questionText);
        AnalyzerContext context = new AnalyzerContext(ctx, board, this.nlp, this.storeProvider, this.knowledgeDiscoveryService, this.assembler);
        try {
            this.mWorkflow.process(context, board);
            List<Interpretation> interpretations = board.getInterpretations();
            return interpretations.stream().map(x -> this.assembler.assembleInterpretation((Interpretation)x)).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new InternalException((Throwable)e, "Analyze question", new Object[]{questionText});
        }
    }

    public ILifecycleManager getLifecycleManager() {
        return this.clh;
    }

    public void initialize(RequestContext rc) {
        LOGGER.info("<TCL> Component initialize Question Analyzer");
    }

    public void shutDown(RequestContext rc) {
        LOGGER.info("<TCL> Component shutdown Question Analyzer");
    }
}

