/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.common.modifiers;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.common.modifiers.BaseFilter;
import com.ibm.smarts.common.modifiers.FilterType;
import com.ibm.smarts.common.modifiers.TopBottomFilterType;
import com.ibm.smarts.common.modifiers.TopBottomFilteringMethod;
import com.ibm.smarts.schema.AggregationType;

public class TopBottomFilter
extends BaseFilter {
    private TopBottomFilterType topBottomType;
    private TopBottomFilteringMethod method;
    private String byColumn;
    private int domainSize = 3;
    private AggregationType byAggregate;

    public TopBottomFilter(String columnId, TopBottomFilterType type, TopBottomFilteringMethod method, String byCol, int domainSize) {
        this(columnId, null, null, type, method, byCol, domainSize);
    }

    public TopBottomFilter(String columnId, TopBottomFilterType type, TopBottomFilteringMethod method, String byCol, int domainSize, AggregationType byAggregate) {
        this(columnId, null, null, type, method, byCol, domainSize, byAggregate);
    }

    @JsonCreator
    public TopBottomFilter(@JsonProperty(value="columnId") String columnId, @JsonProperty(value="filterId") String filterId, @JsonProperty(value="label") String label, @JsonProperty(value="type") TopBottomFilterType type, @JsonProperty(value="method") TopBottomFilteringMethod method, @JsonProperty(value="byCol") String byCol, @JsonProperty(value="domainSize") int domainSize) {
        super(columnId, filterId, label);
        this.topBottomType = type;
        this.method = method;
        this.byColumn = byCol;
        this.domainSize = domainSize;
    }

    @JsonCreator
    public TopBottomFilter(@JsonProperty(value="columnId") String columnId, @JsonProperty(value="filterId") String filterId, @JsonProperty(value="label") String label, @JsonProperty(value="type") TopBottomFilterType type, @JsonProperty(value="method") TopBottomFilteringMethod method, @JsonProperty(value="byCol") String byCol, @JsonProperty(value="domainSize") int domainSize, @JsonProperty(value="byAggregate") AggregationType byAggregate) {
        super(columnId, filterId, label);
        this.topBottomType = type;
        this.method = method;
        this.byColumn = byCol;
        this.domainSize = domainSize;
        this.byAggregate = byAggregate;
    }

    public TopBottomFilter(TopBottomFilter other) {
        super(other != null ? other.getColumnId() : "", other != null ? other.getFilterId() : null, other != null ? other.getLabel() : null);
        if (other != null) {
            this.topBottomType = other.topBottomType;
            this.method = other.method;
            this.byColumn = other.byColumn;
            this.domainSize = other.domainSize;
            this.byAggregate = other.byAggregate;
        }
    }

    public static TopBottomFilter negate(TopBottomFilter source) {
        TopBottomFilter filter = new TopBottomFilter(source);
        if (filter.getTopBottomType().equals((Object)TopBottomFilterType.BOTTOM)) {
            filter.setTopBottomType(TopBottomFilterType.TOP);
        } else {
            filter.setTopBottomType(TopBottomFilterType.BOTTOM);
        }
        return filter;
    }

    public TopBottomFilterType getTopBottomType() {
        return this.topBottomType;
    }

    public void setTopBottomType(TopBottomFilterType type) {
        this.topBottomType = type;
    }

    public TopBottomFilteringMethod getMethod() {
        return this.method;
    }

    public void setMethod(TopBottomFilteringMethod method) {
        this.method = method;
    }

    public String getByColumn() {
        return this.byColumn;
    }

    public void setByColumn(String byColumn) {
        this.byColumn = byColumn;
    }

    public int getDomainSize() {
        return this.domainSize;
    }

    public void setDomainSize(int domainSize) {
        this.domainSize = domainSize;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject obj = new JSONObject();
        super.toJSONObject(obj);
        obj.put((Object)"topBottomType", (Object)this.topBottomType.name());
        obj.put((Object)"method", (Object)this.method.name());
        obj.put((Object)"byColumn", (Object)this.byColumn);
        obj.put((Object)"domainSize", (Object)this.domainSize);
        if (this.byAggregate != null) {
            obj.put((Object)"byAggregate", (Object)this.byAggregate.name());
        }
        return obj;
    }

    public AggregationType getByAggregate() {
        return this.byAggregate;
    }

    public void setByAggregate(AggregationType byAggregate) {
        this.byAggregate = byAggregate;
    }

    @Override
    public FilterType getType() {
        return FilterType.TOP_BOTTOM;
    }

    public String getFilterStringType() {
        if (this.method == TopBottomFilteringMethod.PERCENTAGE && this.topBottomType == TopBottomFilterType.TOP) {
            return "toppercent";
        }
        if (this.method == TopBottomFilteringMethod.PERCENTAGE && this.topBottomType == TopBottomFilterType.BOTTOM) {
            return "bottompercent";
        }
        if (this.method == TopBottomFilteringMethod.COUNT && this.topBottomType == TopBottomFilterType.TOP) {
            return "topcount";
        }
        return "bottomcount";
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TopBottomFilter other = (TopBottomFilter)obj;
        if (this.byAggregate != other.byAggregate) {
            return false;
        }
        if (this.byColumn == null ? other.byColumn != null : !this.byColumn.equals(other.byColumn)) {
            return false;
        }
        if (this.domainSize != other.domainSize) {
            return false;
        }
        if (this.method != other.method) {
            return false;
        }
        return this.topBottomType == other.topBottomType;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.byAggregate == null ? 0 : this.byAggregate.hashCode());
        result = 31 * result + (this.byColumn == null ? 0 : this.byColumn.hashCode());
        result = 31 * result + this.domainSize;
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        result = 31 * result + (this.topBottomType == null ? 0 : this.topBottomType.hashCode());
        return result;
    }
}

