/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.common.util;

import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.util.ColumnInfoUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SampleDataHelper {
    private static final int PERIODIC_CHECK_OVERLAP = 10;
    private static final int ITEM_GROUPING_MIN_VALUE = 2;

    private SampleDataHelper() {
    }

    public static boolean haveOneOneAssociation(ColumnInfo columnOne, ColumnInfo columnTwo, boolean biDirectional) {
        if (!SampleDataHelper.preCheck(columnOne, columnTwo)) {
            return false;
        }
        HashMap<String, String> correlatedVals = new HashMap<String, String>();
        Iterator colOneItr = columnOne.getSamples().iterator();
        Iterator colTwoItr = columnTwo.getSamples().iterator();
        while (colOneItr.hasNext() && colTwoItr.hasNext()) {
            String colOneVal = (String)colOneItr.next();
            String colTwoVal = (String)colTwoItr.next();
            if (colOneVal == null && colTwoVal == null) continue;
            String corrValue = (String)correlatedVals.get(colOneVal);
            if (corrValue == null) {
                if (correlatedVals.values().contains(colTwoVal) && biDirectional) {
                    return false;
                }
                correlatedVals.put(colOneVal, colTwoVal);
                continue;
            }
            if (corrValue.equals(colTwoVal)) continue;
            return false;
        }
        return correlatedVals.keySet().size() >= 2;
    }

    public static boolean haveOneManyAssociation(ColumnInfo columnOne, ColumnInfo columnTwo) {
        if (!SampleDataHelper.preCheck(columnOne, columnTwo)) {
            return false;
        }
        HashMap<String, Set<String>> correlatedValues = new HashMap<String, Set<String>>();
        boolean overlap = SampleDataHelper.collect(columnOne, columnTwo, correlatedValues);
        if (!overlap) {
            overlap = SampleDataHelper.overlap(correlatedValues);
        }
        return !overlap;
    }

    private static boolean collect(ColumnInfo colOne, ColumnInfo colTwo, Map<String, Set<String>> correlatedValues) {
        List colOneSamples = colOne.getSamples();
        Long colOneDistinct = ColumnInfoUtil.getDistinctCount((ColumnInfo)colOne);
        if (colOneDistinct == null || colOneDistinct == 0L) {
            return false;
        }
        int reserverSize = colOneSamples.size() / colOneDistinct.intValue();
        if (reserverSize > 5) {
            reserverSize = 5;
        }
        int counter = 0;
        Iterator colOneItr = colOneSamples.iterator();
        Iterator colTwoItr = colTwo.getSamples().iterator();
        while (colOneItr.hasNext() && colTwoItr.hasNext()) {
            String colOneVal = (String)colOneItr.next();
            String colTwoVal = (String)colTwoItr.next();
            if (colOneVal == null || colTwoVal == null) continue;
            Set<String> colOneCorrVals = correlatedValues.get(colOneVal);
            if (colOneCorrVals == null) {
                colOneCorrVals = new HashSet<String>(reserverSize);
                correlatedValues.put(colOneVal, colOneCorrVals);
            }
            colOneCorrVals.add(colTwoVal);
            if (++counter != 10) continue;
            counter = 0;
            if (!SampleDataHelper.overlap(correlatedValues)) continue;
            return true;
        }
        return false;
    }

    private static boolean overlap(Map<String, Set<String>> correlatedValues) {
        HashSet<String> union = new HashSet<String>();
        for (Map.Entry<String, Set<String>> entry : correlatedValues.entrySet()) {
            for (String val : entry.getValue()) {
                if (union.add(val)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean preCheck(ColumnInfo colOne, ColumnInfo colTwo) {
        List colOneSamples = colOne.getSamples();
        List colTwoSamples = colTwo.getSamples();
        if (colOneSamples.isEmpty() || colTwoSamples.isEmpty()) {
            return false;
        }
        if (colOneSamples.size() != colTwoSamples.size()) {
            return false;
        }
        Long colOneDistinct = ColumnInfoUtil.getDistinctCount((ColumnInfo)colOne);
        Long colTwoDistinct = ColumnInfoUtil.getDistinctCount((ColumnInfo)colTwo);
        return colOneDistinct != null && colOneDistinct != 0L && colTwoDistinct != null && colTwoDistinct != 0L;
    }
}

