/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.common.util;

import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.UseSpecType;
import com.ibm.bi.platform.moser.common.utils.JoinGraph;
import com.ibm.smarts.common.rest.ModuleRestClient;
import com.ibm.smarts.common.rest.SmartsClientManager;
import com.ibm.smarts.core.util.ObjectCreator;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.model.builder.SmartsModuleOptions;
import com.ibm.smarts.model.common.util.ModuleUtil;
import com.ibm.smarts.model.common.util.SmartsModuleBuilder;
import com.ibm.smarts.model.common.util.UniqueNameGenerator;
import com.ibm.smarts.model.common.util.UniqueNameParser;
import com.ibm.smarts.ontology.registry.util.ConceptsUtil;
import com.ibm.smarts.schema.AnalysisStateType;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.BaseObject;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.ItemType;
import com.ibm.smarts.schema.PhraseInfo;
import com.ibm.smarts.schema.SemanticInfo;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.TextInfo;
import com.ibm.smarts.schema.TokenInfo;
import com.ibm.smarts.schema.util.SmartsUtil;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartsModuleUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartsModuleUtil.class);
    public static final String MODULE_KEY = "module";
    public static final String JOIN_GRAPH = "join_graph";

    private SmartsModuleUtil() {
    }

    public static DatasetInfo getDatasetInfo(SmartsModule smartsModule, String datasetId) {
        return smartsModule.getDatasets().stream().filter(d -> d.getId().equals(datasetId)).findFirst().orElse(null);
    }

    public static void clearSamples(SmartsModule smartsModule) {
        smartsModule.getDatasets().forEach(d -> com.ibm.smarts.schema.util.SmartsModuleUtil.getFlattenedColumns((BaseItemObject)d).forEach(c -> c.getSamples().clear()));
    }

    public static Set<String> getJoinedDatasets(RequestContext requestContext, String targetDatasetId, SmartsModule smartsModule) {
        HashSet<String> result = new HashSet<String>();
        result.add(targetDatasetId);
        Module module = SmartsModuleUtil.getModule(requestContext);
        if (module == null) {
            LOGGER.error("could not find joined datasets, missing data module");
            return result;
        }
        result.addAll(SmartsModuleUtil.getJoinedDatasets(targetDatasetId, module));
        return result;
    }

    public static Module getModule(RequestContext requestContext) {
        String moduleUri;
        Object moduleObj = requestContext.getAttribute(MODULE_KEY);
        if (null != moduleObj) {
            try {
                return (Module)moduleObj;
            }
            catch (Exception ex) {
                LOGGER.error("wrong type of module set in request context");
            }
        }
        if (StringUtils.isEmpty((CharSequence)(moduleUri = (String)requestContext.getAttribute("com.ibm.smarts.common.rest.moduleUri")))) {
            LOGGER.error("could not get Module, missing request context attribute com.ibm.smarts.common.rest.moduleUri");
            return null;
        }
        String baseUri = (String)requestContext.getAttribute("com.ibm.smarts.rest.baseUri");
        if (StringUtils.isEmpty((CharSequence)baseUri)) {
            LOGGER.error("could not get Module, missing request context attribute com.ibm.smarts.rest.baseUri");
            return null;
        }
        ObjectCreator clientManagerCreator = (ObjectCreator)requestContext.getRequestAttribute("com.ibm.smarts.rest.clientManager");
        if (clientManagerCreator == null) {
            LOGGER.error("could not get Module, missing request context attribute com.ibm.smarts.rest.clientManager");
            return null;
        }
        SmartsClientManager clientManager = (SmartsClientManager)((Object)clientManagerCreator.create(requestContext));
        if (clientManager == null) {
            LOGGER.error("could not get Module, missing Smarts client manager");
            return null;
        }
        ModuleRestClient moduleClient = clientManager.getModuleClient(baseUri);
        if (moduleClient == null) {
            LOGGER.error("could not get Module, missing data module REST client");
            return null;
        }
        return moduleClient.getModule(moduleUri);
    }

    public static Set<String> getJoinedDatasets(String targetDatasetId, Module module) {
        return SmartsModuleUtil.getJoinedDatasets(targetDatasetId, module, false);
    }

    public static Set<String> getJoinedDatasets(String targetDatasetId, Module module, boolean directJoinsOnly) {
        if (ModuleUtil.isFMPackageModule((Module)module)) {
            String[] parts = targetDatasetId.split("\\.");
            if (parts.length > 0) {
                return ModuleUtil.getQuerySubjectNamesFromNamespace((String)parts[0], (Module)module);
            }
            return Collections.emptySet();
        }
        HashMap adjacents = new HashMap();
        module.getQuerySubject().forEach(qs -> {
            adjacents.putIfAbsent(qs.getIdentifier(), new HashSet());
            ((Set)adjacents.get(qs.getIdentifier())).add(qs.getIdentifier());
        });
        module.getRelationship().forEach(relationship -> {
            String leftId = relationship.getLeft().getRef();
            String rightId = relationship.getRight().getRef();
            adjacents.putIfAbsent(leftId, new HashSet());
            ((Set)adjacents.get(leftId)).add(rightId);
            adjacents.putIfAbsent(rightId, new HashSet());
            ((Set)adjacents.get(rightId)).add(leftId);
        });
        HashMap fmPackageAlias = new HashMap();
        module.getUseSpec().forEach(u -> {
            if (u.getType().equals((Object)UseSpecType.PACKAGE)) {
                fmPackageAlias.compute(u.getStoreID(), (k, v) -> {
                    if (v == null) {
                        v = new HashSet<String>();
                    }
                    String alias = u.getIdentifier().trim();
                    v.add(alias + ".");
                    alias = UniqueNameGenerator.hasOutterBraces((String)alias) ? UniqueNameParser.parserFirstIdentifier((String)alias) : UniqueNameGenerator.createSingleNamePart((String)alias);
                    v.add(alias + ".");
                    return v;
                });
            }
        });
        if (!fmPackageAlias.isEmpty()) {
            HashMap qsByNamespace = new HashMap();
            module.getQuerySubject().forEach(q -> {
                String key = ModuleUtil.getSourceAndNamespace((QuerySubject)q, (Map)fmPackageAlias, (Module)module);
                qsByNamespace.compute(key, (k, v) -> {
                    if (v == null) {
                        v = new HashSet<String>();
                    }
                    v.add(q.getIdentifier());
                    return v;
                });
            });
            qsByNamespace.values().forEach(qsSet -> qsSet.stream().forEach(leftId -> {
                adjacents.putIfAbsent(leftId, new HashSet());
                qsSet.forEach(rightId -> ((Set)adjacents.get(leftId)).add(rightId));
            }));
        }
        HashSet<String> reachable = new HashSet<String>();
        Set adjacentToTarget = (Set)adjacents.get(targetDatasetId);
        if (directJoinsOnly) {
            return adjacentToTarget;
        }
        if (adjacentToTarget != null) {
            LinkedList<String> search = new LinkedList<String>(adjacentToTarget);
            while (search.peek() != null) {
                String next = (String)search.remove();
                boolean visited = !reachable.add(next);
                if (visited || !adjacents.containsKey(next)) continue;
                for (String adjacent : (Set)adjacents.get(next)) {
                    search.add(adjacent);
                }
            }
        }
        return reachable;
    }

    @Deprecated
    public static boolean isJoinedDatasets(RequestContext requestContext, Set<String> targetDatasetIds, SmartsModule smartsModule) {
        if (targetDatasetIds == null || targetDatasetIds.isEmpty()) {
            return false;
        }
        List datasets = smartsModule.getDatasets().stream().filter(ds -> targetDatasetIds.contains(ds.getIdForExpression())).collect(Collectors.toList());
        if (!datasets.isEmpty() && datasets.stream().allMatch(ds -> com.ibm.smarts.schema.util.SmartsModuleUtil.isDimension((DatasetInfo)ds))) {
            return true;
        }
        String anyTargetDataset = targetDatasetIds.iterator().next();
        Set<String> joinedDatasets = SmartsModuleUtil.getJoinedDatasets(requestContext, anyTargetDataset, smartsModule);
        return joinedDatasets.containsAll(targetDatasetIds);
    }

    public static boolean isJoinedGraph(JoinGraph joinGraph, List<String> columnIds) {
        if (columnIds == null || columnIds.isEmpty() || columnIds.stream().anyMatch(c -> StringUtils.isBlank((CharSequence)c))) {
            return false;
        }
        try {
            return !SmartsModuleUtil.getRelatedColumnIds(joinGraph, columnIds).isEmpty();
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("error getting related columns for: {}", columnIds, (Object)e);
            return false;
        }
    }

    @Deprecated
    public static boolean isJoinedDatasets(Set<String> targetDatasetIds, Module module) {
        if (targetDatasetIds == null || targetDatasetIds.isEmpty()) {
            return false;
        }
        List querySubjects = module.getQuerySubject().stream().filter(qs -> targetDatasetIds.contains(qs.getIdForExpression())).collect(Collectors.toList());
        if (!querySubjects.isEmpty() && querySubjects.stream().allMatch(qs -> ModuleUtil.isDimension((QuerySubject)qs))) {
            return true;
        }
        String anyTargetDataset = targetDatasetIds.iterator().next();
        Set<String> joinedDatasets = SmartsModuleUtil.getJoinedDatasets(anyTargetDataset, module);
        return joinedDatasets.containsAll(targetDatasetIds);
    }

    public static Set<String> getSmartModuleKeywords(List<DatasetInfo> dataSets) {
        HashSet<String> keywords = new HashSet<String>();
        for (DatasetInfo datasetInfo : dataSets) {
            TextInfo datasetLabel = datasetInfo.getLabel();
            if (datasetLabel != null) {
                SmartsModuleUtil.collectKeywordsFromLabelPhrases(keywords, datasetLabel.getPhrases());
            }
            SmartsModuleUtil.collectKeywordsFromSemanticInfo(keywords, com.ibm.smarts.schema.util.SmartsModuleUtil.getFlattenedColumns((BaseItemObject)datasetInfo));
        }
        return keywords;
    }

    private static void collectKeywordsFromLabelPhrases(Set<String> keywords, List<PhraseInfo> phraseInfoList) {
        List<String> keywordPOSAcronym = Arrays.asList("NP", "WHNP", "CD", "NN", "NNS", "NNP", "NNPS", "PRP$", "WP", "WP$", "VP", "VB", "VBD", "VBG", "VBN", "VBP", "VBZ", "ADJP", "WHADJP", "JJ", "JJR", "JJS", "ADVP", "WHADVP", "RB", "RBR", "RBS", "WRB");
        if (phraseInfoList != null) {
            phraseInfoList.forEach(phInfo -> {
                List tokenInfoList = phInfo.getTokens();
                Set kw = tokenInfoList.stream().filter(t -> keywordPOSAcronym.contains(t.getPOSlocal())).map(TokenInfo::getText).collect(Collectors.toSet());
                keywords.addAll(kw);
            });
        }
    }

    public static String parseDatasetIdFromIdForExpression(String idForExpression) {
        int idx = idForExpression.lastIndexOf(".");
        if (idx <= 0) {
            return null;
        }
        return idForExpression.substring(0, idx);
    }

    public static Module shrinkWrapModule(Module module, String datasetId) {
        if (module == null || datasetId == null || datasetId.isEmpty()) {
            return module;
        }
        Set<String> joinedDatasets = SmartsModuleUtil.getJoinedDatasets(datasetId, module);
        return SmartsModuleUtil.shrinkWrapModule(module, joinedDatasets);
    }

    public static Module shrinkWrapModuleMultiTableInput(Module module, Set<String> querySubjects, boolean directJoinsOnly) {
        if (module == null || querySubjects == null || querySubjects.isEmpty()) {
            return module;
        }
        HashSet<String> joinedDatasets = new HashSet<String>();
        for (String qsId : querySubjects) {
            joinedDatasets.addAll(SmartsModuleUtil.getJoinedDatasets(qsId, module, directJoinsOnly));
        }
        return SmartsModuleUtil.shrinkWrapModule(module, joinedDatasets);
    }

    public static Module shrinkWrapModule(Module module, Set<String> joinedDatasets) {
        if (module == null || joinedDatasets == null || joinedDatasets.isEmpty()) {
            return module;
        }
        Module newModule = SmartsModuleUtil.initializeShrinkWrappedModule(module);
        for (QuerySubject qs : module.getQuerySubject()) {
            if (!joinedDatasets.contains(qs.getIdentifier())) continue;
            newModule.getQuerySubject().add(qs);
        }
        if (newModule.getQuerySubject().isEmpty()) {
            return module;
        }
        return newModule;
    }

    public static Module initializeShrinkWrappedModule(Module module) {
        Module newModule = new Module();
        newModule.setIdentifier(module.getIdentifier());
        newModule.setLabel(module.getLabel());
        newModule.setContainer(module.getContainer());
        newModule.setExpressionLocale(module.getExpressionLocale());
        newModule.setDataRetrievalMode(module.getDataRetrievalMode());
        newModule.getRelationship().addAll(module.getRelationship());
        newModule.getUseSpec().addAll(module.getUseSpec());
        newModule.getCalculation().addAll(module.getCalculation());
        newModule.getNamedSet().addAll(module.getNamedSet());
        return newModule;
    }

    public static boolean isDone(SmartsModule smartsModule) {
        if (smartsModule == null) {
            return false;
        }
        return smartsModule.getAnalysisState() != null && smartsModule.getAnalysisState().equals((Object)AnalysisStateType.DONE);
    }

    private static void collectKeywordsFromSemanticInfo(Set<String> keywords, List<ColumnInfo> columnInfoList) {
        if (columnInfoList != null) {
            columnInfoList.forEach(colInfo -> {
                SemanticInfo semanticInfo;
                TextInfo colLabel = colInfo.getLabel();
                if (colLabel != null) {
                    SmartsModuleUtil.collectKeywordsFromLabelPhrases(keywords, colLabel.getPhrases());
                }
                if ((semanticInfo = colInfo.getSemanticInfo()) != null) {
                    List conceptInfoList = semanticInfo.getConcepts();
                    conceptInfoList.forEach(conceptInfo -> {
                        if (ConceptsUtil.getOntologyId((ConceptInfo)conceptInfo).equals("http://www.ibm.com/ontologies/waca/domain/common")) {
                            switch (conceptInfo.getConceptID()) {
                                case "http://www.ibm.com/ontologies/waca/domain/common#Entity": 
                                case "http://www.ibm.com/ontologies/waca/domain/common#Identifier": 
                                case "http://www.ibm.com/ontologies/waca/domain/common#Measure": {
                                    break;
                                }
                                default: {
                                    keywords.add(ConceptsUtil.getConceptName((ConceptInfo)conceptInfo));
                                }
                            }
                        }
                    });
                }
            });
        }
    }

    public static void filter(SmartsModule smartsModule, Module module) {
        Set<String> validIds;
        SmartsModuleBuilder smBuilder = new SmartsModuleBuilder();
        SmartsModule userView = smBuilder.buildFromModule("", module, Collections.emptySet());
        Set userViewDatasets = userView.getDatasets().stream().map(BaseObject::getId).collect(Collectors.toSet());
        smartsModule.getDatasets().removeIf(d -> !userViewDatasets.contains(d.getId()));
        smartsModule.getDatasets().forEach(ds -> {
            DatasetInfo userViewDataset = userView.getDatasets().stream().filter(v -> v.getId().equals(ds.getId())).findFirst().orElse(null);
            if (userViewDataset != null) {
                Set<String> validIds = com.ibm.smarts.schema.util.SmartsModuleUtil.getFlattenedColumns((BaseItemObject)userViewDataset).stream().map(BaseObject::getIdForExpression).collect(Collectors.toSet());
                SmartsModuleUtil.filter(ds.getItem(), validIds);
            }
        });
        if (userView.getCalculations() != null) {
            validIds = com.ibm.smarts.schema.util.SmartsModuleUtil.getFlattenedColumns((BaseItemObject)userView.getCalculations()).stream().map(BaseObject::getIdForExpression).collect(Collectors.toSet());
            if (smartsModule.getCalculations() != null) {
                SmartsModuleUtil.filter(smartsModule.getCalculations().getItem(), validIds);
            }
        } else {
            smartsModule.setCalculations(null);
        }
        if (userView.getNamedSets() != null) {
            validIds = com.ibm.smarts.schema.util.SmartsModuleUtil.getFlattenedColumns((BaseItemObject)userView.getNamedSets()).stream().map(BaseObject::getIdForExpression).collect(Collectors.toSet());
            if (smartsModule.getNamedSets() != null) {
                SmartsModuleUtil.filter(smartsModule.getNamedSets().getItem(), validIds);
            }
        } else {
            smartsModule.setNamedSets(null);
        }
    }

    private static void filter(List<ItemType> items, Set<String> validIds) {
        items.removeIf(i -> i.getColumn() != null && !validIds.contains(i.getColumn().getIdForExpression()));
        items.stream().filter(i -> i.getFolder() != null).forEach(i -> SmartsModuleUtil.filter(i.getFolder().getItem(), validIds));
    }

    public static List<String> getRelatedFieldsFromJoinGraph(RequestContext requestContext, String targetFieldId, String moduleId) {
        Optional<JoinGraph> joinGraph = SmartsModuleUtil.getJoinGraph(requestContext, moduleId);
        if (joinGraph.isPresent()) {
            return SmartsModuleUtil.getRelatedColumnIds(joinGraph.get(), Arrays.asList(targetFieldId));
        }
        return Collections.emptyList();
    }

    public static Module shrinkWrapModuleColumnInput(RequestContext requestContext, String moduleId, Module module, List<String> columnIds) {
        if (module == null || columnIds == null || columnIds.isEmpty()) {
            return module;
        }
        Optional<JoinGraph> joinGraph = SmartsModuleUtil.getJoinGraph(requestContext, moduleId);
        if (joinGraph.isPresent()) {
            Set<String> joinedDatasets = SmartsModuleUtil.getJoinGraphDatasets(joinGraph.get(), columnIds);
            module = SmartsModuleUtil.shrinkWrapModule(module, joinedDatasets);
        }
        return module;
    }

    public static Optional<JoinGraph> getJoinGraph(RequestContext requestContext, String moduleId) {
        JoinGraph jGraph = (JoinGraph)requestContext.getRequestAttribute(JOIN_GRAPH);
        if (jGraph != null) {
            return Optional.of(jGraph);
        }
        Optional<JoinGraph> joinGraph = Optional.empty();
        if (StringUtils.isBlank((CharSequence)moduleId)) {
            return joinGraph;
        }
        String baseUri = (String)requestContext.getAttribute("com.ibm.smarts.rest.baseUri");
        if (StringUtils.isEmpty((CharSequence)baseUri)) {
            LOGGER.error("could not get join graph, missing request context attribute com.ibm.smarts.rest.baseUri");
            return joinGraph;
        }
        ObjectCreator clientManagerCreator = (ObjectCreator)requestContext.getRequestAttribute("com.ibm.smarts.rest.clientManager");
        if (clientManagerCreator == null) {
            LOGGER.error("could not get join graph, missing request context attribute com.ibm.smarts.rest.clientManager");
            return joinGraph;
        }
        SmartsClientManager clientManager = (SmartsClientManager)((Object)clientManagerCreator.create(requestContext));
        if (clientManager == null) {
            LOGGER.error("could not get join graph, missing Smarts client manager");
            return joinGraph;
        }
        ModuleRestClient client = clientManager.getModuleClient(baseUri);
        if (client == null) {
            LOGGER.error("could not get join graph, missing module REST client");
            return joinGraph;
        }
        try {
            jGraph = client.getModuleJoinGraph(moduleId);
            requestContext.setRequestAttribute(JOIN_GRAPH, (Object)jGraph);
            joinGraph = Optional.of(jGraph);
        }
        catch (Exception e) {
            LOGGER.error("could not parse join graph", (Object)e.getMessage());
        }
        return joinGraph;
    }

    public static Set<String> getJoinGraphDatasets(JoinGraph joinGraph, List<String> columnIds) {
        if (joinGraph == null) {
            return Collections.emptySet();
        }
        List<String> relatedColumnIds = SmartsModuleUtil.getRelatedColumnIds(joinGraph, columnIds);
        Set<String> joinedDatasets = SmartsModuleUtil.getDatasets(relatedColumnIds);
        LOGGER.info("Joined datasets: " + joinedDatasets);
        return joinedDatasets;
    }

    public static List<String> getRelatedColumnIds(JoinGraph joinGraph, List<String> columnIds) {
        if (joinGraph == null) {
            return Collections.emptyList();
        }
        Instant start = Instant.now();
        LOGGER.info("JoinGraph::getRelated called with column ids: " + columnIds);
        List relatedColumnIds = joinGraph.getRelated(columnIds);
        LOGGER.info("JoinGraph::getRelated returns related column ids: " + relatedColumnIds);
        LOGGER.info(String.format("JoinGraph::getRelated takes %s ms", Duration.between(start, Instant.now()).toMillis()));
        return relatedColumnIds;
    }

    private static Set<String> getDatasets(List<String> columnIds) {
        return columnIds.stream().map(SmartsModuleUtil::parseDatasetIdFromIdForExpression).collect(Collectors.toSet());
    }

    public static Set<String> getJoinedDatasets(RequestContext requestContext, String moduleId, String targetColumnId) {
        Optional<JoinGraph> joinGraph = SmartsModuleUtil.getJoinGraph(requestContext, moduleId);
        if (!joinGraph.isPresent()) {
            return SmartsModuleUtil.getSetWithColumnDataset(targetColumnId);
        }
        return SmartsModuleUtil.getJoinedDatasets(joinGraph.get(), targetColumnId);
    }

    public static Set<String> getJoinedDatasets(JoinGraph joinGraph, String targetColumnId) {
        Set<String> joinedDatasets = SmartsModuleUtil.getSetWithColumnDataset(targetColumnId);
        if (joinGraph == null) {
            LOGGER.error("No join graph provided.");
            return joinedDatasets;
        }
        Set<String> joinGraphDatasets = SmartsModuleUtil.getJoinGraphDatasets(joinGraph, Arrays.asList(targetColumnId));
        joinedDatasets.addAll(joinGraphDatasets);
        return joinedDatasets;
    }

    private static Set<String> getSetWithColumnDataset(String targetColumnId) {
        String targetDatasetId = SmartsModuleUtil.parseDatasetIdFromIdForExpression(targetColumnId);
        return targetDatasetId != null ? new HashSet<String>(Collections.singletonList(targetDatasetId)) : new HashSet();
    }

    public static SmartsModule shrinkSmartsModule(SmartsModule smartsModule, List<String> tags) throws CloneNotSupportedException {
        SmartsModule result = (SmartsModule)smartsModule.clone();
        HashSet<String> datasetName = new HashSet<String>(tags);
        result.getDatasets().removeIf(datasetInfo -> !datasetName.contains(datasetInfo.getId()));
        result.setAnalysisState(SmartsUtil.calculateState((SmartsModule)smartsModule));
        return result;
    }

    public static Map<String, Set<String>> getJoinableColumns(RequestContext requestContext, String effectiveModuleId, List<String> requestedColumnIds) {
        Optional joinGraphOptional;
        Optional<Object> optional = joinGraphOptional = StringUtils.isBlank((CharSequence)effectiveModuleId) ? Optional.empty() : SmartsModuleUtil.getJoinGraph(requestContext, effectiveModuleId);
        if (joinGraphOptional.isPresent()) {
            JoinGraph joinGraph = (JoinGraph)joinGraphOptional.get();
            return SmartsModuleUtil.getJoinableColumns(joinGraph, requestedColumnIds);
        }
        return Collections.emptyMap();
    }

    public static Map<String, Set<String>> getJoinableColumns(JoinGraph joinGraph, List<String> requestedColumnIds) {
        HashMap<String, Set<String>> joinableColumnIds = new HashMap<String, Set<String>>();
        for (String columnId : requestedColumnIds) {
            ArrayList<String> columnIds = new ArrayList<String>();
            columnIds.add(columnId);
            List<String> relatedColumnIds = SmartsModuleUtil.getRelatedColumnIds(joinGraph, columnIds);
            joinableColumnIds.put(columnId, relatedColumnIds.stream().collect(Collectors.toSet()));
        }
        return joinableColumnIds;
    }

    public static SmartsModuleOptions createSmartsModuleOptionsWithBivariates() {
        return new SmartsModuleOptions.SmartsModuleOptionsBuilder().addBivariates(true).build();
    }
}

