/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.fields.recommender.core;

import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.ontology.util.Pair;
import com.ibm.smarts.schema.AnalysisScope;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.BivariateStatistics;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.FieldsRecommendation;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class BaseFieldsAnalysisContext {
    protected final RequestContext requestContext;
    protected final SmartsModule smartsModule;
    private final AnalysisScope analysisScope;
    private final Map<String, Map<Pair<String, String>, BivariateStatistics>> bivariatesMap;
    protected final Set<String> scopedTableIDFilter;
    protected final Set<String> scopedFieldIDFilter;
    protected final Map<String, Column> allFieldsMap;
    protected Set<String> joinableDatasets;
    protected Map<String, Column> relatedFieldsMap;
    protected FieldsRecommendation fieldsRecommendation;
    protected float semanticDelta = 0.8f;
    protected float semanticRelavenceThreshold = 0.3f;
    protected float correlationUpperLimit = 0.85f;
    protected float correlationLowerLimit = 0.04f;
    protected boolean allowCategoryTarget = false;
    protected boolean includeCorrelatedMeasure = true;
    protected boolean noCorrelationLimit = false;

    protected BaseFieldsAnalysisContext(RequestContext reqCtx, SmartsModule sModule, AnalysisScope scope, Map<String, Map<Pair<String, String>, BivariateStatistics>> bivariatesMap) {
        this.requestContext = reqCtx;
        this.smartsModule = sModule;
        this.analysisScope = scope;
        this.scopedTableIDFilter = new HashSet<String>(0);
        this.scopedFieldIDFilter = new HashSet<String>(0);
        this.joinableDatasets = new HashSet<String>(0);
        this.relatedFieldsMap = new HashMap<String, Column>(0);
        this.allFieldsMap = this.initilizeAllFieldsMap(sModule);
        this.bivariatesMap = bivariatesMap != null ? bivariatesMap : new HashMap<String, Map<Pair<String, String>, BivariateStatistics>>(sModule.getDatasets().size());
    }

    private Map<String, Column> initilizeAllFieldsMap(SmartsModule sModule) {
        HashMap<String, Column> fieldsMap = new HashMap<String, Column>();
        sModule.getDatasets().forEach(ds -> SmartsModuleUtil.getFlattenedColumns((BaseItemObject)ds).forEach(col -> fieldsMap.put(col.getIdForExpression(), new Column(ds.getId(), (ColumnInfo)col))));
        return fieldsMap;
    }

    public Map<String, Column> getAllFieldsMap() {
        return this.allFieldsMap;
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    public Set<String> getScopedTableIDFilter() {
        return this.scopedTableIDFilter;
    }

    public Set<String> getScopedFieldIDFilter() {
        return this.scopedFieldIDFilter;
    }

    public Map<String, Column> getRelatedFieldsMap() {
        return this.relatedFieldsMap;
    }

    public SmartsModule getSmartsModule() {
        return this.smartsModule;
    }

    public AnalysisScope getAnalysisScope() {
        return this.analysisScope;
    }

    public boolean hasScopedFields() {
        return this.analysisScope != null && this.analysisScope.getInScopeTables() != null && !this.analysisScope.getInScopeTables().isEmpty();
    }

    public boolean isInScope(String dID, String fieldUID, ColumnInfo col) {
        if (this.relatedFieldsMap.isEmpty()) {
            if (this.scopedFieldIDFilter.isEmpty()) {
                return this.joinableDatasets.contains(dID);
            }
            return this.scopedFieldIDFilter.contains(fieldUID);
        }
        if (this.relatedFieldsMap.containsKey(col.getIdForExpression())) {
            if (this.scopedFieldIDFilter.isEmpty()) {
                return true;
            }
            return this.scopedFieldIDFilter.contains(fieldUID);
        }
        return false;
    }

    public Set<String> getJoinableDatasets() {
        return this.joinableDatasets;
    }

    public FieldsRecommendation getFieldsRecommendation() {
        return this.fieldsRecommendation;
    }

    public float getSemanticDelta() {
        return this.semanticDelta;
    }

    public void setsSmanticDelta(float sd) {
        this.semanticDelta = sd;
    }

    public boolean isIncludeCorrelatedMeasure() {
        return this.includeCorrelatedMeasure;
    }

    public void setIncludeCorrelatedMeasure(boolean includeCorrelatedMeasure) {
        this.includeCorrelatedMeasure = includeCorrelatedMeasure;
    }

    public float getSemanticRelavenceThreshold() {
        return this.semanticRelavenceThreshold;
    }

    public void setSemanticRelavenceThreshold(float threshold) {
        this.semanticRelavenceThreshold = threshold;
    }

    public boolean isAllowCategoryTarget() {
        return this.allowCategoryTarget;
    }

    public void setAllowCategoryTarget(boolean allowCategoryTarget) {
        this.allowCategoryTarget = allowCategoryTarget;
    }

    public float getCorrelationLowerLimit() {
        return this.correlationLowerLimit;
    }

    public void setCorrelationLowerLimit(float correlationLowerLimit) {
        this.correlationLowerLimit = correlationLowerLimit;
    }

    public float getCorrelationUpperLimit() {
        return this.correlationUpperLimit;
    }

    public void setCorrelationUpperLimit(float correlationUpperLimit) {
        this.correlationUpperLimit = correlationUpperLimit;
    }

    public boolean hasNoCorrelationLimit() {
        return this.noCorrelationLimit;
    }

    public void setNoCorrelationLimit(boolean noCorrelationLimit) {
        this.noCorrelationLimit = noCorrelationLimit;
    }

    void cacheBVs(String tableID, Map<Pair<String, String>, BivariateStatistics> bvMap) {
        this.bivariatesMap.put(tableID, bvMap);
    }

    Map<Pair<String, String>, BivariateStatistics> getBivariateMap(String dsID) {
        return this.bivariatesMap.get(dsID);
    }

    protected static class Column {
        private String datasetID;
        private ColumnInfo columnInfo;

        public Column(String dID, ColumnInfo col) {
            this.datasetID = dID;
            this.columnInfo = col;
        }

        public String getDatasetID() {
            return this.datasetID;
        }

        public ColumnInfo getColumnInfo() {
            return this.columnInfo;
        }
    }
}

