/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.fields.recommender.core.autosuggest;

import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.FieldRecommendationRecord;
import com.ibm.smarts.schema.FieldsRecommendation;
import com.ibm.smarts.schema.FieldsRecommendationType;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.Builder;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import java.util.LinkedList;
import java.util.List;

public class FieldsDiscoverer {
    public FieldsRecommendation recommend(RequestContext reqCtx, SmartsModule smartsModule) {
        FieldsRecommendation recommendation = (FieldsRecommendation)Builder.create(FieldsRecommendation.class).with(fr -> fr.setType(FieldsRecommendationType.FULL)).build();
        LinkedList records = new LinkedList();
        smartsModule.getDatasets().forEach(ds -> this.collecFields(records, SmartsModuleUtil.getFlattenedColumns((BaseItemObject)ds), ds.getId()));
        recommendation.getRecommendedFields().addAll(records);
        return recommendation;
    }

    private void collecFields(List<FieldRecommendationRecord> records, List<ColumnInfo> columns, String tableId) {
        columns.forEach(col -> records.add((FieldRecommendationRecord)Builder.create(FieldRecommendationRecord.class).with(frr -> frr.setFieldID(col.getId())).with(frr -> frr.setFieldName(col.getName())).with(frr -> frr.setFieldIDForExpression(col.getIdForExpression())).with(frr -> frr.setTableID(tableId)).with(frr -> frr.setConfidence(1.0f)).build()));
    }
}

