/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.fields.recommender.core.influencers;

import com.ibm.smarts.fields.recommender.core.FieldInsightsDiscoverer;
import com.ibm.smarts.fields.recommender.core.influencers.Ensemble;
import com.ibm.smarts.fields.recommender.core.influencers.IndirectInfluentialRelationshipDiscovery;
import com.ibm.smarts.fields.recommender.core.influencers.InfluencersAnalysisContext;
import com.ibm.smarts.fields.recommender.core.influencers.InfluencersCandidateCollection;
import com.ibm.smarts.fields.recommender.core.influencers.InfluencersDiscoveryPipeline;
import com.ibm.smarts.fields.recommender.core.influencers.InfluencersInputScopeValidation;
import com.ibm.smarts.fields.recommender.core.influencers.InfluentialRelationshipDiscovery;
import com.ibm.smarts.fields.recommender.core.influencers.NumericMetadataEvaluation;
import com.ibm.smarts.ontology.service.KnowledgeDiscoveryService;
import com.ibm.smarts.schema.FieldsRecommendation;
import java.time.Duration;
import java.time.Instant;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluencersDiscoverer
implements FieldInsightsDiscoverer<InfluencersAnalysisContext, FieldsRecommendation> {
    private final KnowledgeDiscoveryService kds;
    private final InfluencersDiscoveryPipeline pipeline;
    private static final Logger LOGGER = LoggerFactory.getLogger(InfluencersDiscoverer.class);

    public InfluencersDiscoverer(KnowledgeDiscoveryService kds) {
        this.kds = kds;
        this.pipeline = this.constructPipeline();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldsRecommendation recommend(@Nonnull InfluencersAnalysisContext rfac) {
        Instant before = Instant.now();
        try {
            this.pipeline.getIterator().forEachRemaining(step -> {
                Instant b = Instant.now();
                if (rfac.canContinue()) {
                    step.execute(rfac);
                }
                LOGGER.warn(String.format("%s step took [%s]ms", step.getName(), Duration.between(b, Instant.now()).toMillis()));
            });
            LOGGER.warn(String.format("** Influencers recommendation took [%s]ms", Duration.between(before, Instant.now()).toMillis()));
            FieldsRecommendation fieldsRecommendation = rfac.getFieldsRecommendation();
            return fieldsRecommendation;
        }
        finally {
            rfac.dispose();
        }
    }

    private InfluencersDiscoveryPipeline constructPipeline() {
        InfluencersDiscoveryPipeline pl = new InfluencersDiscoveryPipeline();
        pl.register(new InfluencersInputScopeValidation());
        pl.register(new InfluentialRelationshipDiscovery(this.kds));
        pl.register(new IndirectInfluentialRelationshipDiscovery(this.kds));
        pl.register(new InfluencersCandidateCollection());
        pl.register(new NumericMetadataEvaluation());
        pl.register(new Ensemble());
        return pl;
    }
}

