/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.fields.recommender.core.targets;

import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.fields.recommender.core.BaseFieldsAnalysisContext;
import com.ibm.smarts.ontology.registry.util.ConceptsUtil;
import com.ibm.smarts.ontology.util.Pair;
import com.ibm.smarts.schema.AnalysisScope;
import com.ibm.smarts.schema.BivariateStatistics;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.FieldsRecommendation;
import com.ibm.smarts.schema.SmartsModule;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;

public class TargetsAnalysisContext
extends BaseFieldsAnalysisContext {
    private Map<String, TargetCandidate> targetCandiatesMap = new HashMap<String, TargetCandidate>(0);

    public TargetsAnalysisContext(RequestContext reqCtx, SmartsModule sModule, AnalysisScope scope, Map<String, Map<Pair<String, String>, BivariateStatistics>> bivariatesMap) {
        super(reqCtx, sModule, scope, bivariatesMap);
    }

    Map<String, TargetCandidate> getTargetCandiatesMap() {
        return this.targetCandiatesMap;
    }

    Collection<TargetCandidate> getTargetCandidates() {
        return this.targetCandiatesMap.values();
    }

    void addTargetCandidate(ColumnInfo col, String fieldUID, String dsID) {
        this.targetCandiatesMap.put(fieldUID, new TargetCandidate(col, dsID));
    }

    void dispose() {
        this.targetCandiatesMap.clear();
        this.scopedTableIDFilter.clear();
        this.scopedFieldIDFilter.clear();
    }

    void setRecommenddation(FieldsRecommendation recommendation) {
        this.fieldsRecommendation = recommendation;
    }

    static class TargetCandidate {
        private ColumnInfo field;
        private String tableID;
        private float conceptScore;
        private float statsScore;
        private float confidence;
        private AtomicInteger counter = new AtomicInteger();

        TargetCandidate(ColumnInfo col, String dsID) {
            this.field = col;
            this.tableID = dsID;
            Optional<ConceptInfo> concept = col.getSemanticInfo().getConcepts().stream().filter(c -> ConceptsUtil.getOntologyId((ConceptInfo)c).equals("http://www.ibm.com/ontologies/waca/domain/common")).max(Comparator.comparing(ConceptInfo::getConfidence));
            this.conceptScore = concept.map(ConceptInfo::getConfidence).orElse(Float.valueOf(0.0f)).floatValue();
        }

        String getTableID() {
            return this.tableID;
        }

        float getConceptScore() {
            return this.conceptScore;
        }

        void setConceptScore(float conceptScore) {
            this.conceptScore = conceptScore;
        }

        float getStatsScore() {
            return this.statsScore;
        }

        void setStatsScore(float statsScore) {
            this.statsScore = statsScore;
        }

        float getConfidence() {
            return this.confidence;
        }

        void setConfidence(float confidence) {
            this.confidence = confidence;
        }

        ColumnInfo getField() {
            return this.field;
        }

        void setField(ColumnInfo field) {
            this.field = field;
        }

        public String toString() {
            return "TargetCandidate [field=" + this.field.getId() + ", conceptScore=" + this.conceptScore + ", statsScore=" + this.statsScore + ", confidence=" + this.confidence + "]";
        }

        public AtomicInteger getCounter() {
            return this.counter;
        }

        public void setCounter(AtomicInteger counter) {
            this.counter = counter;
        }
    }
}

