/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.misc;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.misc.CAMCryptoUtilities;
import com.cognos.accman.jcam.crypto.misc.IPFTraceLogger;
import com.cognos.accman.res.MessageSet;

public class EncodedCSK_HMAC_Digest2 {
    private final byte VERSION = (byte)2;
    private byte version;
    private byte[] cskDigest;
    private byte[] hmacAlgorithm;
    private byte[] hmacDigest;
    static IPFTraceLogger cskTraceLogger = new IPFTraceLogger("Trace.CAM.JCAM.KeyManagement.CSK");

    public EncodedCSK_HMAC_Digest2(byte[] cskDigest, byte[] hmacAlgorithm, byte[] hmacDigest) throws CAMCryptoException {
        cskTraceLogger.logEnter();
        cskTraceLogger.trace("cskDigest = " + IPFTraceLogger.toBase64String(cskDigest));
        cskTraceLogger.trace("algorithm = " + IPFTraceLogger.toBase64String(hmacAlgorithm));
        cskTraceLogger.trace("hmacDigest = " + IPFTraceLogger.toBase64String(hmacDigest));
        this.cskDigest = cskDigest;
        this.hmacAlgorithm = hmacAlgorithm;
        this.hmacDigest = hmacDigest;
        cskTraceLogger.logExit(true);
    }

    public EncodedCSK_HMAC_Digest2(byte[] encodedCSK_HMAC_Digest, int expectedHMACDigestLength) throws CAMCryptoException {
        cskTraceLogger.logEnter();
        cskTraceLogger.trace("encodedCSK_HMAC_Digest = " + IPFTraceLogger.toBase64String(encodedCSK_HMAC_Digest));
        cskTraceLogger.trace("expectedHMACDigestLength = " + expectedHMACDigestLength);
        this.decodeHMACDigest(encodedCSK_HMAC_Digest, expectedHMACDigestLength);
        cskTraceLogger.logExit(true);
    }

    public byte getVersion() {
        return this.version;
    }

    public byte[] getEncodedHMACDigest() throws CAMCryptoException {
        return this.encodeHMACDigest();
    }

    public byte[] getCSKDigest() {
        return this.cskDigest;
    }

    public byte[] getAlgorithm() {
        return this.hmacAlgorithm;
    }

    public byte[] getHMACDigest() {
        return this.hmacDigest;
    }

    private byte[] encodeHMACDigest() throws CAMCryptoException {
        cskTraceLogger.logEnter();
        int cskDigestLength = CAMCryptoUtilities.getCSKDigestLength();
        int tokenLength = 5 + cskDigestLength + 4 + this.hmacAlgorithm.length + 4 + this.hmacDigest.length;
        byte[] encodedHmac = new byte[tokenLength];
        int i = 0;
        encodedHmac[i] = 2;
        ++i;
        for (int j = 0; j < 4; ++j) {
            encodedHmac[i] = (byte)(cskDigestLength >> 8 * j & 0xFF);
            ++i;
        }
        System.arraycopy(this.cskDigest, 0, encodedHmac, i, cskDigestLength);
        i += cskDigestLength;
        int algorithmLength = this.hmacAlgorithm.length;
        for (int j = 0; j < 4; ++j) {
            encodedHmac[i] = (byte)(algorithmLength >> 8 * j & 0xFF);
            ++i;
        }
        System.arraycopy(this.hmacAlgorithm, 0, encodedHmac, i, algorithmLength);
        i += algorithmLength;
        int hmacLength = this.hmacDigest.length;
        for (int j = 0; j < 4; ++j) {
            encodedHmac[i] = (byte)(hmacLength >> 8 * j & 0xFF);
            ++i;
        }
        System.arraycopy(this.hmacDigest, 0, encodedHmac, i, hmacLength);
        cskTraceLogger.logExit(true);
        return encodedHmac;
    }

    private void decodeHMACDigest(byte[] encodedDigest, int expectedHMACDigestLength) throws CAMCryptoException {
        cskTraceLogger.logEnter();
        cskTraceLogger.trace("encodedDigest = " + IPFTraceLogger.toBase64String(encodedDigest));
        cskTraceLogger.trace("expectedHMACDigestLength = " + expectedHMACDigestLength);
        if (encodedDigest.length < 4) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_gen_HMAC"));
        }
        this.version = encodedDigest[0];
        int i = 1;
        int cskDigestLength = 0;
        for (int j = 0; j < 4; ++j) {
            cskDigestLength |= encodedDigest[i] << j * 8;
            ++i;
        }
        this.cskDigest = new byte[cskDigestLength];
        System.arraycopy(encodedDigest, i, this.cskDigest, 0, cskDigestLength);
        i += cskDigestLength;
        int algorithmLength = 0;
        for (int j = 0; j < 4; ++j) {
            algorithmLength |= encodedDigest[i] << j * 8;
            ++i;
        }
        this.hmacAlgorithm = new byte[algorithmLength];
        System.arraycopy(encodedDigest, i, this.hmacAlgorithm, 0, algorithmLength);
        i += algorithmLength;
        int hmacLength = 0;
        for (int j = 0; j < 4; ++j) {
            hmacLength |= encodedDigest[i] << j * 8;
            ++i;
        }
        this.hmacDigest = new byte[hmacLength];
        System.arraycopy(encodedDigest, i, this.hmacDigest, 0, hmacLength);
        cskTraceLogger.trace("hmacDigest = " + new String(this.hmacDigest));
        cskTraceLogger.logExit(true);
    }
}

