/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.question.generator.builder.tasks;

import com.ibm.smarts.common.mq.function.SmartsModulePublishUtil;
import com.ibm.smarts.common.pipeline.SmartsTaskContext;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.logging.PerformanceLogger;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.model.builder.QGEncodedSamplesContainer;
import com.ibm.smarts.model.qg.Question;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.store.api.provider.IObjectStore;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuestionsTaskImpl {
    private final Logger LOGGER = LoggerFactory.getLogger(QuestionsTaskImpl.class);

    public void execute(SmartsTaskContext taskContext) {
        String moduleId = taskContext.getSmartsModuleId();
        PerformanceLogger.get().info((Object)moduleId);
        IStoreProvider storeProvider = taskContext.getStoreProvider();
        RequestContext requestContext = taskContext.getRequestContext();
        SmartsModule smartsModule = storeProvider.getModuleStore(requestContext).getById(moduleId);
        List<Question> questions = this.getQuestions(storeProvider, smartsModule);
        SmartsModulePublishUtil.publishQuestions((RequestContext)requestContext, (IStoreProvider)storeProvider, (String)moduleId, (SmartsModule)smartsModule, questions);
        PerformanceLogger.get().info((Object)(moduleId + "#" + smartsModule.getName()));
    }

    private List<Question> getQuestions(IStoreProvider storeProvider, SmartsModule smartsModule) {
        ArrayList unifiedQGEncodedSamples = new ArrayList();
        IObjectStore qgEncodedSamplesContainerObjectStore = storeProvider.getObjectStore();
        QGEncodedSamplesContainer qgEncodedSamplesContainer = (QGEncodedSamplesContainer)qgEncodedSamplesContainerObjectStore.get(smartsModule.getId());
        if (null == qgEncodedSamplesContainer) {
            throw new InternalException("QG Encoded Samples container is null for smartsModuleId : {0}", new Object[]{smartsModule.getId()});
        }
        qgEncodedSamplesContainer.getDataSetEncodedSamples().values().stream().forEach(qgEncodedSamplesList -> unifiedQGEncodedSamples.addAll(qgEncodedSamplesList));
        return Collections.emptyList();
    }
}

